<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

class SppagebuilderAddonClients extends SppagebuilderAddons {

	public function render() {

		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$columns = (isset($settings->count) && $settings->count) ? $settings->count : 2;
		$item_padding = (isset($settings->item_padding) && $settings->item_padding) ? $settings->item_padding : '';
		$carousel_enable = (isset($settings->carousel_enable) && $settings->carousel_enable) ? $settings->carousel_enable : 0;
		$carousel_nav = (isset($settings->carousel_nav) && $settings->carousel_nav) ? $settings->carousel_nav : 0;
		$carousel_dots = (isset($settings->carousel_dots) && $settings->carousel_dots) ? $settings->carousel_dots : 0;
		$page_limit = (isset($settings->page_limit) && $settings->page_limit) ? $settings->page_limit : 4;
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';
		$item_border = (isset($settings->item_border)) ? $settings->item_border : '';
		$item_border_color = (isset($settings->item_border_color)) ? $settings->item_border_color : 'rgba(255, 255, 255, 0.1)';
		$sp_clients_item = $settings->sp_clients_item;
		$addon_id = '#sppb-addon-' . $this->addon->id;

		$spancolumn =   str_replace('sppb-col-sm-','', $columns);
		$numbercolumn   =   12/$spancolumn;

		$css = '';
		if ($item_border) {
			$css .= $addon_id . ' .sppb-addon-clients .sppb-row > div {';
			$css .= 'border-top: '.$item_border.'px solid '.$item_border_color.'; border-right: '.$item_border.'px solid '.$item_border_color.';';
			$css .= '}';
			$css .= $addon_id . ' .sppb-addon-clients .sppb-row > div:last-child {';
			$css .= 'border-right: none;';
			$css .= '}';
			$css .= $addon_id . ' .sppb-addon-clients .sppb-row > div:nth-child('.$numbercolumn.'n) {';
			$css .= 'border-right: none;';
			$css .= '}';
		}

		if ($item_padding) {
			$css .= $addon_id . ' .sppb-addon-clients .sppb-client-item {';
			$css .= 'padding: '.$item_padding.';';
			$css .= '}';
		}

		$doc = JFactory::getDocument();
		$doc->addStyleDeclaration($css);

		$output  = '<div class="sppb-addon sppb-addon-clients ' . $alignment . ' ' . $class . '">';

		if($title) {
			$output .= '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>';
		}

		$output .= $carousel_enable ? '<div class="sppb-addon-content owl-carousel owl-theme">' : '<div class="sppb-addon-content">';
		if ($carousel_enable) {
			$doc->addStyleSheet('templates/tz_jollyany/assets/owl.carousel.min.css');
			$doc->addStyleSheet('templates/tz_jollyany/assets/owl.theme.default.min.css');
			$doc->addScript('templates/tz_jollyany/assets/owl.carousel.min.js');
			$sp_clients_item    =   array_chunk($sp_clients_item, $page_limit);
			if (count($sp_clients_item)) {
				foreach ($sp_clients_item as $key => $value) {
					$output .= '<div class="sppb-row">';
					$output .= $this->getItem($value, $settings);
					$output .= '</div>';
				}
			}
		} else {
			$output .= '<div class="sppb-row">';
			$output .= $this->getItem($sp_clients_item, $settings);
			$output  .= '</div>';
		}

		$output  .= '</div>';
		if ($carousel_enable) {
			$carousel_options       =   array();
			$carousel_options[]     =   $carousel_nav ? 'nav: true' : 'nav: false';
			$carousel_options[]     =   $carousel_dots ? 'dots: true' : 'dots: false';
			$carousel_options       =   implode(',', $carousel_options);
			$output .= '<script type="text/javascript">
    jQuery(document).ready(function(){
        jQuery(\''.$addon_id.' .sppb-addon-content\').owlCarousel({
            loop:true,
            items: 1,
            '.$carousel_options.'
        })
    });
</script>';
		}
		$output  .= '</div>';

		return $output;
	}

	protected function getItem($sp_clients_item, $settings) {
		$output = '';
		$columns = (isset($settings->count) && $settings->count) ? $settings->count : 2;
		$spancolumn =   str_replace('sppb-col-sm-','', $columns);
		$numbercolumn   =   12/$spancolumn;
		foreach ($sp_clients_item as $key => $value) {
			if(isset($value->image) && $value->image) {
				$output .= ($key < $numbercolumn) ? '<div class="' . $columns . ' no-border-top">' : '<div class="' . $columns . '">';
				$output .= '<div class="sppb-client-item">';
				if(isset($value->url) && $value->url) $output .= '<a '.(isset($value->url_same_window) && $value->url_same_window ? '' : 'target="_blank" rel="noopener noreferrer"').' rel="nofollow" href="'. $value->url .'">';
				$output .= '<img class="sppb-img-responsive" src="' . $value->image . '" alt="' . $value->title . '">';
				if(isset($value->url) && $value->url) $output .= '</a>';
				$output .= '</div>';
				$output .= '</div>';
			}
		}
		return $output;
	}

	public static function getTemplate(){
		$output = '
		<div class="sppb-addon sppb-addon-clients {{ data.class }} {{ data.alignment }}">
			<# if( !_.isEmpty( data.title ) ){ #><{{ data.heading_selector }} class="sppb-addon-title sp-inline-editable-element" data-id={{data.id}} data-fieldName="title" contenteditable="true">{{ data.title }}</{{ data.heading_selector }}><# } #>
			<div class="sppb-addon-content">
				<div class="sppb-row">
					<# _.each(data.sp_clients_item, function(clients_item, key){ #>
						<# if(clients_item.image){ #>
							<div class="{{ data.count }}">
								<# if(clients_item.url){ #><a {{(clients_item.url_same_window ? "" : \'target=_blank\')}} rel="nofollow" href=\'{{clients_item.url}}\'><# } #>
									<# if(clients_item.image && clients_item.image.indexOf("https://") == -1 && clients_item.image.indexOf("http://") == -1){ #>
										<img class="sppb-img-responsive" src=\'{{ pagebuilder_base + clients_item.image }}\' alt="{{ clients_item.title }}">
									<# } else if(clients_item.image){ #>
										<img class="sppb-img-responsive" src=\'{{ clients_item.image }}\' alt="{{ clients_item.title }}">
									<# } #>
								<# if(clients_item.url){ #></a><# } #>
							</div>
						<# } #>
					<# }); #>
				</div>
			</div>
		</div>
		';

		return $output;
	}
}
