<?php
/**
 * @package   Astroid Framework
 * @author    JoomDev https://www.joomdev.com
 * @copyright Copyright (C) 2009 - 2019 JoomDev.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined('_JEXEC') or die;
?>
<div class="latestnews-media">
   <ul class="list-group list-group-flush">
      <?php foreach ($list as $item) : $image = json_decode($item->images); ?>
      <li itemscope itemtype="https://schema.org/Article" class="list-group-item px-0">
         <?php if($image->image_intro != "") : ?>
            <a class="article-media" href="<?php echo $item->link; ?>" itemprop="url">
               <img class="card-img" src="<?php echo JURI::root().$image->image_intro; ?>" alt="<?php echo htmlspecialchars($image->image_fulltext_alt); ?>">
            </a>
         <?php endif; ?>
          <div class="information">
              <a class="article-title" href="<?php echo $item->link; ?>" itemprop="url">
                  <h6 itemprop="name"><?php echo $item->title; ?></h6>
              </a>
              <div class="info muted">
                  <div class="created mr-3">
                      <i class="far fa-clock mr-1"></i>
                      <time><?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC3')); ?></time>
                  </div>
                  <div class="hits">
                      <i class="far fa-eye mr-1"></i>
			          <?php echo $item->hits; ?>
                  </div>
              </div>
          </div>
      </li>
      <?php endforeach; ?>
   </ul>
</div>