<?php
/**
 * @package Varsita
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2015 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('resticted aceess');

class SppagebuilderAddonSlideshow_full extends SppagebuilderAddons {
    public function render() {

      $settings = $this->addon->settings;

      $autoplay     = ( isset($settings->autoplay) && $settings->autoplay ) ? $settings->autoplay : '';
      $controllers  = ( isset($settings->controllers) && $settings->controllers ) ? $settings->controllers : '';
      $arrows       = ( isset($settings->arrows) && $settings->arrows ) ? $settings->arrows : '';
      $class        = ( isset($settings->class) && $settings->class ) ? ' '.$settings->class : '';

      //Check Auto Play
    	$slide_autoplay = ($autoplay)? 'data-sppb-slide-ride="true"':'';
    	$slide_controllers = ($controllers)? 'data-sppb-slidefull-controllers="true"':'';

    	$output  = '<div class="sppb-slider-wrapper sppb-slider-fullwidth-wrapper owl-theme' . $class . '">';
    	$output .= '<div class="sppb-slider-item-wrapper">';
    	$output .= '<div class="slide-fullwidth owl-carousel" ' . $slide_controllers .' ' .$slide_autoplay.' >';

    	foreach ( $settings->sp_slideshow_full_item as $key => $slide ) {

        $title              = ( isset($slide->title) && $slide->title ) ? $slide->title : '';
        $sub_title          = ( isset($slide->sub_title) && $slide->sub_title ) ? $slide->sub_title : '';
        $bg                 = ( isset($slide->bg) && $slide->bg ) ? $slide->bg : '';
        $content            = ( isset($slide->content) && $slide->content ) ? $slide->content : '';
        $button_text        = ( isset($slide->button_text) && $slide->button_text ) ? $slide->button_text : '';
        $button_url         = ( isset($slide->button_url) && $slide->button_url ) ? $slide->button_url : '';
        $button_size        = ( isset($slide->button_size) && $slide->button_size ) ? $slide->button_size : '';
        $button_type        = ( isset($slide->button_type) && $slide->button_type ) ? $slide->button_type : '';
        $button_before_icon = ( isset($slide->button_before_icon) && $slide->button_before_icon ) ? $slide->button_before_icon : '';
        $button_after_icon  = ( isset($slide->button_after_icon) && $slide->button_after_icon ) ? $slide->button_after_icon : '';

        // if have bg then add class
        $bg_image = ($bg) ? 'style="background-image: url(' . JURI::base() . $bg . ');"': '';
        $button_before_icon  = ($button_before_icon) ? '<i class="fa ' . $button_before_icon . '"></i>' : '';
        $button_after_icon  = ($button_after_icon) ? '<i class="fa ' . $button_after_icon . '"></i>' : '';

        $output  .= '<div class="sppb-slideshow-fullwidth-item item">';
        $output  .= '<div class="sppb-slideshow-fullwidth-item-bg" '.$bg_image.'>';
        $output  .= '<div class="container">';
        $output  .= '<div class="sppb-slideshow-fullwidth-item-text">';

        if(($title) || ($content) ) {
          if($title){
            $output  .= '<h1 class="sppb-fullwidth-title">' . $title . ' <small class="sppb-slidehsow-sub-title">'.$sub_title.'</small></h1>';
          }

          if ($content) {
             $output  .= '<p class="details">' . $content . '</p>';
          }

          if ($button_text && $button_url) {
            if($button_text && $button_url) {
              $output  .= '<a href="' . $button_url . '" class="sppb-slideshow-fullwidth-read-more">' . $button_before_icon. $button_text . $button_after_icon . '</a>';
            }
          }
        }

        $output  .= '</div>'; // END:: /.sppb-slideshow-item-content
        $output  .= '</div>'; // END:: /.sppb-slideshow-item-content
        $output  .= '</div>'; // END:: /.sppb-slideshow-item
        $output  .= '</div>'; // END:: /.sppb-slideshow-item
    	}

    	$output .= '</div>'; //END:: /.sppb-slider-items
    	$output .= '</div>'; // END:: /.sppb-slider-item-wrapper

    	// has next/previous arrows
    	if ($arrows){
    		$output .= '<div class="customNavigation">';
    		$output .= '<a class="sppbSlidePrev"><i class="fa fa-angle-left"></i></a>';
    		$output .= '<a class="sppbSlideNext"><i class="fa fa-angle-right"></i></a>';
    		$output .= '</div>'; // END:: /.customNavigation
    	}

    	// has dot controls
    	if ($controllers) {
  		    $output .='<div class="owl-dots">';
          $output .='<div class="owl-dot active"><span></span></div>';
          $output .='<div class="owl-dot"><span></span></div>';
          $output .='<div class="owl-dot"><span></span></div>';
          $output .='</div>';
      }

      $output .='</div>';

    	return $output;
    }

    public function scripts() {
      $app = JFactory::getApplication();
      $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';

      return array($base_path . 'owl.carousel.min.js');
  	}

  	public function stylesheets() {
      $app = JFactory::getApplication();
      $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';

  		return array(
          $base_path . 'owl.carousel.css',
          $base_path . 'owl.theme.css',
          $base_path . 'owl.transitions.css',
          $base_path . 'slide-animate.css'
        );
  	}

    public function css() {
  		$addon_id = '#sppb-addon-' . $this->addon->id;
      $settings = $this->addon->settings;
  		$css = '';

      $slideStyle     = (isset($settings->background) && $settings->background ) ? 'background: '.$settings->background.';' : '';
      $slideStyle     .= (isset($settings->color) && $settings->color ) ? 'color: '.$settings->color .';' : '';

      if($slideStyle) {
				$css .= $addon_id . ' .sppb-slider-item-wrapper {';
				$css .= $slideStyle;
				$css .= '}';
			}
      return $css;
  	}

    public function js(){
      $addon_id = '#sppb-addon-' . $this->addon->id;
      return 'jQuery( document ).ready(function( $ ) {
        var $slideFullwidth = $("'. $addon_id .' .slide-fullwidth");

        // Autoplay
        var $autoplay   = $slideFullwidth.attr("data-sppb-slide-ride");
        if ($autoplay == "true") { var $autoplay = true; } else { var $autoplay = false};

        // controllers
        var $controllers   = $slideFullwidth.attr("data-sppb-slide-controllers");
        if ($controllers == "true") { var $controllers = true; } else { var $controllers = false};


        $slideFullwidth.owlCarousel({
            margin: 0,
            loop: true,
            autoplay: $autoplay,
            animateIn: "fadeInRight",
            animateOut: "fadeOutLeft",
            responsive: {
                0: {
                    items: 1
                },
                600: {
                    items: 1
                },
                1000: {
                    items: 1
                }
            },
            dots: $controllers,
        });


        $("'. $addon_id .' .sppbSlidePrev").click(function(){
            $slideFullwidth.trigger("prev.owl.carousel", [400]);
        });

        $("'. $addon_id .' .sppbSlideNext").click(function(){
            $slideFullwidth.trigger("next.owl.carousel",[400]);
        });
      });';
    } 

    public static function getTemplate(){
      $output = '
      <#

    	let slide_autoplay = !_.isEmpty(data.autoplay)? \'data-sppb-slide-ride="true"\':"";
      let slide_controllers = !_.isEmpty(data.controllers)? \'data-sppb-slidefull-controllers="true"\':"";
      #>

    	<div class="sppb-slider-wrapper sppb-slider-fullwidth-wrapper owl-theme {{data.class}}">
    	<div class="sppb-slider-item-wrapper">
    	<div class="slide-fullwidth owl-carousel" {{slide_controllers}} {{slide_autoplay}}>

    	<# _.each ( data.sp_slideshow_full_item, function(slide) {
        var button_before_icon  = !_.isEmpty(data.button_before_icon) ? \'<i class="fa \' + data.button_before_icon + \'"></i>\' : "";
        var button_after_icon  =  !_.isEmpty(data.button_after_icon) ? \'<i class="fa \' + data.button_after_icon + \'"></i>\' : "";
      #>

        <div class="sppb-slideshow-fullwidth-item item">
        <div class="sppb-slideshow-fullwidth-item-bg" style="background-image: url({{slide.bg}})">
        <div class="container">
        <div class="sppb-slideshow-fullwidth-item-text">

        <# if((!_.isEmpty(data.title)) || (!_.isEmpty(data.content)) ) {
          if(!_.isEmpty(data.title)){ #>
            <h1 class="sppb-fullwidth-title">{{{data.title}}} <small class="sppb-slidehsow-sub-title">{{{data.sub_title}}}</small></h1>
          <# } #>

          <# if (!_.isEmpty(data.content)) { #>
             <p class="details">{{{data.content}}}</p>
          <# } #>

          <# if (!_.isEmpty(data.button_text) && !_.isEmpty(data.button_url)) {
            if (!_.isEmpty(data.button_text) && !_.isEmpty(button_url)) { #>
              <a href="{{data.button_url}}" class="sppb-slideshow-fullwidth-read-more">{{button_before_icon}} {{data.button_text}} {{button_after_icon}}</a>
            <# }
          }
        } #>

        </div>
        </div>
        </div>
        </div>
    	<# }) #>

    	</div>
    	</div>

    	<# if (!_.isEmpty(data.arrows)){ #>
    		<div class="customNavigation">
    		<a class="sppbSlidePrev"><i class="fa fa-angle-left"></i></a>
    		<a class="sppbSlideNext"><i class="fa fa-angle-right"></i></a>
    		</div>
    	<# } #>

    	<# if (slide_controllers) { #>
  		    <div class="owl-dots">
          <div class="owl-dot active"><span></span></div>
          <div class="owl-dot"><span></span></div>
          <div class="owl-dot"><span></span></div>
          </div>
      <# } #>

      </div>
      ';
      return $output;
    }
}
