<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

$roomTypeId = $displayData['roomTypeId'];
$roomType = $displayData['roomType'];
for ($i = 0; $i < $displayData['quantity']; $i++) :
	$currentRoomIndex = NULL;
	if (isset($displayData['reservationDetails']->room['room_types'][$roomTypeId][$displayData['tariffId']][$i])) :
		$currentRoomIndex = $displayData['reservationDetails']->room['room_types'][$roomTypeId][$displayData['tariffId']][$i];
	endif;
	$identity = $roomType->id . '_' . $displayData['tariffId'] . '_' . $i;

	// Html for adult selection
	$htmlAdultSelection = '';
	if (!isset($displayData['roomType']->params['show_adult_option'])) :
		$displayData['roomType']->params['show_adult_option'] = 1;
	endif;
	if ($displayData['roomType']->params['show_adult_option'] == 1) :
		$htmlAdultSelection .= '<option value="">' . JText::_('SR_ADULT') . '</option>';
		for ($j = 1; $j <= $displayData['roomType']->occupancy_adult; $j++) :
			$disabled = '';
			$selected = '';
			if (isset($currentRoomIndex['adults_number'])) :
				$selected = $currentRoomIndex['adults_number'] == $j ? 'selected' : '';
			else :
				if (!empty($displayData['tariff']->p_min)) :
					if ($j == $displayData['tariff']->p_min) :
						$selected = 'selected';
					endif;
				else :
					if ($j == 1) :
						$selected = 'selected';
					endif;
				endif;
			endif;

			if (!empty($displayData['tariff']->p_min) && $j < $displayData['tariff']->p_min ) :
				$disabled = 'disabled';
			endif;

			if (!empty($displayData['tariff']->p_max) && $j > $displayData['tariff']->p_max ) :
				$disabled = 'disabled';
			endif;
			$htmlAdultSelection .= '<option ' . $disabled . ' ' . $selected . ' value="' . $j . '">' . JText::plural('SR_SELECT_ADULT_QUANTITY', $j) . '</option>';
		endfor;
	endif;

	// Html for children selection
	$htmlChildSelection = '';
	$htmlChildrenAges = '';
	if (!isset($displayData['roomType']->params['show_child_option'])) :
		$displayData['roomType']->params['show_child_option'] = 1;
	endif;

	// Only show child option if it is enabled and the child quantity > 0
	if ($displayData['roomType']->params['show_child_option'] == 1 && $displayData['roomType']->occupancy_child > 0) :
		$htmlChildSelection .= '<option value="">' . JText::_('SR_CHILD') . '</option>';

		for ($j = 1; $j <= $displayData['roomType']->occupancy_child; $j++) :
			if (isset($currentRoomIndex['children_number'])) :
				$selected = $currentRoomIndex['children_number'] == $j ? 'selected' : '';
			endif;
			$htmlChildSelection .= '
				<option ' . $selected . ' value="' . $j . '">' . JText::plural('SR_SELECT_CHILD_QUANTITY', $j) . '</option>
			';
		endfor;

		// Html for children ages
		if (isset($currentRoomIndex['children_ages'])) :
			for ($j = 0; $j < count($currentRoomIndex['children_ages']); $j++) :
				$htmlChildrenAges .= '
					<li>
						' . JText::_('SR_CHILD') . ' ' . ($j + 1) . '
						<select name="jform[room_types][' . $roomTypeId . '][' . $displayData['tariffId'] .'][' . $i . '][children_ages][]"
							data-raid="' . $displayData['assetId'] . '"
							data-roomtypeid="' . $roomTypeId . '"
							data-tariffid="' . $displayData['tariffId'] . '"
							data-roomindex="' . $i . '"
							class="span6 child_age_' . $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i . '_' . $j . ' trigger_tariff_calculating"
							required
						>';
				$htmlChildrenAges .= '<option value=""></option>';
				for ($age = 1; $age <= $displayData['childMaxAge']; $age ++) :
					$selectedAge = '';
					if ($age == $currentRoomIndex['children_ages'][$j]) :
						$selectedAge = 'selected';
					endif;
					$htmlChildrenAges .= '<option '.$selectedAge.' value="'.$age.'">'.JText::plural('SR_CHILD_AGE_SELECTION', $age).'</option>';
				endfor;

				$htmlChildrenAges .= '
						</select>
					</li>';
			endfor;
		endif;
	endif;

	// Smoking
	$htmlSmokingOption = '';
	if (!isset($displayData['roomType']->params['show_smoking_option'])) :
		$displayData['roomType']->params['show_smoking_option'] = 1;
	endif;

	if ($displayData['roomType']->params['show_smoking_option'] == 1) :
		$selectedNonSmoking = '';
		$selectedSmoking = '';
		if (isset($currentRoomIndex['preferences']['smoking'])) :
			if ($currentRoomIndex['preferences']['smoking'] == 0) :
				$selectedNonSmoking = 'selected';
			else :
				$selectedSmoking = 'selected';
			endif;
		endif;
		$htmlSmokingOption = '
			<select class="span10" name="jform[room_types][' . $roomTypeId . '][' . $displayData['tariffId'] . '][' . $i . '][preferences][smoking]">
				<option value="">' . JText::_('SR_SMOKING') . '</option>
				<option ' . $selectedNonSmoking . ' value="0">' . JText::_('SR_NON_SMOKING_ROOM') . '</option>
				<option ' . $selectedSmoking . ' value="1">' . JText::_('SR_SMOKING_ROOM') . '</option>
			</select>
		';
	endif;

	if (!isset($displayData['roomType']->params['show_guest_name_field'])) :
		$displayData['roomType']->params['show_guest_name_field'] = 1;
	endif;
	?>

	<div class="row-fluid">
		<div class="room-type-form-wrapper">
			<div class="row">
				<div class="col-sm-6">
					<div class="room-type-form-price">
						<h4><?php echo JText::_('SR_ROOM') . ' ' . ($i + 1) ?>: <span
								class="tariff_<?php echo $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i ?>">0</span>

							<a href="javascript:void(0)"
							   class="toggle_breakdown"
								data-target="<?php echo $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i ?>">
								<?php echo JText::_('SR_VIEW_TARIFF_BREAKDOWN') ?>
							</a>
							<span style="display: none" class="breakdown" id="breakdown_<?php echo $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i ?>">

							</span>
						</h4>
					</div>
				</div>
				<div class="col-sm-6">
					<div class="adult-child-wrapper">
						<div class="row-fluid occupancy-selection">
							<div class="inner">
								<?php if ($displayData['roomType']->params['show_adult_option'] == 1) : ?>
								<select
									data-raid="<?php echo $displayData['assetId'] ?>"
									data-roomtypeid="<?php echo $roomTypeId ?>"
									data-tariffid="<?php echo $displayData['tariffId'] ?>"
									data-adjoininglayer="<?php echo $displayData['adjoiningLayer'] ?>"
									data-roomindex="<?php echo $i ?>"
									data-max="<?php echo $displayData['roomType']->occupancy_max ?>"
									name="jform[room_types][<?php echo $roomTypeId ?>][<?php echo $displayData['tariffId'] ?>][<?php echo $i ?>][adults_number]"
									required
									data-identity="<?php echo $identity ?>"
									class="col-sm-3 adults_number occupancy_max_constraint occupancy_max_constraint_<?php echo $i ?>_<?php echo $displayData['tariffId'] ?>_<?php echo $roomTypeId ?> occupancy_adult_<?php echo $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i ?> trigger_tariff_calculating">
									<?php echo $htmlAdultSelection ?>
								</select>
								<?php else : ?>
								<input type="hidden"
								       data-raid="<?php echo $displayData['assetId'] ?>"
								       data-roomtypeid="<?php echo $roomTypeId ?>"
								       data-tariffid="<?php echo $displayData['tariffId'] ?>"
								       data-adjoininglayer="<?php echo $displayData['adjoiningLayer'] ?>"
								       data-roomindex="<?php echo $i ?>"
								       data-max="<?php echo $displayData['roomType']->occupancy_max ?>"
								       name="jform[room_types][<?php echo $roomTypeId ?>][<?php echo $displayData['tariffId'] ?>][<?php echo $i ?>][adults_number]"
								       class="col-sm adults_number occupancy_max_constraint occupancy_max_constraint_<?php echo $i ?>_<?php echo $displayData['tariffId'] ?>_<?php echo $roomTypeId ?> occupancy_adult_<?php echo $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i ?> trigger_tariff_calculating"
									   value="1"
								       data-identity="<?php echo $identity ?>"
								       />
								<?php endif ?>
								<?php if ($displayData['roomType']->params['show_child_option'] == 1 && $displayData['roomType']->occupancy_child > 0) : ?>
								<select
									data-raid="<?php echo $displayData['assetId'] ?>"
									data-roomtypeid="<?php echo $roomTypeId ?>"
									data-roomindex="<?php echo $i ?>"
									data-max="<?php echo $roomType->occupancy_max ?>"
									data-tariffid="<?php echo $displayData['tariffId'] ?>"
									data-adjoininglayer="<?php echo $displayData['adjoiningLayer'] ?>"
									data-identity="<?php echo $identity ?>"
									name="jform[room_types][<?php echo $roomTypeId ?>][<?php echo $displayData['tariffId'] ?>][<?php echo $i ?>][children_number]"
									class="col-sm-3 children_number occupancy_max_constraint occupancy_max_constraint_<?php echo $i ?>_<?php echo $displayData['tariffId'] ?>_<?php echo $roomTypeId ?> reservation-form-child-quantity trigger_tariff_calculating occupancy_child_<?php echo $roomTypeId . '_' . $displayData['tariffId'] . '_' . $i ?>">
									<?php echo $htmlChildSelection ?>
								</select>
								<?php endif ?>

								<div
									class="span12 child-age-details <?php echo(empty($htmlChildrenAges) ? 'nodisplay' : '') ?>">
									<p><?php echo JText::_('SR_AGE_OF_CHILD_AT_CHECKOUT') ?></p>
									<ul class="unstyled"><?php echo $htmlChildrenAges ?></ul>
								</div>
							</div>
						</div>
					</div>

					<div class="gname-button-wrapper">
						<div class="inner">
							<?php if ($displayData['roomType']->params['show_guest_name_field'] == 1) : ?>
							<input name="jform[room_types][<?php echo $roomTypeId ?>][<?php echo $displayData['tariffId'] ?>][<?php echo $i ?>][guest_fullname]"
								   required
								   type="text"
								   value="<?php echo(isset($currentRoomIndex['guest_fullname']) ? $currentRoomIndex['guest_fullname'] : '') ?>"
								   class="span10"
								   placeholder="<?php echo JText::_('SR_GUEST_NAME') ?>"/>
							<?php endif ?>

							<?php echo $htmlSmokingOption ?>

							<!-- has extra data -->
							<?php if($displayData['extras'] && isset($displayData['extras'])){ ?>

							<ul class="unstyled">
								<?php
								foreach ($displayData['extras'] as $extra) :
									$extraInputCommonName = 'jform[room_types][' . $roomTypeId . '][' . $displayData['tariffId'] . '][' . $i . '][extras][' . $extra->id . ']';
									$checked = '';
									$disabledCheckbox = '';
									$disabledSelect = 'disabled="disabled"';
									$alreadySelected = false;
									if (isset($currentRoomIndex['extras'])) :
										$alreadySelected = array_key_exists($extra->id, (array)$currentRoomIndex['extras']);
									endif;

									if ($extra->mandatory == 1 || $alreadySelected) :
										$checked = 'checked="checked"';
									endif;

									if ($extra->mandatory == 1) :
										$disabledCheckbox = 'disabled="disabled"';
										$disabledSelect = 'disabled="disabled"';
									endif;

									if ($alreadySelected && $extra->mandatory == 0) :
										$disabledSelect = '';
									endif;
									?>
									<li class="extras_row_roomtypeform">
										<input <?php echo $checked ?> <?php echo $disabledCheckbox ?> type="checkbox"
																									  data-target="extra_<?php echo $displayData['tariffId'] ?>_<?php echo $i ?>_<?php echo $extra->id ?>"/>
										<?php if ($extra->mandatory == 1) : ?>
											<input type="hidden" name="<?php echo $extraInputCommonName ?>[quantity]"
												   value="1"/>
										<?php endif ?>

										<select class="span2 extra_<?php echo $displayData['tariffId'] ?>_<?php echo $i ?>_<?php echo $extra->id ?>"
												name="<?php echo $extraInputCommonName ?>[quantity]"
											<?php echo $disabledSelect ?>>
											<?php
											for ($quantitySelection = 1; $quantitySelection <= $extra->max_quantity; $quantitySelection++) :
												$checked = '';
												if (isset($currentRoomIndex['extras'][$extra->id]['quantity'])) :
													$checked = ($currentRoomIndex['extras'][$extra->id]['quantity'] == $quantitySelection) ? 'selected' : '';
												endif;
											?>
												<option <?php echo $checked ?> value="<?php echo $quantitySelection ?>"><?php echo $quantitySelection ?></option>
											<?php
											endfor;
											?>
										</select>
										<span>
											<?php echo $extra->name ?>
											<a href="javascript:void(0)"
											   class="toggle_extra_details"
											   data-target="extra_details_<?php echo $displayData['tariffId'] ?>_<?php echo $i ?>_<?php echo $extra->id ?>">
												<?php echo JText::_('SR_EXTRA_MORE_DETAILS') ?>
											</a>
										</span>
										<span class="extra_details" id="extra_details_<?php echo $displayData['tariffId'] ?>_<?php echo $i ?>_<?php echo $extra->id ?>" style="display: none">
											<?php if ($extra->charge_type == 3 || $extra->charge_type == 5 || $extra->charge_type == 6) : ?>
											<span>
												<?php echo JText::_('SR_EXTRA_PRICE_ADULT') . ': ' . $extra->currencyAdult->format() .' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) .')' ?>
											</span>
											<span>
												<?php echo JText::_('SR_EXTRA_PRICE_CHILD') . ': ' . $extra->currencyChild->format() .' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) .')' ?>
											</span>
											<?php else:  ?>
											<span>
												<?php echo JText::_('SR_EXTRA_PRICE') . ': ' . $extra->currency->format() .' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) .')' ?>
											</span>
											<?php endif; ?>

											<span>
												<?php echo $extra->description ?>
											</span>
										</span>
									</li>
								<?php
								endforeach;
								?>
							</ul>
							<?php } ?>
						</div>

						<div class="roomtype-button-wrapper">
							<button data-step="room" type="submit" class="btn span10 btn-primary">
								<i class="icon-arrow-right uk-icon-arrow-right fa-arrow-right"></i>
								<?php echo JText::_('SR_NEXT') ?>
							</button>
						</div> <!-- /.roomtype-button-wrapper -->

					</div>
				</div> <!-- /.col-sm-6 -->
			</div> <!-- /.row /.roomtypeform -->

		</div>
	</div>
<?php
endfor;




