<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2018 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

echo SRLayoutHelper::render( 'asset.coupon_form', array(
	'asset'   => $this->item,
	'coupon'  => $this->coupon,
	'isFresh' => $this->isFresh
) );

?>

<a name="form"></a>

<?php if (!empty($this->item->email) || !empty($this->item->params['show_inquiry_form'])): ?>
	<?php echo $this->loadTemplate('inquiry_form'); ?>
<?php endif; ?>
<?php if (isset($this->item->params['show_inline_checkavailability_form'])
	&& $this->item->params['show_inline_checkavailability_form'] == 1
	&& !$this->disableOnlineBooking
) : ?>
<div id="asset-checkavailability-form">
	<div class="inner">
		<?php echo $this->loadTemplate('checkavailability'); ?>
	</div>
</div>
<?php endif ?>

<div class="wizard">
	<ul class="row-fluid steps">
		<li data-target="#step1" class="active reservation-tab reservation-tab-room span4">
			<i class="fa fa-bed"></i>
			<div class="steps-text-wrapper">
				<p><small><?php echo JText::_('SR_STEP_ONE'); ?></small><?php echo JText::_('SR_STEP_ROOM_AND_RATE') ?></p>
				<!-- <span class="chevron"></span> -->
			</div>
		</li>
		<li data-target="#step2" class="reservation-tab reservation-tab-guestinfo span4">
			<i class="fa fa-credit-card"></i>
			<div class="steps-text-wrapper">
				<p><small><?php echo JText::_('SR_STEP_TWO'); ?></small><?php echo JText::_('SR_STEP_GUEST_INFO_AND_PAYMENT') ?></p>
				<!-- <span class="chevron"></span> -->
			</div>
		</li>
		<li data-target="#step3" class="reservation-tab reservation-tab-confirmation span4">
			<i class="fa fa-check-square"></i>
			<div class="steps-text-wrapper">
				<!-- <span class="badge">3</span> -->
				<p><small><?php echo JText::_('SR_STEP_THREE'); ?></small> <?php echo JText::_('SR_STEP_CONFIRMATION') ?></p>
				<!--<span class="chevron"></span>-->
			</div>
		</li>
	</ul>
</div>

<div class="step-content">
	<div class="step-pane active" id="step1">
	<!-- Tab 1 -->
	<div class="reservation-single-step-holder room">
	<?php echo $this->loadTemplate('searchinfo'); ?>
	<form enctype="multipart/form-data"
		  id="sr-reservation-form-room"
		  class="sr-reservation-form"
		  action="<?php echo JUri::base() ?>index.php?option=com_solidres&task=reservation.process&step=room&format=json"
		  method="POST">
	<?php if (count($this->item->roomTypes) > 0) : ?>
		<?php if (!$this->isFresh) : ?>
			<div class="button-row button-row-top">
				<div class="col-sm-9">
					<div class="inner">
						<p><?php echo JText::_('SR_ROOMINFO_STEP_NOTICE_MESSAGE') ?></p>
					</div>
				</div>
				<div class="col-sm-3">
					<div class="btn-group">
						<button data-step="room" type="submit" class="btn btn-success">
							<i class="icon-arrow-right uk-icon-arrow-right fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
						</button>
					</div>
				</div>
			</div>
		<?php endif ?>

		<?php
		$count = 1;
		foreach($this->item->roomTypes as $roomType ) :
			if (isset($roomType->defaultTariffBreakDown)) :
				$defaultTariffBreakDownHtml = '<table class=\"tariff-break-down\">';
				foreach ($roomType->defaultTariffBreakDown as $key => $breakDownDetails ) :
					if ($key % 7 == 0 && $key == 0) :
						$defaultTariffBreakDownHtml .= '<tr>';
					elseif ($key % 7 == 0) :
						$defaultTariffBreakDownHtml .= '</tr><tr>';
					endif;
					$tmpKey = key($breakDownDetails);
					$defaultTariffBreakDownHtml .= '<td><p>'.$this->dayMapping[$tmpKey].'</p><span class=\"'.$this->tariffNetOrGross.'\">'.$breakDownDetails[$tmpKey][$this->tariffNetOrGross]->format().'</span>';
				endforeach;
				$defaultTariffBreakDownHtml .= '</tr></table>';

				$this->document->addScriptDeclaration('
					Solidres.jQuery(function($){
						$(".default_tariff_break_down_'.$roomType->id.'").popover({
							html: true,
							content: "'.$defaultTariffBreakDownHtml.'",
							title: "'.JText::_('SR_TARIFF_BREAK_DOWN').'",
							placement: "bottom",
							trigger: "click"
						});
					});
				');
			endif;

			if (isset($roomType->complexTariffBreakDown)) :
				$complexTariffBreakDownHtml = '<table class=\"tariff-break-down\">';
				foreach ($roomType->complexTariffBreakDown as $key => $breakDownDetails ) :
					if ($key % 7 == 0 && $key == 0) :
						$complexTariffBreakDownHtml .= '<tr>';
					elseif ($key % 7 == 0) :
						$complexTariffBreakDownHtml .= '</tr><tr>';
					endif;
					$tmpKey = key($breakDownDetails);
					$complexTariffBreakDownHtml .= '<td><p>'.$this->dayMapping[$tmpKey].'</p><span class=\"'.$this->tariffNetOrGross.'\">'.$breakDownDetails[$tmpKey][$this->tariffNetOrGross]->format().'</span>';
				endforeach;

				$complexTariffBreakDownHtml .= '</tr></table>';
				$this->document->addScriptDeclaration('
					Solidres.jQuery(function($){
						$(".complex_tariff_break_down_'.$roomType->id.'").popover({
							html: true,
							content: "'.$complexTariffBreakDownHtml.'",
							title: "'.JText::_('SR_TARIFF_BREAK_DOWN').'",
							placement: "bottom",
							trigger: "click"
						});
					});
				');
			endif;

			$this->document->addScriptDeclaration('
				Solidres.jQuery(function($){
					$(".sr-photo-'.$roomType->id.'").colorbox({rel:"sr-photo-'.$roomType->id.'", transition:"fade", width: "98%", height: "98%", className: "colorbox-w"});
					$(".carousel").carousel();
				});
			');

			$rowCSSClass = ($count % 2) ? ' even' : ' odd';
			$rowCSSClass .= $roomType->featured == 1 ? ' featured' : '';
			$currentSelectedRoomNumberPerTariff = array();

			if (!is_array($roomType->params)) :
				$roomType->params = json_decode($roomType->params, true);
			endif;

			$skipRoomForm = false;
			if (isset($roomType->params['skip_room_form']) && $roomType->params['skip_room_form'] == 1) :
				$skipRoomForm = true;
			endif;

			$isExclusive = false;
			if (isset($roomType->params['is_exclusive']) && $roomType->params['is_exclusive'] == 1) :
				$isExclusive = true;
			endif;

			$showRemainingRooms = true;
			if (isset($roomType->params['show_number_remaining_rooms']) && $roomType->params['show_number_remaining_rooms'] == 0) :
				$showRemainingRooms = false;
			endif;

			$showMoreInfo = true;
			if (isset($roomType->params['show_more_info_button']) && $roomType->params['show_more_info_button'] == 0) :
				$showMoreInfo = false;
			endif;

			$roomType->text = $roomType->description;
			JFactory::getApplication()->triggerEvent('onContentPrepare', array('com_solidres.roomtype', &$roomType, &$roomType->params, 0));
			?>
			<div class="row <?php echo $rowCSSClass ?>" id="room_type_row_<?php echo $roomType->id ?>">
				<div class="col-sm-12">
					<div class="row room-type-wrapper">
						<div class="col-sm-6">
							<div class="inner">
								<?php
								if( !empty($roomType->media) ) :
									echo '<div id="carousel'.$roomType->id.'" class="carousel slide">';
								?>
									
								<!-- Indicators -->
								<ol class="carousel-indicators">
									<?php
										//indicator
										foreach ($roomType->media as $key => $media){
									?>
										<li data-target="#carousel<?php echo $roomType->id; ?>" data-slide-to="<?php echo $key; ?>" class="<?php echo ($key == 0) ? 'active' : ''; ?>"></li>
									<?php
										} // Carousel Indicator
									?>

								</ol>

								<?php
									echo '<div class="carousel-inner">';
									$countMedia = 0;
									$active = '';
									foreach ($roomType->media as $media) :
										$active = ($countMedia == 0) ? 'active' : '';
								?>
										<div class="item <?php echo $active ?>">
											<a class="room_type_details sr-photo-<?php echo $roomType->id ?>" href="<?php echo SRURI_MEDIA.'/assets/images/system/'.$media->value; ?>">
												<img src="<?php echo SRURI_MEDIA.'/assets/images/system/'.$media->value; ?>"
												 	 alt="<?php echo $media->name ?>"/>
											</a>
										</div>
								<?php
										$countMedia ++;
									endforeach;
									echo '</div>';
									//echo '<a class="carousel-control left" href="#carousel'.$roomType->id.'" data-slide="prev">&lsaquo;</a>';
  									//echo '<a class="carousel-control right" href="#carousel'.$roomType->id.'" data-slide="next">&rsaquo;</a>';
									echo '</div>';
								endif;
								?>
							</div>
						</div>
						
						<div class="col-sm-6">
						<div class="roomtype-info-wrapper">
							<div class="inner">
							<h2 class="roomtype_name" id="room_type_details_handler_<?php echo $roomType->id ?>">
									<span class="label label-info">
										<?php echo $roomType->occupancy_max > 0 ? $roomType->occupancy_max : (int)$roomType->occupancy_adult + (int)$roomType->occupancy_child ?>
										<i class="icon-user uk-icon-user fa-user"></i>
									</span>

									<?php echo $roomType->name; ?>
									<?php if ($roomType->featured == 1) : ?>
										<small class="label label-success"><?php echo JText::_('SR_FEATURED_ROOM_TYPE') ?></small>
									<?php endif ?>
								</h2>
								<div class="roomtype_desc">
									<div class="row">
										<div class="col-sm-3 roomtype-info-title">
											<?php echo JText::_('SR_ROOM_INFO'); ?>
											<span class="roomtype-info-colon">: </span>
										</div>
										<div class="col-sm-9"><?php echo $roomType->description ?></div>
									</div>
									<div class="room-type-more-desc" id="more_desc_<?php echo $roomType->id ?>">
										<?php
										if (!empty($roomType->roomtype_custom_fields['room_facilities'])) :
											echo '<div class="row"><div class="col-sm-3 roomtype-info-title">'. JText::_('SR_ROOM_FACILITIES_TEXT') .'<span class="roomtype-info-colon">: </span></div> <div class="col-sm-9"> '.  $roomType->roomtype_custom_fields['room_facilities'] .'</div> </div>';
										endif;

										if (!empty($roomType->roomtype_custom_fields['room_size'])) :
											echo '<div class="row"><div class="col-sm-3 roomtype-info-title">'. JText::_('SR_ROOM_SIZE') .'<span class="roomtype-info-colon">:</span> </div> <div class="col-sm-9"> '.  $roomType->roomtype_custom_fields['room_size'] .'</div> </div>';
										endif;

										if (!empty($roomType->roomtype_custom_fields['bed_size'])) :
											echo '<div class="row"><div class="col-sm-3 roomtype-info-title">'. JText::_('SR_BED_SIZE') .'<span class="roomtype-info-colon">:</span> </div> <div class="col-sm-9"> '.  $roomType->roomtype_custom_fields['bed_size'] .'</div> </div>';
										endif;

										if (!empty($roomType->roomtype_custom_fields['taxes'])) :
											echo '<div class="row"><div class="col-sm-3 roomtype-info-title">'. JText::_('SR_TAXES') .' <span class="roomtype-info-colon">:</span></div> <div class="col-sm-9"> '.  $roomType->roomtype_custom_fields['taxes'] .'</div> </div>';
										endif;

										if (!empty($roomType->roomtype_custom_fields['prepayment'])) :
											echo '<div class="row"><div class="col-sm-3 roomtype-info-title">'. JText::_('SR_PREPAYMENT') .'<span class="roomtype-info-colon">:</span> </div> <div class="col-sm-9"> '.  $roomType->roomtype_custom_fields['prepayment'] .'</div> </div>';
										endif;
										?>

										<div class="row room-type-available-rooms">
											<?php if ( isset($roomType->totalAvailableRoom) ) : ?>
												<div class="col-sm-3 roomtype-info-title">
													<?php echo JText::_('SR_ROOM_TITLE'); ?>
													<span class="roomtype-info-colon">: </span>
												</div>
												<div class="col-sm-9 num_rooms_available_msg" id="num_rooms_available_msg_<?php echo $roomType->id ?>"
													data-original-text="<?php echo JText::plural('SR_WE_HAVE_X_ROOM_LEFT', $roomType->totalAvailableRoom) ?>">
													<?php echo JText::plural('SR_WE_HAVE_X_ROOM_LEFT', $roomType->totalAvailableRoom) ?>
												</div>

											<?php endif; ?>
										</div> <!-- /.row -->

									</div>
								<?php
								if ( !$this->isFresh && !empty($roomType->availableTariffs) && $showRemainingRooms ) :
									if (isset($roomType->totalAvailableRoom)) :
									?>
						
								<?php
									endif;
								endif;
								?>

								<?php if (!empty($roomType->facilities)): ?>
									<?php echo SRLayoutHelper::render('facility.facility', array('facilities' => $roomType->facilities)); ?>
								<?php endif; ?>

								<?php if ($showMoreInfo) : ?>
								<!-- <button type="button" class="btn btn-default toggle_more_desc" data-target="<?php echo $roomType->id ?>">
									<i class="fa fa-eye"></i>
									<?php echo JText::_('SR_SHOW_TARIFFS') ?>
								</button> -->
								<?php endif ?>
								<div class="room-type-btn-group">
								<?php if ($this->config->get('availability_calendar_enable', 1)) : ?>
								<button type="button" data-roomtypeid="<?php echo $roomType->id ?>" class="btn btn-primary load-calendar">
											<i class="icon-calendar uk-icon-calendar fa-calendar"></i> <?php echo JText::_('SR_AVAILABILITY_CALENDAR_VIEW') ?>
										</button>
								<?php endif ?>

							<?php if ($this->showFrontendTariffs != 0) : ?>
										<button type="button" data-roomtypeid="<?php echo $roomType->id ?>" class="btn btn-primary toggle-tariffs">
											<?php if ($this->showFrontendTariffs) : ?>
												<i class="icon-contract uk-icon-compress fa-compress"></i> <?php echo JText::_('SR_HIDE_TARIFFS') ?>
											<?php else : ?>
												<i class="icon-expand uk-icon-expand fa-expand"></i> <?php echo JText::_('SR_SHOW_TARIFFS') ?>
											<?php endif ?>
										</button>
								<?php endif ?>
								</div>
								<div class="unstyled more_desc" id="more_desc_<?php echo $roomType->id ?>" style="display: none">
									<?php
									if (!empty($roomType->roomtype_custom_fields['room_facilities'])) :
										echo '<p><strong>'. JText::_('SR_ROOM_FACILITIES') .':</strong> '.  $roomType->roomtype_custom_fields['room_facilities'] .'</p>';
									endif;

									if (!empty($roomType->roomtype_custom_fields['room_size'])) :
										echo '<p><strong>'. JText::_('SR_ROOM_SIZE') .':</strong> '.  $roomType->roomtype_custom_fields['room_size'] .'</p>';
									endif;

									if (!empty($roomType->roomtype_custom_fields['bed_size'])) :
										echo '<p><strong>'. JText::_('SR_BED_SIZE') .':</strong> '.  $roomType->roomtype_custom_fields['bed_size'] .'</p>';
									endif;

									if (!empty($roomType->roomtype_custom_fields['taxes'])) :
										echo '<p><strong>'. JText::_('SR_TAXES') .':</strong> '.  $roomType->roomtype_custom_fields['taxes'] .'</p>';
									endif;

									if (!empty($roomType->roomtype_custom_fields['prepayment'])) :
										echo '<p><strong>'. JText::_('SR_PREPAYMENT') .':</strong> '.  $roomType->roomtype_custom_fields['prepayment'] .'</p>';
									endif;

									?>
								</div>
							</div>
						</div> <!-- end of span8 -->
					</div> <!-- end of row-fluid -->
					</div>
</div>

					<?php if ($this->config->get('availability_calendar_enable', 1)) : ?>
					<div class="<?php echo SR_UI_GRID_CONTAINER ?>">
						<div class="<?php echo SR_UI_GRID_COL_12 ?> availability-calendar" id="availability-calendar-<?php echo $roomType->id ?>" style="display: none">
						</div>
					</div>
					<?php endif ?>

					<?php if (SRPlugin::isEnabled('flexsearch')) :
						$layout = SRLayoutHelper::getInstance();
						$layout->addIncludePath(SRPlugin::getLayoutPath('flexsearch'));
						echo $layout->render('roomtype.flexsearch', array('roomType' => $roomType, 'bookingType' => $this->item->booking_type, 'enableAutoScroll' => $this->enableAutoScroll));
					endif ?>

                    <?php if (!SRPlugin::isEnabled('flexsearch') || (SRPlugin::isEnabled('flexsearch') && empty($roomType->otherAvailableDates))) : ?>
					<div class="row-fluid" id="tariff-holder-<?php echo $roomType->id ?>"
						style="<?php echo !$this->disableOnlineBooking || $this->showTariffs ? '' : 'display: none' ?>">
						<div class="trariff-box-wrapper">
							<div class="inner">
								<?php
								if (!$this->isFresh) :
									if (!empty($roomType->availableTariffs)) :

										$countRatePerRoomType = 0;
										$countRatePerRoom = 0;
								        if ($roomType->number_of_room == $roomType->totalAvailableRoom) :
                                            foreach ($roomType->availableTariffs as $tariffKey => $tariffInfo) :

                                                if ($tariffInfo['tariffType'] != 4) :
	                                                $countRatePerRoom ++;
	                                                continue;
                                                endif;

                                                $minPrice = $this->appendPriceSuffix(
                                                    $tariffInfo['val'],
                                                    $tariffInfo['tariffType'],
                                                    $this->item->booking_type,
                                                    ($this->item->booking_type == 0 ? $this->stayLength : $this->stayLength + 1),
                                                    $tariffInfo['val_original'],
                                                    $roomType->is_private,
                                                    $tariffInfo['adults'],
                                                    $tariffInfo['children']
                                                );

                                                $layout = SRLayoutHelper::getInstance();
                                                echo $layout->render('asset.tariff_book', array(
                                                        'item' => $this->item,
                                                        'Itemid' => $this->itemid,
                                                        'roomType' => $roomType,
                                                        'bookingType' => $this->item->booking_type,
                                                        'disableOnlineBooking' => $this->disableOnlineBooking,
                                                        'minPrice' => $minPrice,
                                                        'tariffKey' => $tariffKey,
                                                        'tariffInfo' => $tariffInfo,
                                                        'stayLength' => $this->stayLength,
                                                        'selectedRoomTypes' => $this->selectedRoomTypes,
                                                        'skipRoomForm' => $skipRoomForm,
                                                        'isExclusive' => $isExclusive
                                                    )
                                                );
                                                $countRatePerRoomType ++;
                                            endforeach;
								        endif;

										if ($countRatePerRoomType > 0 && $countRatePerRoom > 0) :
											echo '<div class="tariff-sep"></div>';
										endif;

										foreach ($roomType->availableTariffs as $tariffKey => $tariffInfo) :

											if ($tariffInfo['tariffType'] == 4) continue;

											$minPrice = $this->appendPriceSuffix(
												$tariffInfo['val'],
												$tariffInfo['tariffType'],
												$this->item->booking_type,
												($this->item->booking_type == 0 ? $this->stayLength : $this->stayLength + 1),
												$tariffInfo['val_original'],
												$roomType->is_private,
												$tariffInfo['adults'],
												$tariffInfo['children']
											);

											$layout = SRLayoutHelper::getInstance();
											echo $layout->render('asset.tariff_book', array(
													'item' => $this->item,
													'Itemid' => $this->itemid,
													'roomType' => $roomType,
													'bookingType' => $this->item->booking_type,
													'disableOnlineBooking' => $this->disableOnlineBooking,
                                                    'minPrice' => $minPrice,
													'tariffKey' => $tariffKey,
													'tariffInfo' => $tariffInfo,
                                                    'stayLength' => $this->stayLength,
                                                    'selectedRoomTypes' => $this->selectedRoomTypes,
                                                    'skipRoomForm' => $skipRoomForm,
                                                    'isExclusive' => $isExclusive
												)
											);
										endforeach;
									else :
										if (SRPlugin::isEnabled('flexsearch') && !empty($roomType->otherAvailableDates)) :

										else :
											$link = JRoute::_('index.php?option=com_solidres&view=reservationasset&id=' . $this->item->id . ($this->enableAutoScroll ? '#form' : ''));
											echo '<div class="alert alert-notice">'.JText::sprintf('SR_NO_TARIFF_MATCH_CHECKIN_CHECKOUT', $this->checkinFormatted, $this->checkoutFormatted, $link) .'</div>';
										endif;
									endif;
								endif;

								if ($this->isFresh && $this->showTariffs == 1 && isset($roomType->tariffs) && is_array($roomType->tariffs)) :

									$countRatePerRoomType = 0;
                                    foreach ($roomType->tariffs as $tariff) :

                                        if ($tariff->type != 4) continue;
										$minPrice = $this->getMinPrice($tariff, $roomType);
										$layout = SRLayoutHelper::getInstance();
										echo $layout->render('asset.tariff_list', array(
												'item'                 => $this->item,
												'Itemid'               => $this->itemid,
												'roomType'             => $roomType,
												'bookingType'          => $this->item->booking_type,
												'disableOnlineBooking' => $this->disableOnlineBooking,
												'tariff'               => $tariff,
												'minPrice'             => $minPrice
											)
										);
	                                    $countRatePerRoomType ++;

									endforeach; // end foreach of complex tariffs

                                    if ($countRatePerRoomType > 0) :
                                        echo '<div class="tariff-sep"></div>';
                                    endif;

                                    foreach ($roomType->tariffs as $tariff) :

	                                    if ($tariff->type == 4) continue;
                                        $minPrice = $this->getMinPrice($tariff, $roomType);
	                                    $layout = SRLayoutHelper::getInstance();
                                        echo $layout->render('asset.tariff_list', array(
		                                        'item'                 => $this->item,
		                                        'Itemid'               => $this->itemid,
		                                        'roomType'             => $roomType,
		                                        'bookingType'          => $this->item->booking_type,
		                                        'disableOnlineBooking' => $this->disableOnlineBooking,
		                                        'tariff'               => $tariff,
		                                        'minPrice'             => $minPrice
                                            )
                                        );

                                    endforeach;
								endif  ?>
							</div>
						</div> <!-- end of span12 -->
					</div> <!-- end of row-fluid and #tariff-holder -->
                    <?php endif ?>
				</div>  <!-- end of span12 -->
			</div> <!-- end of row-fluid -->
			<?php
			$count ++;
		endforeach
		?>
	<?php
		else :
	?>
		<div class="alert alert-warning">
			<?php
			echo JText::sprintf('SR_NO_ROOM_TYPES_MATCHED_SEARCH_CONDITIONS',
				JDate::getInstance($this->checkin, $this->timezone)->format($this->dateFormat, true) ,
				JDate::getInstance($this->checkout, $this->timezone)->format($this->dateFormat, true)
			);
			?>
			<a class="" href="<?php echo JRoute::_('index.php?option=com_solidres&task=reservationasset.startOver&id='. $this->item->id ) ?>"><i class="fa fa-refresh"></i> <?php echo JText::_('SR_SEARCH_RESET')?></a>
		</div>
	<?php
		endif;
	?>

	<?php if (!$this->isFresh && count($this->item->roomTypes) > 0) : ?>
		<div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-bottom">
			<div class="<?php echo SR_UI_GRID_COL_8 ?>">
				<div class="inner">
					<p><?php echo JText::_('SR_ROOMINFO_STEP_NOTICE_MESSAGE') ?></p>
				</div>
			</div>
			<div class="<?php echo SR_UI_GRID_COL_4 ?>">
				<div class="inner">
					<div class="btn-group">
						<button data-step="room" type="submit" class="btn btn-success">
							<i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
						</button>
					</div>
				</div>
			</div>
		</div>
	<?php endif ?>

	<input type="hidden" name="jform[raid]" value="<?php echo $this->item->id ?>" />
	<input type="hidden" name="jform[next_step]" value="guestinfo" />
	<input type="hidden" name="jform[bookingconditions]" value="<?php echo $this->item->params['termsofuse'] ?>" />
	<input type="hidden" name="jform[privacypolicy]" value="<?php echo $this->item->params['privacypolicy'] ?>" />

	<?php echo JHtml::_('form.token'); ?>
	</form>
	</div>
	<!-- /Tab 1 -->

	</div>

	<div class="step-pane" id="step2">
		<!-- Tab 2 -->
		<div class="reservation-single-step-holder guestinfo nodisplay">
		</div>
		<!-- /Tab 2 -->
	</div>

	<div class="step-pane" id="step3">
		<!-- Tab 3 -->
		<div class="reservation-single-step-holder confirmation nodisplay">
		</div>
		<!-- /Tab 3 -->
	</div>

</div>