<?php 
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

if (!isset($this->item->params['only_show_reservation_form']))
{
	$this->item->params['only_show_reservation_form'] = 0;
}

$fbStars = '';
for ($i = 1; $i <= $this->item->rating; $i++) :
	$fbStars .= '&#x2605;';
endfor;

$this->document->addCustomTag('<meta property="og:title" content="'.$fbStars . ' ' . $this->item->name . ', ' . $this->item->city . ', ' . $this->item->country_name .'"/>');
$this->document->addCustomTag('<meta property="og:type" content="place"/>');
$this->document->addCustomTag('<meta property="og:url" content="'.JRoute::_('index.php?option=com_solidres&view=reservationasset&id='.$this->item->id, true, true).'"/>');
if (isset($this->item->media[0]))
{
	$this->document->addCustomTag('<meta property="og:image" content="' . SRURI_MEDIA.'/assets/images/system/thumbnails/1/'.$this->item->media[0]->value . '"/>');
}

if (isset($this->item->media[1]))
{
	$this->document->addCustomTag('<meta property="og:image" content="' . SRURI_MEDIA.'/assets/images/system/thumbnails/1/'.$this->item->media[1]->value . '"/>');
}

if (isset($this->item->media[2]))
{
	$this->document->addCustomTag('<meta property="og:image" content="' . SRURI_MEDIA.'/assets/images/system/thumbnails/1/'.$this->item->media[2]->value . '"/>');
}

$this->document->addCustomTag('<meta property="og:site_name" content="'.JFactory::getConfig()->get( 'sitename' ).'"/>');
$this->document->addCustomTag('<meta property="og:description" content="'.strip_tags($this->item->description).'"/>');
$this->document->addCustomTag('<meta property="place:location:latitude"  content="'.$this->item->lat.'" />');
$this->document->addCustomTag('<meta property="place:location:longitude" content="'.$this->item->lng.'" /> ');



?>
<div class="row-fluid">
	<div id="solidres" class="span12">
		<div class="reservation_asset_item clearfix">
			<?php if ($this->item->params['only_show_reservation_form'] == 0 ) : ?>

			<div class="row-fluid">
				<div class="span12">
					<?php echo $this->loadTemplate('simple_gallery'); ?>
					<?php 
					// echo "<pre>";
					// print_r($this);
					// echo "</pre>";
					 ?>
				</div>
			</div>

			<div class="row-fluid">
				<div class="span12">
					<?php
					$tabTitle = array(
						'<li class="active"><a href="#asset-desc" data-toggle="tab">'.JText::_('SR_DESCRIPTION').'</a></li>'
					);
					$tabPane = array(
						'<div class="tab-pane active" id="asset-desc"><p>'.$this->item->description.'</p></div>'
					);
					if (isset($this->item->feedbacks->render) && !empty($this->item->feedbacks->render))
					{
						$tabTitle[] = '<li><a href="#asset-feedbacks" data-toggle="tab">'.JText::_('SR_RESERVATION_FEEDBACKS').'</a></li>';
						$tabPane[] = '<div class="tab-pane" id="asset-feedbacks">'.$this->item->feedbacks->render.'</div>';
						$tabTitle[] = '<li><a href="#asset-feedback-scores" data-toggle="tab">'.JText::_('SR_FEEDBACK_SCORES').'</a></li>';
						$tabPane[] = '<div class="tab-pane" id="asset-feedback-scores">'.$this->item->feedbacks->scores.'</div>';
					}

					?>
					<?php if ($this->item->description && $this->item->feedbacks->render) {?>
					<ul class="nav nav-tabs asset-details-tab">
						<?php echo join("\n", $tabTitle); ?>
					</ul>
					<?php } ?>

					<div class="tab-content">
						<?php echo join("\n", $tabPane); ?>
					</div>
				</div>
			</div>

			<?php endif ?>

			<!--<div class="row-fluid">
				<div class="span12">
					<?php /*echo $this->loadTemplate('searchinfo'); */?>
				</div>
			</div>-->

			<div class="row">
				<div class="col-sm-12">
					<?php echo $this->loadTemplate('roomtype'); ?>
				</div>
			</div>

			<div class="row">
				<div class="col-sm-12">
					<?php echo $this->loadTemplate('information'); ?>
				</div>
            </div>

			<?php if ($this->showPoweredByLink) : ?>
			<div class="row">
				<div class="col-sm-12 powered">
					<p>
						Powered by <a target="_blank" title="Solidres - A hotel booking extension for Joomla" href="http://www.solidres.com">Solidres</a>
					</p>
				</div>
			</div>
			<?php endif ?>
		</div>
	</div>
</div>