<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_( 'stylesheet', 'com_solidres/assets/main.min.css', array('version' => SRVersion::getHashVersion(), 'relative' => true) );

$lang = JFactory::getLanguage();
$app = JFactory::getApplication();
$context = 'com_solidres.reservation.process';
$checkin = $app->getUserState($context.'.checkin');
$checkout = $app->getUserState($context.'.checkout');
$roomsOccupancyOptions = $app->getUserState($context.'.room_opt', array());
$prioritizingRoomTypeId = $app->getUserState($context . '.prioritizing_room_type_id', 0);
JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables', 'SolidresTable');
$tableAsset = JTable::getInstance('ReservationAsset', 'SolidresTable');
$tableAsset->load(array('default' => 1, 'state' => 1));
if (empty($tableAsset->id) || $tableAsset->id <= 0)
{
	echo '<div class="alert alert-error">' . JText::_('SR_MOD_CHECKAVAILABILITY_NO_DEFAULT_ASSET_FOUND') . '</div>';
	return;
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$enableRoomTypeDropdown = $params->get('enable_roomtype_dropdown', 0);

if ($enableRoomTypeDropdown)
{
	JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/models', 'SolidresModel');
	$roomTypesModel = JModelLegacy::getInstance('RoomTypes', 'SolidresModel', array('ignore_request' => true));
	$roomTypesModel->setState('filter.reservation_asset_id', $tableAsset->id);
	$roomTypesModel->setState('list.select', 'r.id, r.name');
	$roomTypesModel->setState('filter.state', '1');
	$roomTypes = $roomTypesModel->getItems();
}

$config = JFactory::getConfig();
$solidresConfig = JComponentHelper::getParams('com_solidres');
$minDaysBookInAdvance = $solidresConfig->get('min_days_book_in_advance', 0);
$maxDaysBookInAdvance = $solidresConfig->get('max_days_book_in_advance', 0);
$minLengthOfStay = $solidresConfig->get('min_length_of_stay', 1);
$datePickerMonthNum = $solidresConfig->get('datepicker_month_number', 3);
$weekStartDay = $solidresConfig->get('week_start_day', 1);
$dateFormat = $solidresConfig->get('date_format', 'd-m-Y');
JLoader::register('SRUtilities', SRPATH_LIBRARY . '/utilities/utilities.php');
$tzoffset = $config->get('offset');
$timezone = new DateTimeZone($tzoffset);
$dateCheckIn = JDate::getInstance();
if (!isset($checkin)) :
	$dateCheckIn->add(new DateInterval('P'.($minDaysBookInAdvance).'D'))->setTimezone($timezone);
endif;
$dateCheckOut = JDate::getInstance();
if (!isset($checkout)) :
	$dateCheckOut->add(new DateInterval('P'.($minDaysBookInAdvance + $minLengthOfStay).'D'))->setTimezone($timezone);
endif;

$jsDateFormat = SRUtilities::convertDateFormatPattern($dateFormat);
$roomsOccupancyOptionsCount = count($roomsOccupancyOptions);
$maxRooms = $params->get('max_room_number', 10);
$maxAdults = $params->get('max_adult_number', 10);
$maxChildren = $params->get('max_child_number', 10);
$hideRoomQuantity = $params->get('hide_room_quantity', 0);
$mergeAdultChild = $params->get('merge_adult_child', 0);

$defaultCheckinDate = '';
$defaultCheckoutDate = '';
if (isset($checkin)) {
	$checkinModule = JDate::getInstance($checkin, $timezone);
	$checkoutModule = JDate::getInstance($checkout, $timezone);
	// These variables are used to set the defaultDate of datepicker
	$defaultCheckinDate = $checkinModule->format('Y-m-d', true);
	$defaultCheckoutDate = $checkoutModule->format('Y-m-d', true);
}

if (!empty($defaultCheckinDate)) :
	$defaultCheckinDateArray = explode('-', $defaultCheckinDate);
	$defaultCheckinDateArray[1] -= 1; // month in javascript is less than 1 in compare with month in PHP
endif;

if (!empty($defaultCheckoutDate)) :
	$defaultCheckoutDateArray = explode('-', $defaultCheckoutDate);
	$defaultCheckoutDateArray[1] -= 1; // month in javascript is less than 1 in compare with month in PHP
endif;

$doc = JFactory::getDocument();
JHtml::_('script', SRURI_MEDIA.'/assets/js/datePicker/localization/jquery.ui.datepicker-'.JFactory::getLanguage()->getTag().'.js', false, false);
$doc->addScriptDeclaration('
	Solidres.jQuery(function($) {
		var minLengthOfStay = '.$minLengthOfStay.';
		var checkout = $("#sr-checkavailability-form-' . $module->id . ' .checkout_datepicker_inline_module").datepicker({
			minDate : "+' . ( $minDaysBookInAdvance + $minLengthOfStay ). '",
			numberOfMonths : '.$datePickerMonthNum.',
			showButtonPanel : true,
			dateFormat : "'.$jsDateFormat.'",
			firstDay: '.$weekStartDay.',
			' . (isset($checkout) ? 'defaultDate: new Date(' . implode(',' , $defaultCheckoutDateArray) .'),' : '') . '
			onSelect: function() {
				$("#sr-checkavailability-form-' . $module->id . ' input[name=\'checkout\']").val($.datepicker.formatDate("yy-mm-dd", $(this).datepicker("getDate")));
				$("#sr-checkavailability-form-' . $module->id . ' .checkout_module").html($.datepicker.formatDate("'.$jsDateFormat.'", $(this).datepicker("getDate")) + "<i class=\"fa fa-calendar\"></i>");
				$("#sr-checkavailability-form-' . $module->id . ' .checkout_datepicker_inline_module").slideToggle();
				$("#sr-checkavailability-form-' . $module->id . ' .checkin_module").removeClass("disabledCalendar");
			}
		});
		var checkin = $("#sr-checkavailability-form-' . $module->id . ' .checkin_datepicker_inline_module").datepicker({
			minDate : "+' .  $minDaysBookInAdvance . 'd",
			'.($maxDaysBookInAdvance > 0 ? 'maxDate: "+'. ($maxDaysBookInAdvance) . '",' : '' ).'
			numberOfMonths : '.$datePickerMonthNum.',
			showButtonPanel : true,
			dateFormat : "'.$jsDateFormat.'",
			'. (isset($checkin) ? 'defaultDate: new Date(' . implode(',' , $defaultCheckinDateArray) .'),' : '') . '
			onSelect : function() {
				var currentSelectedDate = $(this).datepicker("getDate");
				var checkoutMinDate = $(this).datepicker("getDate", "+1d");
				checkoutMinDate.setDate(checkoutMinDate.getDate() + minLengthOfStay);
				checkout.datepicker( "option", "minDate", checkoutMinDate );
				checkout.datepicker( "setDate", checkoutMinDate);

				$("#sr-checkavailability-form-' . $module->id . ' input[name=\'checkin\']").val($.datepicker.formatDate("yy-mm-dd", currentSelectedDate));
				$("#sr-checkavailability-form-' . $module->id . ' input[name=\'checkout\']").val($.datepicker.formatDate("yy-mm-dd", checkoutMinDate));

				$("#sr-checkavailability-form-' . $module->id . ' .checkin_module").html($.datepicker.formatDate("'.$jsDateFormat.'", currentSelectedDate) + "<i class=\"fa fa-calendar\"></i>");
				$("#sr-checkavailability-form-' . $module->id . ' .checkout_module").html($.datepicker.formatDate("'.$jsDateFormat.'", checkoutMinDate) + "<i class=\"fa fa-calendar\"></i>");
				$("#sr-checkavailability-form-' . $module->id . ' .checkin_datepicker_inline_module").slideToggle();
				$("#sr-checkavailability-form-' . $module->id . ' .checkout_module").removeClass("disabledCalendar");
			},
			firstDay: '.$weekStartDay.'
		});
		$(".ui-datepicker").addClass("notranslate");
		$("#sr-checkavailability-form-' . $module->id . ' .checkin_module").click(function() {
			if (!$(this).hasClass("disabledCalendar")) {
				$("#sr-checkavailability-form-' . $module->id . ' .checkin_datepicker_inline_module").slideToggle("fast", function() {
					if ($(this).is(":hidden")) {
						$("#sr-checkavailability-form-' . $module->id . ' .checkout_module").removeClass("disabledCalendar");
					} else {
						$("#sr-checkavailability-form-' . $module->id . ' .checkout_module").addClass("disabledCalendar");
					}
				});
			}
		});
	
		$("#sr-checkavailability-form-' . $module->id . ' .checkout_module").click(function() {
			if (!$(this).hasClass("disabledCalendar")) {
				$("#sr-checkavailability-form-' . $module->id . ' .checkout_datepicker_inline_module").slideToggle("fast", function() {
					if ($(this).is(":hidden")) {
						$("#sr-checkavailability-form-' . $module->id . ' .checkin_module").removeClass("disabledCalendar");
					} else {
						$("#sr-checkavailability-form-' . $module->id . ' .checkin_module").addClass("disabledCalendar");
					}
				});
			}
		});

		$("#sr-checkavailability-form-' . $module->id . ' .room_quantity").change(function() {
			var curQuantity = $(this).val();
			$("#sr-checkavailability-form-' . $module->id . ' .room_num_row").each(function( index ) {
				var index2 = index + 1;
				if (index2 <= curQuantity) {
					$("#sr-checkavailability-form-' . $module->id . ' #room_num_row_" + index2).show();
					$("#sr-checkavailability-form-' . $module->id . ' #room_num_row_" + index2 + " select").removeAttr("disabled");
				} else {
					$("#sr-checkavailability-form-' . $module->id . ' #room_num_row_" + index2).hide();
					$("#sr-checkavailability-form-' . $module->id . ' #room_num_row_" + index2 + " select").attr("disabled", "disabled");
				}
			});
		});

		if ($("#sr-checkavailability-form-' . $module->id . ' .room_quantity").val() > 0) {
			$("#sr-checkavailability-form-' . $module->id . ' .room_quantity").trigger("change");
		}
    });
');

$enableRoomQuantity = $params->get('enable_room_quantity_option', 0);

require JModuleHelper::getLayoutPath('mod_sr_checkavailability', $params->get('layout', 'default'));
