Solidres.validateCardForm = function (container) {
    var
        $ = Solidres.jQuery,
        form = container.parents('form'),
        paymentElement = container.data('element');

    if (container.hasClass('handled')) {
        return true;
    }

    container.addClass('handled');

    var
        acceptedCards = container.data('acceptedCards') || {all: true},
        cardNumRule = {
            required: true,
            creditcard: true,
            creditcardtypes: acceptedCards,
        },
        cardCVVRule = {
            required: true,
            number: true,
        },
        cardHolderRule = {
            required: true,
            lettersWithSpacesOnly: true,
        },
        expiration = {
            required: true,
            cardExpirationRule: true,
        };

    form.on('change', 'input.payment_method_radio', function (e) {
        e.preventDefault();
        var
            inputName = form.find('[name="jform[' + paymentElement + '][cardHolder]"]'),
            inputNumber = form.find('[name="jform[' + paymentElement + '][cardNumber]"]'),
            inputCvv = form.find('[name="jform[' + paymentElement + '][cardCvv]"]'),
            inputExpiration = form.find('[name="sr_payment_' + paymentElement + '_expiration"]');

        if ($(this).is(':checked') && this.value === paymentElement) {
            form.find('.payment_method_' + paymentElement + '_details').removeClass('nodisplay');
            form.find('.payment_method_' + paymentElement + '_details input').attr('required', true);
            form.find('.payment_method_' + paymentElement + '_details select').attr('required', true);
            inputNumber.length && inputNumber.rules('add', cardNumRule);
            inputCvv.length && inputCvv.rules('add', cardCVVRule);
            inputName.length && inputName.rules('add', cardHolderRule);
            inputExpiration.length && inputExpiration.rules('add', expiration);

        } else {
            form.find('.payment_method_' + paymentElement + '_details').addClass('nodisplay');
            form.find('.payment_method_' + paymentElement + '_details input').removeAttr('required');
            form.find('.payment_method_' + paymentElement + '_details select').removeAttr('required');
            inputNumber.length && inputNumber.rules('remove');
            inputCvv.length && inputCvv.rules('remove');
            inputName.length && inputName.rules('remove');
            inputExpiration.length && inputExpiration.rules('remove');
        }
    });
};

Solidres.jQuery(document).ready(function ($) {
    if (!$.validator.methods.hasOwnProperty('lettersWithSpacesOnly')) {
        $.validator.addMethod('lettersWithSpacesOnly', function (value, element) {
            return this.optional(element) || /^[a-z\s]+$/i.test(value);
        }, Joomla.JText._('SR_WARN_ONLY_LETTERS_N_SPACES_MSG', 'Letters and spaces only please'));
    }

    if (!$.validator.methods.hasOwnProperty('cardExpirationRule')) {
        $.validator.addMethod('cardExpirationRule', function (value, element) {
            if (!value.match(/^[0-9]{2}\/[0-9]{2}$/g)) {
                return false;
            }

            var
                form = $(element.form),
                date = new Date(),
                expiration = value.split('/'),
                month = parseInt(expiration[0]),
                year = parseInt(date.getFullYear().toString().substring(0, 2) + expiration[1]),
                nowYear = parseInt(date.getFullYear().toString()),
                nowMonth = parseInt(date.getMonth().toString()),
                elementName = $(element).parents('.sr-payment-card-form-container').data('element');

            if (month < 1
                || month > 12
                || year < nowYear
                || (year === nowYear && month < nowMonth + 1)
            ) {
                return false;
            }

            form.find('[name="jform[' + elementName + '][expiryMonth]"]').val(month.toString().length === 1 ? '0' + month : month);
            form.find('[name="jform[' + elementName + '][expiryYear]"]').val(year);

            return true;
        }, Joomla.JText._('SR_WARN_INVALID_EXPIRATION_MSG', 'Your card\'s expiration year is invalid or in the past.'));
    }

    var validateCardForm = function () {
        $('.sr-payment-card-form-container[data-accepted-cards]').each(function () {
            Solidres.validateCardForm($(this));
        });
    };

    validateCardForm();
    $(document).on('DOMSubtreeModified', '.reservation-single-step-holder, #sr-modal-payment', validateCardForm);
});