<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

jimport('joomla.user.user');

/**
 * User class.  Handles all application interaction with a user.
 * Extendded from JUser so that we could control the work flow more convenient
 *
 * @package     Joomla.Platform
 * @subpackage  User
 * @since       11.1
 */
class SRUser extends JUser
{
	public function __construct($identifier = 0, JUserWrapperHelper $userHelper = null)
	{
		parent::__construct($identifier, $userHelper);
	}

	/**
	 * Method to save the JUser object to the database
	 *
	 * @param   boolean $updateOnly   Save the object only if not a new user
	 *                                Currently only used in the user reset password method.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   11.1
	 * @throws  exception
	 */
	public function save($updateOnly = false)
	{
		// Create the user table object
		$table        = $this->getTable();
		$this->params = (string) $this->_params;
		$table->bind($this->getProperties());

		// Allow an exception to be thrown.
		try
		{
			// Check and store the object.
			if (!$table->check())
			{
				$this->setError($table->getError());

				return false;
			}

			// If user is made a Super Admin group and user is NOT a Super Admin
			// @todo ACL - this needs to be acl checked
			$my = JFactory::getUser();

			// Are we creating a new user
			$isNew = empty($this->id);

			// If we aren't allowed to create new users return
			if ($isNew && $updateOnly)
			{
				return true;
			}

			// Get the old user
			$oldUser = new SRUser($this->id);

			// Access Checks

			// The only mandatory check is that only Super Admins can operate on other Super Admin accounts.
			// To add additional business rules, use a user plugin and throw an Exception with onUserBeforeSave.

			// Check if I am a Super Admin
			$iAmSuperAdmin = $my->authorise('core.admin');

			$iAmRehashingSuperadmin = false;

			if (($my->id == 0 && !$isNew) && $this->id == $oldUser->id && $oldUser->authorise('core.admin') && $oldUser->password != $this->password)
			{
				$iAmRehashingSuperadmin = true;
			}

			// We are only worried about edits to this account if I am not a Super Admin.
			if ($iAmSuperAdmin != true && $iAmRehashingSuperadmin != true)
			{
				// I am not a Super Admin, and this one is, so fail.
				if (!$isNew && JAccess::check($this->id, 'core.admin'))
				{
					throw new RuntimeException('User not Super Administrator');
				}

				if ($this->groups != null)
				{
					// I am not a Super Admin and I'm trying to make one.
					foreach ($this->groups as $groupId)
					{
						if (JAccess::checkGroup($groupId, 'core.admin'))
						{
							throw new RuntimeException('User not Super Administrator');
						}
					}
				}
			}

			// Fire the onUserBeforeSave event.
			JPluginHelper::importPlugin('user');
			$result = JFactory::getApplication()->triggerEvent('onUserBeforeSave', array($oldUser->getProperties(), $isNew, $this->getProperties()));

			if (in_array(false, $result, true))
			{
				// Plugin will have to raise its own error or throw an exception.
				return false;
			}

			// Store the user data in the database
			$result = $table->store();

			// Set the id for the JUser object in case we created a new user.
			if (empty($this->id))
			{
				$this->id = $table->get('id');
			}

			if ($my->id == $table->id)
			{
				$registry = new Registry;
				$registry->loadString($table->params);
				$my->setParameters($registry);
			}

			// Fire the onUserAfterSave event
			JFactory::getApplication()->triggerEvent('onUserAfterSave', array($this->getProperties(), $isNew, $result, $this->getError()));
		}
		catch (Exception $e)
		{
			$this->setError($e->getMessage());

			return false;
		}

		return $result;
	}

	/**
	 * Returns the global User object, only creating it if it
	 * doesn't already exist.
	 *
	 * @param   integer $identifier The user to load - Can be an integer or string - If string, it is converted to ID automatically.
	 *
	 * @return  JUser  The User object.
	 * @since   11.1
	 */
	public static function getInstance($identifier = 0, JUserWrapperHelper $userHelper = null)
	{
		if (null === $userHelper)
		{
			$userHelper = new JUserWrapperHelper;
		}

		// Find the user id
		if (!is_numeric($identifier))
		{
			if (!$id = $userHelper->getUserId($identifier))
			{
				// If the $identifier doesn't match with any id, just return an empty JUser.
				return new SRUser;
			}
		}
		else
		{
			$id = $identifier;
		}

		// If the $id is zero, just return an empty JUser.
		// Note: don't cache this user because it'll have a new ID on save!
		if ($id === 0)
		{
			return new SRUser;
		}

		// Check if the user ID is already cached.
		if (empty(self::$instances[$id]))
		{
			$user                 = new SRUser($id, $userHelper);
			self::$instances[$id] = $user;
		}

		return self::$instances[$id];
	}
}