<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

class SolidresViewTracking extends JViewLegacy
{
	protected $reservation = null;
	protected $menuId = 0;
	protected $state;
	protected $params;

	public function display($tpl = null)
	{
		$this->state    = new Registry;
		$app            = JFactory::getApplication();
		$code           = $app->input->get('trackingCode', null, 'TRIM');
		$email          = $app->input->get('trackingEmail', null, 'TRIM');
		$menu           = $app->getMenu()->getActive();
		$user           = JFactory::getUser();
		$enableTracking = JComponentHelper::getParams('com_solidres')->get('enable_reservation_tracking', '1');

		if (!$user->id && !$enableTracking)
		{
			$return = base64_encode(JUri::getInstance()->toString());
			$app->redirect(JRoute::_('index.php?option=com_users&view=login&return=' . $return, false));
		}

		$this->state->set('trackingCode', $code);
		$this->state->set('trackingEmail', $email);
		SRLayoutHelper::addIncludePath(JPATH_SITE . '/components/com_solidres/layouts');

		if (null !== $code && null !== $email)
		{
			$loadData = array(
				'code'           => $code,
				'customer_email' => $email,
			);

			if (!$enableTracking)
			{
				$db    = JFactory::getDbo();
				$query = $db->getQuery(true)
					->select('a.id')
					->from($db->qn('#__sr_customers', 'a'))
					->where('a.user_id = ' . (int) $user->id);
				$db->setQuery($query);
				$customerId              = $db->loadResult();
				$loadData['customer_id'] = $customerId ?: 0;
			}

			JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/models', 'SolidresModel');
			$reservationModel = JModelLegacy::getInstance('Reservation', 'SolidresModel', array('ignore_request' => true));
			$reservation      = $reservationModel->getItem($loadData);

			if (!empty($reservation->id) && (int) $reservation->state !== -2)
			{
				$this->reservation = $reservation;
				JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');
				JFactory::getLanguage()->load('plg_solidrespayment_' . $this->reservation->payment_method_id, JPATH_PLUGINS . '/solidrespayment/' . $this->reservation->payment_method_id);
			}
		}

		if ($menu
			&& @$menu->query['option'] == 'com_solidres'
			&& @$menu->query['view'] == 'tracking'
		)
		{
			$this->menuId = (int) $menu->id;
			$this->params = $menu->params;
		}

		if (!($this->params instanceof Registry))
		{
			$this->params = new Registry;
		}

		parent::display($tpl);
	}
}
