<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * HTML View class for the Solidres component
 *
 * @package      Solidres
 * @since        0.1.0
 */
class SolidresViewReservationAsset extends JViewLegacy
{
	protected $item;
	protected $solidresCurrency;

	public function display($tpl = null)
	{
		$model                     = $this->getModel();
		$this->config              = JComponentHelper::getParams('com_solidres');
		$this->systemConfig        = JFactory::getConfig();
		$this->showPoweredByLink   = $this->config->get('show_solidres_copyright', '1');
		$this->showFrontendTariffs = $this->config->get('show_frontend_tariffs', '1');
		$this->app                 = JFactory::getApplication();

		$this->item = $model->getItem();

		if ($this->item->params['access-view'] == false || $this->item->state != 1)
		{
			throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		$this->checkin                = $model->getState('checkin', '');
		$this->checkout               = $model->getState('checkout', '');
		$this->countryId              = $model->getState('country_id');
		$this->geoStateId             = $model->getState('geo_state_id');
		$this->roomTypeObj            = SRFactory::get('solidres.roomtype.roomtype');
		$this->srReservation          = SRFactory::get('solidres.reservation.reservation');
		$this->solidresMedia          = SRFactory::get('solidres.media.media');
		$this->stayLength             = SRUtilities::calculateDateDiff($this->checkin, $this->checkout);
		$this->document               = JFactory::getDocument();
		$this->context                = 'com_solidres.reservation.process';
		$this->coupon                 = $this->app->getUserState($this->context . '.coupon');
		$this->selectedRoomTypes      = $this->app->getUserState($this->context . '.room');
		$this->selectedTariffs        = $this->app->getUserState($this->context . '.current_selected_tariffs');
		$this->isAmending             = $this->app->getUserState($this->context . '.is_amending', 0);
		$this->prioritizingRoomTypeId = $this->app->getUserState($this->context . '.prioritizing_room_type_id', 0);
		$this->showTaxIncl            = $this->config->get('show_price_with_tax', 0);
		$this->minDaysBookInAdvance   = $this->config->get('min_days_book_in_advance', 0);
		$this->maxDaysBookInAdvance   = $this->config->get('max_days_book_in_advance', 0);
		$this->minLengthOfStay        = $this->config->get('min_length_of_stay', 1);
		$this->dateFormat             = $this->config->get('date_format', 'd-m-Y');
		$this->showLoginBox           = $this->config->get('show_login_box', 0);
		$this->enableAutoScroll       = $this->config->get('enable_auto_scroll', 1);
		$datePickerMonthNum           = $this->config->get('datepicker_month_number', 3);
		$weekStartDay                 = $this->config->get('week_start_day', 1);
		$this->solidresCurrency       = new SRCurrency(0, $this->item->currency_id);
		$this->tzoffset               = $this->systemConfig->get('offset');
		$this->timezone               = new DateTimeZone($this->tzoffset);
		$this->solidresStyle          = (defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? SR_LAYOUT_STYLE : 'style1';
		$this->item->text             = $this->item->description;

		$activeMenu   = $this->app->getMenu()->getActive();
		$this->itemid = null;
		if (isset($activeMenu))
		{
			$this->itemid = $activeMenu->id;
		}

		JHtml::_('jquery.framework');
		JHtml::_('bootstrap.framework');
		SRHtml::_('jquery.colorbox', 'show_map', '95%', '90%', 'true', 'false');
		SRHtml::_('jquery.popover');

		$jsOptions = ['version' => SRVersion::getHashVersion(), 'relative' => true];
		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', $jsOptions);
		JHtml::_('stylesheet', 'com_solidres/assets/' . $this->solidresStyle . '.min.css', $jsOptions);
		JHtml::_('script', 'com_solidres/assets/datePicker/localization/jquery.ui.datepicker-' . JFactory::getLanguage()->getTag() . '.js', $jsOptions);
		$this->document->addScriptDeclaration('
			Solidres.jQuery(function ($) {
				$(".sr-photo").colorbox({rel:"sr-photo", transition:"fade", width: "98%", height: "98%", className: "colorbox-w"});
				var minLengthOfStay = ' . $this->minLengthOfStay . ';
				var checkout_component = $(".checkout_component").datepicker({
					minDate : "+' . ($this->minDaysBookInAdvance + $this->minLengthOfStay) . '",
					numberOfMonths : ' . $datePickerMonthNum . ',
					showButtonPanel : true,
					dateFormat : "dd-mm-yy",
					firstDay: ' . $weekStartDay . '
				});
				var checkin_component = $(".checkin_component").datepicker({
					minDate : "+' . ($this->minDaysBookInAdvance) . 'd",
					' . ($this->maxDaysBookInAdvance > 0 ? 'maxDate: "+' . ($this->maxDaysBookInAdvance) . '",' : '') . '
					numberOfMonths : ' . $datePickerMonthNum . ',
					showButtonPanel : true,
					dateFormat : "dd-mm-yy",
					onSelect : function() {
						var checkoutMinDate = $(this).datepicker("getDate", "+1d");
						checkoutMinDate.setDate(checkoutMinDate.getDate() + minLengthOfStay);
						checkout_component.datepicker( "option", "minDate", checkoutMinDate );
						checkout_component.datepicker( "setDate", checkoutMinDate);
					},
					firstDay: ' . $weekStartDay . '
				});
				$(".ui-datepicker").addClass("notranslate");
			});

			Solidres.child_max_age_limit = ' . $this->config->get('child_max_age_limit', 17) . ';
		');

		if (!empty($this->checkin) && !empty($this->checkout))
		{
			$this->checkinFormatted  = JDate::getInstance($this->checkin, $this->timezone)->format($this->dateFormat, true);
			$this->checkoutFormatted = JDate::getInstance($this->checkout, $this->timezone)->format($this->dateFormat, true);
			$this->document->addScriptDeclaration('
				Solidres.jQuery(function ($) {
					isAtLeastOnRoomTypeSelected();
				});
			');

			$conditions                             = array();
			$conditions['min_days_book_in_advance'] = $this->minDaysBookInAdvance;
			$conditions['max_days_book_in_advance'] = $this->maxDaysBookInAdvance;
			$conditions['min_length_of_stay']       = $this->minLengthOfStay;
			$conditions['booking_type']             = $this->item->booking_type;

			try
			{
				$this->srReservation->isCheckInCheckOutValid($this->checkin, $this->checkout, $conditions);
			}
			catch (Exception $e)
			{
				switch ($e->getCode())
				{
					default:
					case 50001:
						$msg = JText::_($e->getMessage());
						break;
					case 50002:
						$msg = JText::sprintf($e->getMessage(), $conditions['min_length_of_stay']);
						break;
					case 50003:
						$msg = JText::sprintf($e->getMessage(), $conditions['min_days_book_in_advance']);
						break;
					case 50004:
						$msg = JText::sprintf($e->getMessage(), $conditions['max_days_book_in_advance']);
						break;
				}

				$this->checkin = $this->checkout = '';

				$this->app->enqueueMessage($msg, 'warning');
			}
		}
		else
		{
			$this->app->setUserState($this->context . '.prioritizing_room_type_id', null);
			$this->prioritizingRoomTypeId = null;
		}

		JText::script('SR_CAN_NOT_REMOVE_COUPON');
		JText::script('SR_SELECT_AT_LEAST_ONE_ROOMTYPE');
		JText::script('SR_ERROR_CHILD_MAX_AGE');
		JText::script('SR_AND');
		JText::script('SR_TARIFF_BREAK_DOWN');
		JText::script('SUN');
		JText::script('MON');
		JText::script('TUE');
		JText::script('WED');
		JText::script('THU');
		JText::script('FRI');
		JText::script('SAT');
		JText::script('SR_NEXT');
		JText::script('SR_BACK');
		JText::script('SR_PROCESSING');
		JText::script('SR_CHILD');
		JText::script('SR_CHILD_AGE_SELECTION_JS');
		JText::script('SR_CHILD_AGE_SELECTION_1_JS');
		JText::script('SR_ONLY_1_LEFT');
		JText::script('SR_ONLY_2_LEFT');
		JText::script('SR_ONLY_3_LEFT');
		JText::script('SR_ONLY_4_LEFT');
		JText::script('SR_ONLY_5_LEFT');
		JText::script('SR_ONLY_6_LEFT');
		JText::script('SR_ONLY_7_LEFT');
		JText::script('SR_ONLY_8_LEFT');
		JText::script('SR_ONLY_9_LEFT');
		JText::script('SR_ONLY_10_LEFT');
		JText::script('SR_ONLY_11_LEFT');
		JText::script('SR_ONLY_12_LEFT');
		JText::script('SR_ONLY_13_LEFT');
		JText::script('SR_ONLY_14_LEFT');
		JText::script('SR_ONLY_15_LEFT');
		JText::script('SR_ONLY_16_LEFT');
		JText::script('SR_ONLY_17_LEFT');
		JText::script('SR_ONLY_18_LEFT');
		JText::script('SR_ONLY_19_LEFT');
		JText::script('SR_ONLY_20_LEFT');

		JText::script('SR_ONLY_1_LEFT_BED');
		JText::script('SR_ONLY_2_LEFT_BED');
		JText::script('SR_ONLY_3_LEFT_BED');
		JText::script('SR_ONLY_4_LEFT_BED');
		JText::script('SR_ONLY_5_LEFT_BED');
		JText::script('SR_ONLY_6_LEFT_BED');
		JText::script('SR_ONLY_7_LEFT_BED');
		JText::script('SR_ONLY_8_LEFT_BED');
		JText::script('SR_ONLY_9_LEFT_BED');
		JText::script('SR_ONLY_10_LEFT_BED');
		JText::script('SR_ONLY_11_LEFT_BED');
		JText::script('SR_ONLY_12_LEFT_BED');
		JText::script('SR_ONLY_13_LEFT_BED');
		JText::script('SR_ONLY_14_LEFT_BED');
		JText::script('SR_ONLY_15_LEFT_BED');
		JText::script('SR_ONLY_16_LEFT_BED');
		JText::script('SR_ONLY_17_LEFT_BED');
		JText::script('SR_ONLY_18_LEFT_BED');
		JText::script('SR_ONLY_19_LEFT_BED');
		JText::script('SR_ONLY_20_LEFT_BED');

		JText::script('SR_SHOW_MORE_INFO');
		JText::script('SR_HIDE_MORE_INFO');
		JText::script('SR_AVAILABILITY_CALENDAR_CLOSE');
		JText::script('SR_AVAILABILITY_CALENDAR_VIEW');
		JText::script('SR_PROCESSING');
		JText::script('SR_USERNAME_EXISTS');
		JText::script('SR_SHOW_TARIFFS');
		JText::script('SR_HIDE_TARIFFS');
		JText::script('SR_WARN_ONLY_LETTERS_N_SPACES_MSG');
		JText::script('SR_WARN_INVALID_EXPIRATION_MSG');

		JPluginHelper::importPlugin('solidres');
		JPluginHelper::importPlugin('content');
		$this->app->triggerEvent('onContentPrepare', array('com_solidres.asset', &$this->item, &$this->item->params, 0));
		$this->app->triggerEvent('onSolidresAssetViewLoad', array(&$this->item));
		$this->events                         = new stdClass;
		$this->events->afterDisplayAssetName  = join("\n", $this->app->triggerEvent('onSolidresAfterDisplayAssetName', array(&$this->item, &$this->item->params)));
		$this->events->beforeDisplayAssetForm = join("\n", $this->app->triggerEvent('onSolidresBeforeDisplayAssetForm', array(&$this->item, &$this->item->params)));
		$this->events->afterDisplayAssetForm  = join("\n", $this->app->triggerEvent('onSolidresAfterDisplayAssetForm', array(&$this->item, &$this->item->params)));

		if ($errors = $this->get('Errors'))
		{
			throw new Exception(implode("\n", $errors), 500);
		}


		$this->defaultGallery = '';
		$defaultGallery       = $this->config->get('default_gallery', 'simple_gallery');
		if (SRPlugin::isEnabled($defaultGallery))
		{
			SRLayoutHelper::addIncludePath(SRPlugin::getLayoutPath($defaultGallery));
			$this->defaultGallery = SRLayoutHelper::render('gallery.default' . ((defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? '_' . SR_LAYOUT_STYLE : ''), array('media' => $this->item->media, 'alt_attr' => $this->item->name));
		}

		if (SRPlugin::isEnabled('hub'))
		{
			SRLayoutHelper::addIncludePath(SRPlugin::getSitePath('hub') . '/layouts');
		}

		$this->_prepareDocument();

		if (SRPlugin::isEnabled('user'))
		{
			array_push($this->_path['template'], SRPlugin::getSitePath('user') . '/views/reservationasset/tmpl');
		}

		$lang = JFactory::getLanguage();
		$lang->load('com_solidres_category_' . $this->item->category_id, JPATH_COMPONENT);

		if (!empty($this->item->params['enable_captcha'])
			&& JPluginHelper::isEnabled('captcha', 'recaptcha')
		)
		{
			JPluginHelper::importPlugin('captcha', 'recaptcha');
			$script = $this->document->_script;
			$this->app->triggerEvent('onInit', array('sr_reservation_recaptcha'));
			$this->document->_script = $script;
		}

		$this->dayMapping       = SRUtilities::getDayMapping();
		$this->tariffNetOrGross = $this->showTaxIncl == 1 ? 'net' : 'gross';
		$this->isFresh          = empty($this->checkin) && empty($this->checkout);
		$this->showTariffs      = true;
		$assetShowTariffs       = isset($this->item->params['show_tariffs']) ? $this->item->params['show_tariffs'] : 1; // Per asset option
		if (!$this->showFrontendTariffs || ($this->showFrontendTariffs == 2 && $this->isFresh))
		{
			$this->showTariffs = false;
		}

		$this->disableOnlineBooking = false;
		if (isset($this->item->params['disable_online_booking']) && 1 == $this->item->params['disable_online_booking'])
		{
			$this->disableOnlineBooking = true;
			if ($assetShowTariffs)
			{
				$this->showTariffs = true;
			}
			else
			{
				$this->showTariffs = false;
			}
		}

		JHtml::_('script', 'com_solidres/assets/cardform.min.js', $jsOptions);

		parent::display((defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? SR_LAYOUT_STYLE : null);
	}

	/**
	 * Prepares the document like adding meta tags/site name per ReservationAsset
	 *
	 * @return void
	 */
	protected function _prepareDocument()
	{
		if ($this->item->metatitle)
		{
			$this->document->setTitle($this->item->metatitle);
		}
		elseif ($this->item->name)
		{
			$this->document->setTitle($this->item->name . ', ' . $this->item->city . ', ' . $this->item->country_name . ' | ' . $this->item->address_1);
		}

		if ($this->item->metadesc)
		{
			$this->document->setDescription($this->item->metadesc);
		}

		if ($this->item->metakey)
		{
			$this->document->setMetadata('keywords', $this->item->metakey);
		}

		if ($this->item->metadata)
		{
			foreach ($this->item->metadata as $k => $v)
			{
				if ($v)
				{
					$this->document->setMetadata($k, $v);
				}
			}
		}

		$uri = JUri::getInstance();
		if (SRPlugin::isEnabled('hub'))
		{
			$canonicalLink = JRoute::_('index.php?option=com_solidres&task=reservationasset.checkavailability&id=' . $this->item->id);
		}
		else
		{
			$canonicalLink = JRoute::_('index.php?option=com_solidres&view=reservationasset&id=' . $this->item->id);
		}

		$this->document->addHeadLink(trim($uri->toString(array('host', 'scheme')) . $canonicalLink), 'canonical', 'rel');

		if (!isset($this->item->params['only_show_reservation_form']))
		{
			$this->item->params['only_show_reservation_form'] = 0;
		}

		$fbStars = '';
		for ($i = 1; $i <= $this->item->rating; $i++) :
			$fbStars .= '&#x2605;';
		endfor;

		$this->document->addCustomTag('<meta property="og:title" content="' . $fbStars . ' ' . $this->item->name . ', ' . $this->item->city . ', ' . $this->item->country_name . '"/>');
		$this->document->addCustomTag('<meta property="og:type" content="place"/>');
		$this->document->addCustomTag('<meta property="og:url" content="' . JRoute::_('index.php?option=com_solidres&view=reservationasset&id=' . $this->item->id, true, true) . '"/>');
		if (isset($this->item->media[0]))
		{
			$this->document->addCustomTag('<meta property="og:image" content="' . SRURI_MEDIA . '/assets/images/system/thumbnails/1/' . $this->item->media[0]->value . '"/>');
		}

		if (isset($this->item->media[1]))
		{
			$this->document->addCustomTag('<meta property="og:image" content="' . SRURI_MEDIA . '/assets/images/system/thumbnails/1/' . $this->item->media[1]->value . '"/>');
		}

		if (isset($this->item->media[2]))
		{
			$this->document->addCustomTag('<meta property="og:image" content="' . SRURI_MEDIA . '/assets/images/system/thumbnails/1/' . $this->item->media[2]->value . '"/>');
		}

		$this->document->addCustomTag('<meta property="og:site_name" content="' . JFactory::getConfig()->get('sitename') . '"/>');
		$this->document->addCustomTag('<meta property="og:description" content="' . strip_tags($this->item->description) . '"/>');
		$this->document->addCustomTag('<meta property="place:location:latitude"  content="' . $this->item->lat . '" />');
		$this->document->addCustomTag('<meta property="place:location:longitude" content="' . $this->item->lng . '" /> ');
	}

	/**
	 * Get the min price from a given tariff and show the formatted result
	 *
	 * @param $tariff
	 * @param $roomType
	 *
	 * @return string
	 *
	 * @since
	 */
	protected function getMinPrice($tariff, $roomType)
	{
		$min           = null;
		$minStayLength = 0;
		$isPrivate     = $roomType->is_private;

		switch ($tariff->type)
		{
			case 0: // rate per room per night
			case 4: // rate per room type per stay
				if ($tariff->mode == 1)
				{
					foreach ($tariff->details['per_room'] as $month => $details)
					{
						foreach ($details as $detail)
						{
							if (!isset($min) || $min->price > $detail->price)
							{
								$min = $detail;
							}
						}
					}
				}
				else
				{
					$min = array_reduce($tariff->details['per_room'], function ($t1, $t2) {
						return $t1->price < $t2->price ? $t1 : $t2;
					}, array_shift($tariff->details['per_room']));
				}

				$minStayLength = 1;
				break;
			case 1: // rate per person per night
				if ($tariff->mode == 1)
				{
					foreach ($tariff->details['adult1'] as $month => $details)
					{
						foreach ($details as $detail)
						{
							if (!isset($min) || $min->price > $detail->price)
							{
								$min = $detail;
							}
						}
					}
				}
				else
				{
					$min = array_reduce($tariff->details['adult1'], function ($t1, $t2) {
						return $t1->price < $t2->price ? $t1 : $t2;
					}, array_shift($tariff->details['adult1']));
				}

				$minStayLength = 1;
				break;
			case 2: // package per room
				$min           = $tariff->details['per_room'][0];
				$minStayLength = $tariff->d_min;
				break;
			case 3: // package per person
				$min           = $tariff->details['adult1'][0];
				$minStayLength = $tariff->d_min;
				break;
			default:
				break;
		}

		// Take single supplement value into consideration
		$enableSingleSupplement = 0;
		if (isset($roomType->params['enable_single_supplement']))
		{
			$enableSingleSupplement = $roomType->params['enable_single_supplement'];
		}

		if ($tariff->p_min <= 1 && $enableSingleSupplement)
		{
			if ($roomType->params['single_supplement_is_percent'])
			{
				$min->price = $min->price + ($min->price * ($roomType->params['single_supplement_value'] / 100));
			}
			else
			{
				$min->price = $min->price + $roomType->params['single_supplement_value'];
			}
		}

		// Calculate tax amount
		$totalImposedTaxAmount = 0;
		if (count($this->item->taxes) > 0)
		{
			foreach ($this->item->taxes as $taxType)
			{
				if ($this->item->price_includes_tax == 0)
				{
					$totalImposedTaxAmount += $min->price * $taxType->rate;
				}
				else
				{
					$totalImposedTaxAmount += $min->price - ($min->price / (1 + $taxType->rate));
					$min->price            -= $totalImposedTaxAmount;
				}
			}
		}

		$minCurrency = clone $this->solidresCurrency;
		$minCurrency->setValue($this->showTaxIncl ? ($min->price + $totalImposedTaxAmount) : $min->price);

		return $this->appendPriceSuffix($minCurrency, $tariff->type, $this->item->booking_type, $minStayLength, null, $isPrivate);
	}

	public function appendPriceSuffix($price, $tariffType, $bookingType, $minStayLength, $originalPrice = null, $isPrivate = true, $adults = 1, $children = 0)
	{
		$tariffSuffix = '';

		if ($tariffType == 0 || $tariffType == 2 || $tariffType == 4)
		{
			$tariffSuffix .= JText::_('SR_TARIFF_SUFFIX_PER_' . ($isPrivate ? 'ROOM' : 'BED'));
		}
		else
		{
			$tariffSuffix .= JText::plural('SR_TARIFF_SUFFIX_PER_PERSON', ($adults + $children));
		}

		$tariffSuffix .= JText::plural($bookingType == 0 ? 'SR_TARIFF_SUFFIX_NIGHT_NUMBER' : 'SR_TARIFF_SUFFIX_DAY_NUMBER', $minStayLength);

		$strikethrough = '';
		if (!is_null($originalPrice) && $originalPrice->getValue() > 0 && ($originalPrice->getValue() > $price->getValue()))
		{
			$strikethrough .= '<span class="sr-strikethrough">' . $originalPrice->format() . '</span>';
		}

		$appendedString = '<span class="starting_from">' . JText::_('SR_STARTING_FROM') . '</span><span class="min_tariff">' . $strikethrough . $price->format() . '</span><span class="tariff_suffix">' . $tariffSuffix . '</span>';

		return $appendedString;
	}
}
