<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/com_solidres/reservationasset/default_style2.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

?>
<div id="solidres" class="<?php echo SR_UI ?> reservation_asset_style">
    <div class="reservation_asset_item clearfix">
		<?php if ($this->item->params['only_show_reservation_form'] == 0) : ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                    <div class="asset-info">
                        <div class="asset-name">
                            <h1><?php echo $this->escape($this->item->name); ?></h1>
                        </div>
                        <div class="asset-rating">
							<?php for ($i = 1; $i <= $this->item->rating; $i++) : ?>
                                <i class="fa fa-star"></i>
							<?php endfor ?>
                        </div>
                        <div class="asset-address_1">
                            <a class="show_map"
                               href="<?php echo JRoute::_('index.php?option=com_solidres&task=map.show&id=' . $this->item->id) ?>">
                                <i class="fa fa-map-marker"></i>
								<?php
								echo $this->item->address_1 . ', ' .
									(!empty($this->item->city) ? $this->item->city . ', ' : '') .
									(!empty($this->item->postcode) ? $this->item->postcode . ', ' : '') .
									$this->item->country_name
								?>
                            </a>
                        </div>

						<?php if (!empty($this->item->address_2)) : ?>
                            <div class="asset-address_2"><?php echo $this->item->address_2; ?></div>
						<?php endif ?>

                        <div class="asset-wish-list"><?php echo $this->events->afterDisplayAssetName; ?></div>

                        <div class="asset-call-action">
                            <a href="#form" class="btn btn-large btn-lg btn-block btn-primary" title="Reserve now">
								<?php echo JText::_('SR_BOOK_NOW'); ?>
                            </a>
                        </div>

                        <div class="asset-contact">
                            <p><i class="fa fa-envelope fa-fw" title="<?php echo JText::_('SR_EMAIL') ?>"></i> <a
                                        href="mailto:<?php echo $this->item->email; ?>"><?php echo $this->item->email; ?></a>
                            </p>

							<?php if (!empty($this->item->phone)) : ?>
                                <p><i class="fa fa-phone-square fa-fw"
                                      title="<?php echo JText::_('SR_PHONE') ?>"></i> <?php echo '<a href="tel:' . $this->item->phone . '">' . $this->item->phone . '</a>'; ?>
                                </p>
							<?php endif ?>

							<?php if (!empty($this->item->fax)) : ?>
                                <p><i class="fa fa-fax fa-fw"
                                      title="<?php echo JText::_('SR_FAX') ?>"></i> <?php echo $this->item->fax; ?></p>
							<?php endif ?>

							<?php if (!empty($this->item->website)) : ?>
                                <p><i class="fa fa-globe fa-fw" title="<?php echo JText::_('SR_WEBSITE') ?>"></i> <a
                                            href="<?php echo $this->item->website; ?>"
                                            target="_blank"><?php echo $this->item->website; ?></a></p>
							<?php endif ?>
                        </div>

                        <div class="asset-social clearfix">
							<?php
							if (!empty($this->item->reservationasset_extra_fields['facebook_link'])
								&& $this->item->reservationasset_extra_fields['facebook_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['facebook_link']; ?>"
                                   target="_blank"><i class="fa fa-facebook-square"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['twitter_link'])
								&& $this->item->reservationasset_extra_fields['twitter_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['twitter_link']; ?>"
                                   target="_blank"><i class="fa fa-twitter-square"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['linkedin_link'])
								&& $this->item->reservationasset_extra_fields['linkedin_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['linkedin_link']; ?>"
                                   target="_blank"><i class="fa fa-linkedin-square"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['tumblr_link'])
								&& $this->item->reservationasset_extra_fields['tumblr_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['tumblr_link']; ?>"
                                   target="_blank"><i class="fa fa-tumblr-square"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['foursquare_link'])
								&& $this->item->reservationasset_extra_fields['foursquare_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['foursquare_link']; ?>"
                                   target="_blank"><i class="fa fa-foursquare"></i> </a>
							<?php endif;
							?>

							<?php
							if (!empty($this->item->reservationasset_extra_fields['pinterest_link'])
								&& $this->item->reservationasset_extra_fields['pinterest_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['pinterest_link']; ?>"
                                   target="_blank"><i class="fa fa-pinterest-square"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['slideshare_link'])
								&& $this->item->reservationasset_extra_fields['slideshare_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['slideshare_link']; ?>"
                                   target="_blank"><i class="fa fa-slideshare"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['vimeo_link'])
								&& $this->item->reservationasset_extra_fields['vimeo_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['vimeo_link']; ?>"
                                   target="_blank"><i class="fa fa-vimeo-square"></i> </a>
							<?php endif;
							?>
							<?php
							if (!empty($this->item->reservationasset_extra_fields['youtube_link'])
								&& $this->item->reservationasset_extra_fields['youtube_show'] == 1) : ?>
                                <a href="<?php echo $this->item->reservationasset_extra_fields['youtube_link']; ?>"
                                   target="_blank"> <i class="fa fa-youtube-square"></i> </a>
							<?php endif;
							?>
                        </div>
                    </div>
                </div>
                <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                    <div class="asset-gallery">
						<?php echo $this->defaultGallery; ?>
                    </div>
                </div>
            </div>

            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                    <div class="asset-tabs">
						<?php
						$tabTitle = array();
						$tabPane  = array();

						if (!empty($this->item->description) || !empty($this->item->facilities)) :

							$text = trim($this->item->description);

							if (!empty($this->item->facilities))
							{
								$text .= SRLayoutHelper::render('facility.facility', array('facilities' => $this->item->facilities));
							}

							$tabTitle[] = '<li class="active"><a href="#asset-desc" data-toggle="tab">' . JText::_('SR_DESCRIPTION') . '</a></li>';
							$tabPane[]  = '<div class="tab-pane active" id="asset-desc">' . $text . '</div>';
						endif;

						if (isset($this->item->feedbacks->render) && !empty($this->item->feedbacks->render)) :
							$activeClass = empty($tabTitle) ? 'active' : '';
							$tabTitle[]  = '<li class="' . $activeClass . '"><a href="#asset-feedbacks" data-toggle="tab">' . JText::_('SR_RESERVATION_FEEDBACKS') . '</a></li>';
							$tabPane[]   = '<div class="tab-pane ' . $activeClass . '" id="asset-feedbacks">' . $this->item->feedbacks->render . '</div>';
							$tabTitle[]  = '<li><a href="#asset-feedback-scores" data-toggle="tab">' . JText::_('SR_FEEDBACK_SCORES') . '</a></li>';
							$tabPane[]   = '<div class="tab-pane" id="asset-feedback-scores">' . $this->item->feedbacks->scores . '</div>';
						endif;

						?>

						<?php if (!empty($tabTitle)) : ?>
                            <ul class="nav nav-tabs">
								<?php echo join("\n", $tabTitle); ?>
                            </ul>
						<?php endif ?>

						<?php if (!empty($tabPane)) : ?>
                            <div class="tab-content">
								<?php echo join("\n", $tabPane); ?>
                            </div>
						<?php endif ?>
                    </div>
                </div>
            </div>
		<?php endif ?>

		<?php echo $this->events->beforeDisplayAssetForm; ?>
		<?php if (SRPlugin::isEnabled('user') && $this->showLoginBox) : ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                    <div class="alert alert-info sr-login-form">
						<?php
						if (!JFactory::getUser()->get('id')) :
							echo $this->loadTemplate('login');
						else:
							echo $this->loadTemplate('userinfo');
						endif;
						?>
                    </div>
                </div>
            </div>
		<?php endif; ?>

        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
				<?php echo $this->loadTemplate('roomtype' . ((defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? '_' . SR_LAYOUT_STYLE : '')); ?>
            </div>
        </div>

        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
				<?php echo $this->loadTemplate('information'); ?>
            </div>
        </div>

		<?php echo $this->events->afterDisplayAssetForm; ?>
		<?php if ($this->showPoweredByLink) : ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                    <p class="powered">
                        Powered by <a target="_blank"
                                      title="Solidres - A hotel booking extension for Joomla & WordPress"
                                      href="https://www.solidres.com">Solidres</a>
                    </p>
                </div>
            </div>
		<?php endif ?>
    </div>
</div>