<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/com_solidres/reservationasset/default.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory as CMSFactory;

HTMLHelper::_('behavior.tabstate');

?>
<div id="solidres" class="<?php echo SR_UI ?> reservation_asset_default">
    <div class="reservation_asset_item clearfix">
		<?php if ($this->item->params['only_show_reservation_form'] == 0 && !$this->isAmending) : ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_9 ?>">
                    <h1>
						<?php echo $this->escape($this->item->name) . ' '; ?>
						<?php for ($i = 1; $i <= $this->item->rating; $i++) : ?>
                            <i class="rating fa fa-star"></i>
						<?php endfor ?>
                    </h1>
                </div>
                <div class="<?php echo SR_UI_GRID_COL_3 ?>">
					<?php echo $this->events->afterDisplayAssetName; ?>
                </div>
            </div>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
					<span class="address_1 reservation_asset_subinfo">
					<?php
					echo $this->item->address_1 . ', ' .
						(!empty($this->item->city) ? $this->item->city . ', ' : '') .
						(!empty($this->item->geostate_code_2) ? $this->item->geostate_code_2 . ' ' : '') .
						(!empty($this->item->postcode) ? $this->item->postcode . ', ' : '') .
						$this->item->country_name
					?>
                        <a class="show_map"
                           href="<?php echo Route::_('index.php?option=com_solidres&task=map.show&id=' . $this->item->id) ?>">
							<?php echo Text::_('SR_SHOW_MAP') ?>
						</a>
					</span>

					<?php if (!empty($this->item->address_2)) : ?>
                        <span class="address_2 reservation_asset_subinfo">
						<?php echo $this->item->address_2; ?>
					</span>
					<?php endif ?>

					<?php if (!empty($this->item->phone)) : ?>
                        <span class="phone reservation_asset_subinfo">
						<?php echo Text::_('SR_PHONE') . ': <a href="tel:' . $this->item->phone . '">' . $this->item->phone . '</a>'; ?>
					</span>
					<?php endif ?>

					<?php if (!empty($this->item->fax)) : ?>
                        <span class="fax reservation_asset_subinfo">
						<?php echo Text::_('SR_FAX') . ': ' . $this->item->fax; ?>
					</span>
					<?php endif ?>

                    <span class="social_network reservation_asset_subinfo clearfix">
						<?php
						if (!empty($this->item->reservationasset_extra_fields['facebook_link'])
							&& $this->item->reservationasset_extra_fields['facebook_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['facebook_link']; ?>"
                               target="_blank"><i class="fa fa-facebook-official"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['twitter_link'])
							&& $this->item->reservationasset_extra_fields['twitter_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['twitter_link']; ?>"
                               target="_blank"><i class="fa fa-twitter-square"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['linkedin_link'])
							&& $this->item->reservationasset_extra_fields['linkedin_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['linkedin_link']; ?>"
                               target="_blank"><i class="fa fa-linkedin-square"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['tumblr_link'])
							&& $this->item->reservationasset_extra_fields['tumblr_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['tumblr_link']; ?>"
                               target="_blank"><i class="fa fa-tumblr-square"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['foursquare_link'])
							&& $this->item->reservationasset_extra_fields['foursquare_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['foursquare_link']; ?>"
                               target="_blank"><i class="fa fa-foursquare"></i> </a>
						<?php endif;
						?>

						<?php
						if (!empty($this->item->reservationasset_extra_fields['pinterest_link'])
							&& $this->item->reservationasset_extra_fields['pinterest_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['pinterest_link']; ?>"
                               target="_blank"><i class="fa fa-pinterest-square"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['slideshare_link'])
							&& $this->item->reservationasset_extra_fields['slideshare_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['slideshare_link']; ?>"
                               target="_blank"><i class="fa fa-slideshare"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['vimeo_link'])
							&& $this->item->reservationasset_extra_fields['vimeo_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['vimeo_link']; ?>"
                               target="_blank"><i class="fa fa-vimeo-square"></i> </a>
						<?php endif;
						?>
						<?php
						if (!empty($this->item->reservationasset_extra_fields['youtube_link'])
							&& $this->item->reservationasset_extra_fields['youtube_show'] == 1) : ?>
                            <a href="<?php echo $this->item->reservationasset_extra_fields['youtube_link']; ?>"
                               target="_blank"> <i class="fa fa-youtube-square"></i> </a>
						<?php endif;
						?>
					</span>
                </div>
            </div>

            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
					<?php echo $this->defaultGallery; ?>
                </div>
            </div>

            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
					<?php
					echo HTMLHelper::_('bootstrap.startTabSet', 'asset-info', array('active' => 'asset-desc'));

					if (!empty($this->item->description) || !empty($this->item->facilities)) :
						echo HTMLHelper::_('bootstrap.addTab', 'asset-info', 'asset-desc', Text::_('SR_DESCRIPTION', true));
						$text = trim($this->item->description);
						if (!empty($this->item->facilities)) :
							$text .= SRLayoutHelper::render('facility.facility', array('facilities' => $this->item->facilities));
						endif;

						echo $text;
						echo HTMLHelper::_('bootstrap.endTab');
					endif;

					if (isset($this->item->feedbacks->render) && !empty($this->item->feedbacks->render)) :
						echo HTMLHelper::_('bootstrap.addTab', 'asset-info', 'asset-feedback', Text::_('SR_RESERVATION_FEEDBACKS', true));
						echo $this->item->feedbacks->render;
						echo HTMLHelper::_('bootstrap.endTab');

						echo HTMLHelper::_('bootstrap.addTab', 'asset-info', 'asset-feedback-scores', Text::_('SR_FEEDBACK_SCORES', true));
						echo $this->item->feedbacks->scores;
						echo HTMLHelper::_('bootstrap.endTab');
					endif;

					echo HTMLHelper::_('bootstrap.endTabSet');
					?>
                </div>
            </div>

		<?php endif ?>

		<?php echo $this->events->beforeDisplayAssetForm; ?>
		<?php if (SRPlugin::isEnabled('user') && $this->showLoginBox && !$this->isAmending) : ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                    <div class="alert alert-info sr-login-form">
						<?php
						if (!CMSFactory::getUser()->get('id')) :
							echo $this->loadTemplate('login');
						else:
							echo $this->loadTemplate('userinfo');
						endif;
						?>
                    </div>
                </div>
            </div>
		<?php endif; ?>

        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
				<?php echo $this->loadTemplate('roomtype'); ?>
            </div>
        </div>

        <?php if (!$this->isAmending) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
				<?php echo $this->loadTemplate('information'); ?>
            </div>
        </div>
        <?php endif ?>

		<?php echo $this->events->afterDisplayAssetForm; ?>
		<?php if ($this->showPoweredByLink) : ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
                    <p>
                        Powered by <a target="_blank" title="Solidres - A hotel booking extension for Joomla"
                                      href="https://www.solidres.com">Solidres</a>
                    </p>
                </div>
            </div>
		<?php endif ?>
    </div>
</div>
