<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');

/**
 * Discount view class
 *
 * @package     Solidres
 * @subpackage	Discount
 * @since		0.6.0
 */
class SolidresViewDiscounts extends JViewLegacy
{
	protected $state;
	protected $items;
	protected $pagination;
	protected $config;
	
    function display($tpl = null)
	{
    	if (SR_PLUGIN_DISCOUNT_ENABLED)
		{
			$model = $this->getModel();
			$this->items = $model->getItems();
			$this->pagination = $model->getPagination();
			$this->state = $model->getState();
			$this->config = JComponentHelper::getParams('com_solidres');
			$this->showPoweredByLink = $this->config->get('show_solidres_copyright', '1');

			if (count($errors = $this->get('Errors')))
			{
				JError::raiseError(500, implode("\n", $errors));
				return false;
			}

			JHtml::stylesheet('com_solidres/assets/main.min.css', false, true);
			JFactory::getLanguage()->load('plg_solidres_discount', JPATH_ADMINISTRATOR, null, 1);
			JHtml::stylesheet('plg_solidres_hub/assets/hub.min.css', false, true);
			JLoader::register('SRToolbarHelper', JPATH_SITE . '/components/com_solidres/helpers/toolbar.php');

			$this->addToolbar();
		}

		parent::display($tpl);
    }

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		$state	= $this->get('State');
		$canDo	= SolidresHelper::getActions();

		SRToolBarHelper::title(JText::_('SR_DASHBOARD'). ' - ' . JText::_('SR_MANAGE_DISCOUNTS'), 'generic.png');
		if ($canDo->get('core.create')) {
			SRToolBarHelper::addNew('discountform.add','JTOOLBAR_NEW');
		}
		if ($canDo->get('core.edit')) {
			SRToolBarHelper::editList('discountform.edit','JTOOLBAR_EDIT');
		}
		if ($canDo->get('core.edit.state')) {
			if ($state->get('filter.state') != 2){
				SRToolBarHelper::divider();
				SRToolBarHelper::custom('discounts.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
				SRToolBarHelper::custom('discounts.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
			}
			if ($state->get('filter.state') != -1 ) {
				SRToolBarHelper::divider();
				if ($state->get('filter.state') != 2) {
					//JToolBarHelper::archiveList('discounts.archive','JTOOLBAR_ARCHIVE');
				}
				else if ($state->get('filter.state') == 2) {
					SRToolBarHelper::unarchiveList('discounts.publish', 'JTOOLBAR_UNARCHIVE');
				}
			}	
		}
		if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
			SRToolBarHelper::deleteList('', 'discounts.delete','JTOOLBAR_EMPTY_TRASH');
		} else if ($canDo->get('core.edit.state')) {
			SRToolBarHelper::trash('discounts.trash','JTOOLBAR_TRASH');
		}
	}
}