<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

JLoader::register('SRDiscount', JPATH_PLUGINS . '/solidres/discount/libraries/discount/discount.php');

/**
 * View to edit discount in front end
 *
 * @package     Solidres
 * @subpackage	Discount
 * @since		0.6.0
 */
class SolidresViewDiscountForm extends JViewLegacy
{
	protected $state;
	protected $form;
	protected $returnPage;
	protected $id;
	protected $reservationAssetId;
	protected $config;

	public function display($tpl = null)
	{
		$model = $this->getModel();
		$this->state = $model->getState();
		$this->form	= $model->getForm();
		$this->returnPage = $model->getReturnPage();
		$user = JFactory::getUser();
		$this->id = $this->form->getValue('id');
		$this->reservationAssetId = $this->form->getValue('reservation_asset_id');
		$formParams = $this->form->getValue('params');
		$this->config = JComponentHelper::getParams('com_solidres');
		$this->showPoweredByLink = $this->config->get('show_solidres_copyright', '1');

		JFactory::getLanguage()->load('plg_solidres_discount', JPATH_ADMINISTRATOR, null, 1);

		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		JHtml::_('behavior.framework');
		JHtml::stylesheet('com_solidres/assets/main.min.css', false, true);
		JHtml::script('plg_solidres_discount/assets/discount.min.js', false, true);
		JHtml::stylesheet('plg_solidres_hub/assets/hub.min.css', false, true);
		JLoader::register('SRToolbarHelper', JPATH_SITE . '/components/com_solidres/helpers/toolbar.php');
		JText::script('SR_DISCOUNT_ASSET_CHANGE');

		if (empty($this->id))
		{
			$authorised = $user->authorise('core.create', 'com_solidres') || (count($user->getAuthorisedCategories('com_solidres', 'core.create')));
		}
		else
		{
			$authorised = $formParams->{'access-edit'};
		}

		if ($authorised !== true)
		{
			JError::raiseError(403, JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}

		SRHtml::_('jquery.datepicker');

		$this->addToolbar();
        
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		include JPATH_COMPONENT.'/helpers/toolbar.php';
		$isNew = ($this->id == 0);
		$canDo = SolidresHelper::getActions('', $this->reservationAssetId);
		
		if($isNew)
		{
			SRToolbarHelper::title(JText::_('SR_DASHBOARD'). ' - ' . JText::_('SR_ADD_NEW_DISCOUNT'), 'generic.png');
		}
		else
		{
			SRToolbarHelper::title(JText::_('SR_DASHBOARD'). ' - ' . JText::sprintf('SR_EDIT_DISCOUNT', $this->form->getValue('title')), 'generic.png');
		}
		
		JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
		
		// If not checked out, can save the item.
		if ($canDo->get('core.edit'))
		{
			SRToolbarHelper::apply('discountform.apply', 'JToolbar_Apply');
			SRToolbarHelper::save('discountform.save', 'JToolbar_Save');
			SRToolbarHelper::addNew('discountform.save2new', 'JToolbar_Save_and_new');
		}
		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create'))
		{
			SRToolbarHelper::custom('discountform.save2copy', 'copy.png', 'copy_f2.png', 'JToolbar_Save_as_Copy', false);
		}
		
		if (empty($this->id))
		{
			SRToolbarHelper::cancel('discountform.cancel', 'JToolbar_Cancel');
		}
		else
		{
			SRToolbarHelper::cancel('discountform.cancel', 'JToolbar_Close');
		}
	}
}
