<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;


$model=$displayData['model'];
$controller=$displayData['controller'];
$room_types=$displayData['room_types'];

$week_end=$displayData['week_end'];
$week_start=$displayData['week_start'];
$current_date=$displayData['current_date'];
$navigation_type=$displayData['navigation_type'];
$asset_id=$displayData['asset_id'];
$timezone=$displayData['timezone'];

$day_from=JDate::getInstance($week_start,$timezone)->format('F d, Y', true);
$day_to=JDate::getInstance($week_end,$timezone)->format('F d, Y', true);
$frontend = JFactory::getApplication()->isSite();
?>
	<table class="sr_statistics_table sr_statistics_week_table" border="0" cellpadding="0" cellspacing="0">
		<tr class="sr_statistics_rows sr_statistics_header_row">
	<?php
	for($d=0;$d<7;$d++) :
		$today_class="";
		$today_date=JDate::getInstance("now",$timezone)->format('D M d',true);

		if($d==0) :
			$date_tmp=JDate::getInstance($week_start,$timezone)->format('D M d',true);
		else :
			$date_tmp=JDate::getInstance($week_start.' +'.$d.' day',$timezone)->format('D M d',true);
		endif;

		if($today_date==$date_tmp) :
			$today_class=' class="sr_dashboard_today" ';
		endif;

		?>

		<td <?php echo $today_class;?>><?php echo $date_tmp;?></td>

		<?php
	endfor;

	?></tr>

	<?php

	for($i=0;$i<count($room_types);$i++) :
		$room_type=$room_types[$i];
		?>
		<tr>
			<td colspan="7"></td>
		</tr>
		<?php

		$rooms=$model->getRooms($room_type->id);
		$rows_n=1;
		for($r=0;$r<count($rooms);$r++) :

			$room=$rooms[$r];
			$tr_tmp_class=$i%2 ?  "sr_odd_row" : "sr_even_row";
			?>
			<tr class="<?php echo $tr_tmp_class;?>">
				<?php
				for($d=0;$d<7;$d++) :
					if($d==0) :
						$date_tmp=JDate::getInstance($week_start,$timezone)->format('Y-m-d',true);
					else :
						$date_tmp=JDate::getInstance($week_start.' +'.$d.' day',$timezone)->format('Y-m-d',true);
					endif;

					$limited_booking=$model->isLimitedBooking($asset_id,$room->id,$date_tmp);

					if(count($limited_booking)) :
						$limit_booking_interval = date_diff(date_create($limited_booking->start_date), date_create($limited_booking->end_date));
						$total_limited_days=(int)$limit_booking_interval->format('%a');

						$limited_colspan=$total_limited_days;
						$increased_steps=$d+$total_limited_days;

						if($increased_steps>7) :
							$limited_colspan=(7 - $d) + 1;
							$d=7;
						else :
							$d=$d+($total_limited_days-1);
						endif;

						?>
						<td class="sr_statistics_limited" colspan="<?php echo $limited_colspan;?>"><?php echo $limited_booking->title;?> </td>
						<?php
					else :
						$booked_infoes=$model->getBookedRoom($asset_id,$room->id,$date_tmp);

						if(count($booked_infoes)) :
							$booked_info=$booked_infoes[0];

							$reservation_text='<a title="'.JText::_('SR_STATISTICS_DASHBOARD_RESERVED_BY').' '.$booked_info->customer_firstname.' '.$booked_info->customer_middlename.' '.$booked_info->customer_lastname.'" href="index.php?option=com_solidres&task=reservation'.($frontend ? 'form' : '' ).'.edit&id='.$booked_info->id.'">'.JText::_('SR_STATISTICS_DASHBOARD_RESERVATION').' '.$booked_info->code.'</a>';
							$state_class=$controller->getStateClass($booked_info->state);
							$colspan=1;

							$checkin_date = date_create($booked_info->checkin);

							if($d==0) :
								$checkin_date = date_create($week_start);
							endif;
							$checkout_date = date_create($booked_info->checkout);
							$interval = date_diff($checkin_date, $checkout_date);
							$total_booked_days=(int)$interval->format('%a');

							if($total_booked_days + $d > 7) :
								$colspan=(7 - $d)+1;
							else :
								$colspan=$total_booked_days;
							endif;
							?>

							<td class="booked_date <?php echo $state_class;?>" colspan="<?php echo $colspan;?>"><?php echo $reservation_text;?></td>

							<?php
							if($colspan>1) :
								$d=$d+($colspan-1);
							endif;
						else :
							$weekend="";

							if(date('N',strtotime($date_tmp))>5) :
								$weekend="weekends";
							endif;

							$col_id_arr=array('col_date'=>$date_tmp,'col_room_id'=>$room->id,'asset_id'=>$room_type->reservation_asset_id);

							?>
							<td class="ui-widget-content free_dates <?php echo $weekend;?>" id="<?php echo base64_encode(base64_encode(json_encode($col_id_arr)));?>"></td>
							<?php
						endif;
					endif;
				endfor;
			?></tr><?php
			$rows_n=$rows_n+1;
		endfor;
	endfor;
	?>
	</table>
	</div>
</div>
<input type="hidden" name="temp_date" value="<?php echo $current_date;?>" />