<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/
defined('_JEXEC') or die;

/**
 * @var array    $displayData
 * @var string   $checked
 * @var string   $element
 * @var SRConfig $solidresPaymentConfigData
 * @var stdClass $reservationDetails
 */

use Joomla\CMS\Language\Text;

extract($displayData);

$title                   = Text::_('SR_PAYMENT_METHOD_' . strtoupper($element));
$configuredAcceptedCards = trim($solidresPaymentConfigData->get('payments/' . $element . '/' . $element . '_accepted_cards', ''));
$accepted                = [];
$acceptedJs              = [];

if (!empty($configuredAcceptedCards))
{
	$acceptedCards = json_decode($configuredAcceptedCards, true) ?: [];
	$cardList      = [
		'visa'       => 'Visa',
		'mastercard' => 'MasterCard',
		'amex'       => 'Amex',
		'dinersclub' => 'Diners Club',
		'enroute'    => 'enRoute',
		'discover'   => 'Discover',
		'jcb'        => 'JCB',
	];

	foreach ($acceptedCards as $card)
	{
		$accepted[]        = $cardList[$card];
		$acceptedJs[$card] = true;
	}
}

if (empty($acceptedJs))
{
	$acceptedJs['all'] = true;
}

?>

<div class="sr-payment-card-form-container"
     data-element="<?php echo $element; ?>"
     data-accepted-cards="<?php echo htmlspecialchars(json_encode($acceptedJs)); ?>">

	<?php if (empty($hideCheckbox)): ?>
        <input class="payment_method_radio" id="payment-method-<?php echo $element; ?>"
               type="radio"
               name="jform[payment_method_id]"
               value="<?php echo $element; ?>"
			<?php echo $checked ?>
        />

        <span class="popover_payment_methods"
              data-content="<?php echo SRUtilities::translateText($solidresPaymentConfigData->get('payments/' . $element . '/' . $element . '_frontend_message')); ?>"
              data-title="<?php echo $title; ?>">
		<?php echo $title; ?>
		<i class="fa fa-question-circle"></i>
	</span>
	<?php endif; ?>

    <div class="payment_method_<?php echo $element; ?>_details payment_method_details <?php echo $checked == 'checked' ? '' : 'nodisplay'; ?>">
        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
            <div class="<?php echo SR_UI_GRID_COL_6 ?>">

                <label for="jform[<?php echo $element; ?>][cardholder]">
					<?php echo Text::_('SR_PAYMENT_CARD_HOLDER') ?>
                </label>

                <input class="input-block-level form-control"
                       name="jform[<?php echo $element; ?>][cardHolder]"
                       type="text"
                       autocomplete="off"
                       value="<?php echo isset($reservationDetails->guest[$element]['cardHolder']) ? $reservationDetails->guest[$element]['cardHolder'] : ''; ?>"
                />
                <label for="jform[<?php echo $element; ?>][cardNumber]">
					<?php echo Text::_('SR_PAYMENT_CARD_NUMBER') ?>
                </label>

                <input class="input-block-level form-control"
                       name="jform[<?php echo $element; ?>][cardNumber]"
                       type="text"
                       autocomplete="off"
                       value=""
                />
				<?php if ($accepted): ?>
                    <span class="help-block">
                        <?php echo Text::sprintf('SR_PAYMENT_WE_ACCEPT_FORMAT', join(', ', $accepted)); ?>
                    </span>
				<?php endif; ?>
            </div>

            <div class="<?php echo SR_UI_GRID_COL_6; ?>">
                <?php $cvv = $solidresPaymentConfigData->get('payments/' . $element . '/' . $element . '_enable_cvv'); ?>
				<?php if (null === $cvv || 1 == $cvv) : ?>
                    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                        <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                            <label for="jform[<?php echo $element; ?>][cardCVV]">
								<?php echo Text::_('SR_PAYMENT_CARD_CVV') ?>
                            </label>
                            <input class="input-block-level form-control" name="jform[<?php echo $element; ?>][cardCVV]"
                                   type="text"
                                   autocomplete="off"/>
                        </div>
                    </div>
				<?php endif ?>

                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                        <input type="hidden" name="jform[<?php echo $element; ?>][expiryMonth]"/>
                        <input type="hidden" name="jform[<?php echo $element; ?>][expiryYear]"/>
                        <label for="sr-<?php echo $element; ?>-expiration">
							<?php echo Text::_('SR_PAYMENT_EXPIRATION'); ?>
                        </label>
                        <input class="input-block-level form-control sr-payment-<?php echo $element; ?>-expiration"
                               name="sr_payment_<?php echo $element; ?>_expiration"
                               type="text" size="5"
                               id="sr-<?php echo $element; ?>-expiration"
                               placeholder="MM/YY"/>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>