<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('JPATH_BASE') or die;

$data = $displayData;

// Receive overridable options
$data['options'] = !empty($data['options']) ? $data['options'] : array();

// Set some basic options
$customOptions = array(
	'filtersHidden'       => isset($data['options']['filtersHidden']) ? $data['options']['filtersHidden'] : empty($data['view']->activeFilters),
	'defaultLimit'        => isset($data['options']['defaultLimit']) ? $data['options']['defaultLimit'] : JFactory::getApplication()->get('list_limit', 20),
	'searchFieldSelector' => '#filter_search',
	'orderFieldSelector'  => '#list_fullordering'
);

$data['options'] = array_merge($customOptions, $data['options']);

$formSelector = !empty($data['options']['formSelector']) ? $data['options']['formSelector'] : '#adminForm';

// Load search tools
JHtml::_('searchtools.form', $formSelector, $data['options']);
?>
<div class="js-stools clearfix">
    <div class="clearfix <?php echo 'bs3' == SR_UI ? 'row' : '' ?>">
        <div class="js-stools-container-bar <?php echo 'bs3' == SR_UI ? 'col-md-10' : '' ?>">
			<?php echo JLayoutHelper::render('joomla.searchtools.default.bar', $data); ?>
        </div>
        <div class="js-stools-container-list hidden-phone hidden-tablet <?php echo 'bs3' == SR_UI ? 'col-md-2' : '' ?>">
			<?php echo JLayoutHelper::render('joomla.searchtools.default.list', $data); ?>
        </div>
    </div>
    <!-- Filters div -->
    <div class="js-stools-container-filters clearfix">
		<?php echo JLayoutHelper::render('joomla.searchtools.default.filters', $data); ?>
    </div>
</div>
