<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

extract($displayData);
?>

<h3><?php echo JText::_('SR_ROOM_AND_RATE_INFORMATION') ?></h3>

<table class="table table-bordered">
    <tbody>
	<?php
	// Room cost
	$extraList                      = array();
	foreach ($roomTypes as $roomTypeId => $roomTypeDetails) :
		foreach ($roomTypeDetails['rooms'] as $tariffId => $roomDetails) :
			$tariffType = SRUtilities::getTariffType($tariffId);
			$isBookingWholeRoomType = false;
			$rowspan                = 0;
			if ($tariffType == PER_ROOM_TYPE_PER_STAY) :
				$isBookingWholeRoomType = true;
				$rowspan                = count($roomTypeDetails['rooms'][$tariffId]);
			endif;

			$roomIndexCount = 1;
			foreach ($roomDetails as $roomIndex => $roomCost) :
				$hasDiscount = false;
				if ($roomCost['currency']['total_discount'] > 0) :
					$hasDiscount = true;
				endif;

				$skipCost = false;
				if ($isBookingWholeRoomType && $roomIndexCount > 1) :
					$skipCost = true;
				endif;

				$roomInfo = $reservationDetails->room['room_types'][$roomTypeId][$tariffId][$roomIndex];

				// Build a per room extra list array
				if (isset($roomInfo['extras']) && is_array($roomInfo['extras'])) :
					foreach ($roomInfo['extras'] as $extraItemKey => $extraItemDetails) :
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['room_type_name'] = $roomTypeDetails['name'];
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['name']           = $extraItemDetails['name'];
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['quantity']       = $extraItemDetails['quantity'];
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['currency']       = clone $currency;
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['currency']->setValue($extraItemDetails['total_extra_cost_tax_' . ($showRoomTax ? 'excl' : 'incl')]);
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['currency_tax'] = clone $currency;
						$extraList[$roomTypeId][$tariffId][$roomIndex]['extras'][$extraItemKey]['currency_tax']->setValue($extraItemDetails['total_extra_cost_tax_incl'] - $extraItemDetails['total_extra_cost_tax_excl']);
					endforeach;
				endif;
				?>
                <tr>
                    <td>
						<?php echo JText::_('SR_ROOM') . ': ' ?>
						<?php echo $roomTypeDetails["name"] ?>
                        <a href="javascript:void(0)" class="toggle_room_confirmation"
                           data-target="<?php echo $roomTypeId ?>_<?php echo $tariffId ?>_<?php echo $roomIndex ?>">
							<?php echo JText::_('SR_CONFIRMATION_ROOM_DETAILS') ?>
                        </a>
						<?php if ($isBookingWholeRoomType) : ?>
                            <p><?php echo !empty($roomCost['currency']['title']) ? '(' . $roomCost['currency']['title'] . ')' : '' ?></p>
						<?php endif ?>
                        <ul id="rc_<?php echo $roomTypeId ?>_<?php echo $tariffId ?>_<?php echo $roomIndex ?>_guestinfo"
                            style="display: none">
							<?php if (!empty($roomInfo['guest_fullname'])) : ?>
                                <li><?php echo JText::_('SR_CONFIRMATION_GUEST_NAME') . ': ' . $roomInfo['guest_fullname'] ?></li>
							<?php endif; ?>
                            <li><?php echo JText::_('SR_CONFIRMATION_ADULT_NUMBER') . ': ' . (isset($roomInfo['adults_number']) ? $roomInfo['adults_number'] : 0) ?></li>
							<?php if (!empty($roomInfo['children_number'])) : ?>
                                <li><?php echo JText::_('SR_CONFIRMATION_CHILD_NUMBER') . ': ' . $roomInfo['children_number'] ?></li>
							<?php endif ?>
                        </ul>
                    </td>
                    <td>
						<?php
						if (0 == $bookingType) :
							echo JText::plural("SR_NIGHTS", $stayLength);
						else :
							echo JText::plural("SR_DAYS", $stayLength + 1);
						endif;
						?>
                    </td>
					<?php if (!$isBookingWholeRoomType || ($isBookingWholeRoomType && $roomIndexCount == 1)) : ?>
                        <td class="sr-align-right" <?php echo $isBookingWholeRoomType ? 'rowspan="' . $rowspan . '" style="vertical-align: middle"' : '' ?>>
							<?php
							if (isset($roomCost['currency']['total_price_tax_excl_formatted'])) :
								echo $roomCost['currency']['total_price_tax_excl_formatted']->format();
							endif
							?>
                        </td>
					<?php endif ?>
                </tr>
				<?php
				$roomIndexCount++;
			endforeach;
		endforeach;
	endforeach;

	// Total room cost
	$showRoomTax = 0;
	if (isset($reservationDetails->asset_params['show_room_tax_confirmation'])) :
		$showRoomTax = $reservationDetails->asset_params['show_room_tax_confirmation'];
	endif;
	$totalRoomCost = new SRCurrency($cost['total_price_tax_' . ($showRoomTax ? 'excl' : 'incl')], $reservationDetails->currency_id);
	?>

    <tr class="nobordered first">
        <td colspan="2" class="sr-align-right">
			<?php echo JText::_("SR_TOTAL_ROOM_COST_TAX_" . ($showRoomTax ? 'EXCL' : 'INCL')) ?>
        </td>
        <td class="sr-align-right noleftborder">
			<?php echo $totalRoomCost->format() ?>
        </td>
    </tr>

	<?php
	// In case of pre tax discount
	if ($cost['total_discount'] > 0 && $isDiscountPreTax) :
		$totalDiscount = new SRCurrency($cost['total_discount'], $reservationDetails->currency_id);
		?>
        <tr class="nobordered">
            <td colspan="2" class="sr-align-right">
				<?php echo JText::_("SR_TOTAL_DISCOUNT") ?>
            </td>
            <td class="sr-align-right noleftborder">
				<?php echo '-' . $totalDiscount->format() ?>
            </td>
        </tr>
	<?php
	endif;

	// Imposed taxes
	if ($showRoomTax) :
		$taxItem = new SRCurrency($cost['tax_amount'], $reservationDetails->currency_id);
		?>
        <tr class="nobordered">
            <td colspan="2" class="sr-align-right">
				<?php echo JText::_('SR_TOTAL_ROOM_TAX') ?>
            </td>
            <td class="sr-align-right noleftborder">
				<?php echo $taxItem->format() ?>
            </td>
        </tr>
	<?php
	endif;

	// In case of after tax discount
	if ($cost['total_discount'] > 0 && !$isDiscountPreTax) :
		$totalDiscount = new SRCurrency($cost['total_discount'], $reservationDetails->currency_id);
		?>
        <tr class="nobordered">
            <td colspan="2" class="sr-align-right">
				<?php echo JText::_("SR_TOTAL_DISCOUNT") ?>
            </td>
            <td class="sr-align-right noleftborder">
				<?php echo '-' . $totalDiscount->format() ?>
            </td>
        </tr>
	<?php
	endif;

	// Per room extra list
	if (!empty($extraList)) :
		foreach ($extraList as $extraRoomTypeId => $extraRoomTypeTariffs) :
			foreach ($extraRoomTypeTariffs as $extraTariffId => $extraRooms) :
				foreach ($extraRooms as $extraRoomIndex => $extraRoomExtras) :
					foreach ($extraRoomExtras as $extraRoomExtraKey => $extraRoomExtraDetails) :
						foreach ($extraRoomExtraDetails as $extraRoomExtraId => $extraRoomExtraIdDetails) :
							?>
                            <tr class="extracost_confirmation" style="display: none">
                                <td>
                                    <p>
										<?php echo JText::_('SR_EXTRA') . ': ' ?><?php echo $extraRoomExtraIdDetails['name'] ?>
                                    </p>
                                    <p>
										<?php echo JText::_('SR_ROOM') . ': ' ?><?php echo $extraRoomExtraIdDetails['room_type_name'] ?>
                                    </p>
                                </td>
                                <td>
									<?php echo $extraRoomExtraIdDetails['quantity'] ?>
                                </td>
                                <td class="sr-align-right ">
									<?php echo $extraRoomExtraIdDetails['currency']->format() ?>
                                </td>
                            </tr>
						<?php
						endforeach;
					endforeach;
				endforeach;
			endforeach;
		endforeach;
	endif;

	// Per booking extra list
	$perBookingExtraList = isset($reservationDetails->guest['extras']) ? $reservationDetails->guest['extras'] : array();

	foreach ($perBookingExtraList as $perBookingExtraId => $perBookingExtraDetails) :
		?>
        <tr class="extracost_confirmation" style="display: none">
            <td>
                <p>
					<?php echo JText::_('SR_EXTRA') . ': ' ?><?php echo $perBookingExtraDetails['name'] ?>
                </p>
                <p>
					<?php echo JText::_('SR_EXTRA_PER_BOOKING') ?>
                </p>
            </td>
            <td>
				<?php echo $perBookingExtraDetails['quantity'] ?>
            </td>
            <td class="sr-align-right ">
				<?php
				$perBookingExtraCurrency = clone $currency;
				$perBookingExtraCurrency->setValue($perBookingExtraDetails['total_extra_cost_tax_excl']);
				$perBookingExtraCurrencyTax = clone $currency;
				$perBookingExtraCurrencyTax->setValue($perBookingExtraDetails['total_extra_cost_tax_incl'] - $perBookingExtraDetails['total_extra_cost_tax_excl']);
				?>
				<?php echo $perBookingExtraCurrency->format() ?>
            </td>
        </tr>
	<?php
	endforeach;

	// Extra cost
	$totalExtraCost          = new SRCurrency($showRoomTax ? $totalRoomTypeExtraCostTaxExcl : $totalRoomTypeExtraCostTaxIncl, $reservationDetails->currency_id);
	$totalExtraCostTaxAmount = new SRCurrency($totalRoomTypeExtraCostTaxIncl - $totalRoomTypeExtraCostTaxExcl, $reservationDetails->currency_id);

	if ($totalExtraCost->getValue() > 0) :
		?>
        <tr class="nobordered extracost_row">
            <td colspan="2" class="sr-align-right">
                <a href="javascript:void(0)" class="toggle_extracost_confirmation">
					<?php echo JText::_('SR_TOTAL_EXTRA_COST_TAX_' . ($showRoomTax ? 'EXCL' : 'INCL')) ?>
                </a>
            </td>
            <td id="total-extra-cost" class="sr-align-right noleftborder">
				<?php echo $totalExtraCost->format() ?>
            </td>
        </tr>

		<?php if ($showRoomTax) : ?>
        <tr class="nobordered">
            <td colspan="2" class="sr-align-right">
				<?php echo JText::_("SR_TOTAL_EXTRA_COST_TAX_AMOUNT") ?>
            </td>
            <td id="total-extra-cost" class="sr-align-right noleftborder">
				<?php echo $totalExtraCostTaxAmount->format() ?>
            </td>
        </tr>
	<?php endif; ?>

	<?php endif; ?>

	<?php

	// Tourist tax cost
	if ($cost['tourist_tax_amount'] > 0) :
		$touristTaxAmount = new SRCurrency($cost['tourist_tax_amount'], $reservationDetails->currency_id);
		?>
        <tr class="nobordered">
            <td colspan="2" class="sr-align-right">
				<?php echo JText::_("SR_TOURIST_TAX_AMOUNT") ?>
            </td>
            <td class="sr-align-right noleftborder">
				<?php echo $touristTaxAmount->format() ?>
            </td>
        </tr>
	<?php
	endif;

	// Grand total cost
	if ($isDiscountPreTax) :
		$grandTotalAmount = $cost['total_price_tax_excl_discounted'] + $cost['tax_amount'] + $totalRoomTypeExtraCostTaxIncl;
	else :
		$grandTotalAmount = $cost['total_price_tax_excl'] + $cost['tax_amount'] - $cost['total_discount'] + $totalRoomTypeExtraCostTaxIncl;
	endif;

	if ($cost['tourist_tax_amount'] > 0) :
		$grandTotalAmount += $cost['tourist_tax_amount'];
	endif;

	$grandTotal = new SRCurrency($grandTotalAmount, $reservationDetails->currency_id);

	?>
    <tr class="nobordered">
        <td colspan="2" class="sr-align-right">
            <strong><?php echo JText::_("SR_GRAND_TOTAL") ?></strong>
        </td>
        <td class="sr-align-right gra noleftborder">
            <strong><?php echo $grandTotal->format() ?></strong>
        </td>
    </tr>
    </tbody>
</table>