<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

extract($displayData);

$solidresRoomType    = SRFactory::get('solidres.roomtype.roomtype');
$solidresReservation = SRFactory::get('solidres.reservation.reservation');

$isStandardTariff = $tariff->valid_from == '00-00-0000' && $tariff->valid_to == '00-00-0000';

$showDateInfo = !empty($checkIn) && !empty($checkOut);

// Since v2.6.0, the maximum months in date picker is 2
$datePickerMonthNum = $datePickerMonthNum > 2 ? 2 : $datePickerMonthNum;

// An integer array of all enabled checkin days in a week
$enabledCheckinDays = $tariff->limit_checkin;

// If valid from is in the past, switch valid from to now
// (need to take min days book in advance into consideration)
$now = strtotime("now");
if ($now > strtotime($tariff->valid_from)) :
	$tariff->valid_from = date('d-m-Y', $now);
endif;

$unavailableDates = array();

$tariffStartDate    = (new DateTime($tariff->valid_from))->modify('first day of this month');
$tariffEndDate      = (new DateTime($tariff->valid_to))->modify('first day of next month');
$tariffDateInterval = DateInterval::createFromDateString('1 month');
$tariffPeriod       = new DatePeriod($tariffStartDate, $tariffDateInterval, $tariffEndDate);

foreach ($tariffPeriod as $period) :
	$unavailableDatesPeriod = $solidresRoomType->getUnavailableDates(
		$roomTypeId,
		$period->format('Y'),
		$period->format('m')
	);

	$unavailableDates = array_merge($unavailableDates, $unavailableDatesPeriod);
endforeach;

$checkInDates = array();
foreach ($unavailableDates as $unavailableDate) :
	if ($solidresReservation->hasCheckIn($roomTypeId, $unavailableDate)) :
		$checkInDates[] = $unavailableDate;
	endif;
endforeach;

if (!$isStandardTariff) :
	$dayDiff = SRUtilities::calculateDateDiff(JDate::getInstance('now', $timezone)->format('d-m-Y'), $tariff->valid_from);
	if ($dayDiff < $minDaysBookInAdvance) :
		$dateCheckIn = JDate::getInstance($tariff->valid_from, $timezone)->add(new DateInterval('P' . ($minDaysBookInAdvance - $dayDiff) . 'D'));
	else :
		$dateCheckIn = JDate::getInstance($tariff->valid_from, $timezone);
	endif;
	$dateCheckOut = JDate::getInstance($tariff->valid_from, $timezone);
else :
	$dateCheckIn  = JDate::getInstance('now', $timezone)->add(new DateInterval('P' . ($minDaysBookInAdvance) . 'D'));
	$dateCheckOut = JDate::getInstance('now', $timezone);
endif;

// Try to find the minimum default check in date
$defaultMinCheckInDate = $dateCheckIn;
if (!empty($enabledCheckinDays)) :
	$tempDayInfo = getdate($defaultMinCheckInDate->format('U'));
	while (!in_array($tempDayInfo['wday'], $enabledCheckinDays)) :
		$defaultMinCheckInDate->add(new DateInterval('P1D'));
		$tempDayInfo = getdate($defaultMinCheckInDate->format('U'));
	endwhile;
endif;

// Try to find the minimum default check out date
// Switch to the new default min check in date, for Package
// $defaultMinCheckInDate already contains $minDaysBookInAdvance
$defaultMinCheckOutDate = clone $defaultMinCheckInDate;
if (!is_null($tariff->d_min)) :
	$defaultMinCheckOutDate->add(new DateInterval('P' . ($bookingType == 0 ? $tariff->d_min : ($tariff->d_min > 0 ? $tariff->d_min - 1 : $tariff->d_min)) . 'D'));
else : // For standard tariff
	$defaultMinCheckOutDate->add(new DateInterval('P1D'));
endif;
$defaultMaxCheckOutDateString = '';
if (!is_null($tariff->d_max)) :
	$defaultMaxCheckOutDate = clone $defaultMinCheckInDate;
	$defaultMaxCheckOutDate->add(new DateInterval('P' . ($bookingType == 0 ? $tariff->d_max : $tariff->d_max - 1) . 'D'));
	$defaultMaxCheckOutDateString = $defaultMaxCheckOutDate->format('Y-m-d', true);
endif;

$defaultMinCheckOutDateString = $defaultMinCheckOutDate->format('Y-m-d', true);

JHtml::_('script', SRURI_MEDIA . '/assets/js/datePicker/localization/jquery.ui.datepicker-' . JFactory::getLanguage()->getTag() . '.js', false, false);

$displayData['is_standard_tariff'] = $isStandardTariff;

echo SRLayoutHelper::getInstance()->render(
	'asset.checkinoutform' . ((defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? '_' . SR_LAYOUT_STYLE : '_style1'),
	$displayData
);

/*if ($tariff->type <= 1) :
    echo SRLayoutHelper::getInstance()->render(
        'asset.checkinoutform' . ((defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? '_' . SR_LAYOUT_STYLE : '_style1'),
        $displayData
    );
else :
    echo SRLayoutHelper::getInstance()->render(
        'asset.checkinoutform_date_blocks_2',
        array_merge($displayData, array(
            'defaultMinCheckInDate' => $defaultMinCheckInDate,
            'defaultMinCheckOutDate' => $defaultMinCheckOutDate
        ))
    );
endif;*/

?>

<script>
    Solidres.jQuery(function ($) {
        function changeCheckButtonState() {
            if ($("#sr-reservation-form-room input[name='checkin']").val()
                &&
                $("#sr-reservation-form-room input[name='checkout']").val()) {
                $("#sr-reservation-form-room .searchbtn").prop("disabled", false);
            } else {
                $("#sr-reservation-form-room .searchbtn").prop("disabled", true);
            }
        }

		<?php
		if (!$isStandardTariff) :
			$validFrom                    = array_reverse(explode('-', $tariff->valid_from));
			$validFrom[1]                 -= 1;
			$validTo                      = array_reverse(explode('-', $tariff->valid_to));
			$validTo[1]                   -= 1;
			$datePickerMinDateCheckout    = explode('-', $defaultMinCheckOutDateString);
			$datePickerMinDateCheckout[1] -= 1; // In JS, the month index starts from 0, not 1.
			if (!is_null($tariff->d_max)) :
				$datePickerMaxDateCheckout    = explode('-', $defaultMaxCheckOutDateString);
				$datePickerMaxDateCheckout[1] -= 1; // In JS, the month index starts from 0, not 1.
			endif;

			echo '        
        var minLengthOfStay = ' . (!is_null($tariff->d_min) ? ($bookingType == 0 ? $tariff->d_min : $tariff->d_min - 1) : 1) . ';
        var maxLengthOfStay = ' . (!is_null($tariff->d_max) ? ($bookingType == 0 ? $tariff->d_max : $tariff->d_max - 1) : -1) . ';
        var intervalLengthOfStay = ' . ($tariff->d_interval) . ';
        var bookingType = ' . $bookingType . ';
        if (maxLengthOfStay > 0) {
            var periodMinMax = maxLengthOfStay - minLengthOfStay;
        }					
        
        if (intervalLengthOfStay > 0 && minLengthOfStay > 0 && maxLengthOfStay > 0) {
            if (bookingType == 0) {
                var threshold = Math.floor(maxLengthOfStay / intervalLengthOfStay);
            } else {
                var threshold = Math.floor((maxLengthOfStay + 1) / intervalLengthOfStay);
            }						
            
            var steps = [];
            for (i = 0; i <= threshold; i++) {
                steps.push(i * intervalLengthOfStay);
            }				
        }
        
        var enabledCheckinDays = ' . (!empty($enabledCheckinDays) ? json_encode($enabledCheckinDays, JSON_NUMERIC_CHECK) : '[]') . ';
        var unavailableDates = ' . (!empty($unavailableDates) ? json_encode($unavailableDates) : '[]') . ';
        var checkInDates = ' . (!empty($checkInDates) ? json_encode($checkInDates) : '[]') . ';

        var isValidCheckInDate = function(day) {
            if (enabledCheckinDays.length == 0) {
                return false;
            }

            if ($.inArray(day, enabledCheckinDays) > -1) {
                return true;
            } else {
                return false;
            }
        };
        
        var getUnavailableDates = function(year, month, id) {
            $.ajax({
                url : Solidres.options.get("BaseURI") + "index.php?option=com_solidres&format=json&task=reservation.getUnavailableDates&year=" + year + "&month=" + month + "&id=" + id + "&' . JSession::getFormToken() . '=1",
                success : function(data) {
                    unavailableDates = data[0];
                    checkInDates = data[1];
                    checkin_roomtype.datepicker("refresh");
                    checkout_roomtype.datepicker("refresh");
                }
            });
        }
        
        var checkInMinDate = new Date(' . implode(', ', $validFrom) . ');
        if ( ' . $dayDiff . ' < ' . $minDaysBookInAdvance . ' ) {
            checkInMinDate.setDate(checkInMinDate.getDate() + ' . ($minDaysBookInAdvance - $dayDiff) . ');
        } else {
            checkInMinDate.setDate(checkInMinDate.getDate());
        }
        var checkInMaxDate = new Date(' . implode(', ', $validTo) . ');
        checkInMaxDate.setDate(checkInMaxDate.getDate() - minLengthOfStay);

        var checkout_roomtype = $(".checkout_datepicker_inline").datepicker({
            minDate : new Date(' . implode(', ', $datePickerMinDateCheckout) . '),
            ' . ((!is_null($tariff->d_max)) ? 'maxDate : new Date(' . implode(', ', $datePickerMaxDateCheckout) . '),' : '') . '
            numberOfMonths : ' . $datePickerMonthNum . ',
            showButtonPanel : true,
            dateFormat : "' . $jsDateFormat . '",
            firstDay: ' . $weekStartDay . ',
            onSelect: function() {
                $("#sr-reservation-form-room input[name=\'checkout\']").val($.datepicker.formatDate("yy-mm-dd", $(this).datepicker("getDate")));
                $(".checkout_roomtype").html($.datepicker.formatDate("' . $jsDateFormat . '", $(this).datepicker("getDate")) + "<i class=\"fa fa-calendar\"></i>");
                $(".checkout_datepicker_inline").slideToggle();
                $(".checkin_roomtype").removeClass("disabledCalendar");
                changeCheckButtonState();
            },
            beforeShowDay: function(date) {
                var currentSelectedDate = $(".checkin_datepicker_inline").datepicker("getDate");
                var testDate3 = new Date(' . implode(', ', $validTo) . ');
                var dateFormatted = $.datepicker.formatDate("yy-mm-dd", date);
                if (date > testDate3 
                    || ($.inArray(dateFormatted, unavailableDates) > -1 
                        && $.inArray(dateFormatted, checkInDates) == -1)
                        && dateFormatted != unavailableDates[0]
                    ) {
                    return [false, "notbookable2"];
                }
                
                if (intervalLengthOfStay > 0 && minLengthOfStay > 0 && maxLengthOfStay > 0) {
                    var diffInDays = Math.round((date - currentSelectedDate)/(24*60*60*1000));
                    if (bookingType == 1) {
                        diffInDays += 1;
                    }
                    if (diffInDays >= 0 && $.inArray(diffInDays,steps) > -1) {
                        return [true, "bookable"];
                    } else {
                        return [false, "notbookable"];
                    }
                } else {
                    return [true, "bookable"];
                }							
            }
        });

        var checkin_roomtype = $(".checkin_datepicker_inline").datepicker({
            minDate : checkInMinDate,
            maxDate : checkInMaxDate,
            //' . ($maxDaysBookInAdvance > 0 ? 'maxDate: "+' . ($maxDaysBookInAdvance) . '",' : '') . '
            numberOfMonths : ' . $datePickerMonthNum . ',
            showButtonPanel : true,
            dateFormat : "' . $jsDateFormat . '",
            onSelect : function() {
                var currentSelectedDate = $(this).datepicker("getDate");
                var checkoutMinDate = $(this).datepicker("getDate", "+1d");
                var checkoutMaxDate = $(this).datepicker("getDate", "+1d");
                
                // Set the min selectable checkout date if applicable
                canProcess = true;
                for (i = 1; i <= minLengthOfStay; i ++) {
                    checkoutMinDate.setDate(checkoutMinDate.getDate() + 1);
                    checkoutMinDateFormatted = $.datepicker.formatDate("yy-mm-dd", checkoutMinDate);
                    
                    tmpUnavailableDates = [];
                    for (t = 0, tcount = unavailableDates.length; t < tcount; t++) {
                        tmp1 = new Date(unavailableDates[t]);
                        if (checkoutMinDate <= tmp1) {
                            tmpUnavailableDates = unavailableDates.slice(t);
                            break;
                        }
                    }
                    
                    unavailableDates = tmpUnavailableDates;
                    checkout_roomtype.datepicker("refresh");
                    
                    if ($.inArray(checkoutMinDateFormatted, tmpUnavailableDates) > -1
                        &&
                        checkoutMinDateFormatted != tmpUnavailableDates[0]
                        &&
                        $.inArray(checkoutMinDateFormatted, checkInDates) == -1) {
                        canProcess = false; // No selectable checkout date
                        break;
                    }						
                }
                
                $("#sr-reservation-form-room input[name=\'checkin\']").val($.datepicker.formatDate("yy-mm-dd", currentSelectedDate));
                $(".checkin_roomtype").html($.datepicker.formatDate("' . $jsDateFormat . '", currentSelectedDate) + "<i class=\"fa fa-calendar\"></i>");
                $(".checkin_datepicker_inline").slideToggle({
                    complete: function() {
                        if (!canProcess) {
                            $("#sr-reservation-form-room input[name=\'checkout\']").val("");
                            $(".checkout_roomtype").text($(".checkout_roomtype").data("placeholder"));
                            alert("' . JText::_('SR_CHOOSE_ANOTHER_CHECKIN') . '");
                            $(".checkout_roomtype").addClass("disabledCalendar");
                        }
                    }
                });
                
                if (canProcess) {
                    checkout_roomtype.datepicker( "option", "minDate", checkoutMinDate );
                    checkout_roomtype.datepicker( "setDate", checkoutMinDate);
                    
                    // Set the max selectable checkout date if applicable
                    if (maxLengthOfStay > 0) {
                        for (i = 1; i <= maxLengthOfStay; i ++) {
                            checkoutMaxDate.setDate(checkoutMaxDate.getDate() + 1);	
                            if ($.inArray($.datepicker.formatDate("yy-mm-dd", checkoutMaxDate), unavailableDates) > -1
                                &&
                                $.inArray($.datepicker.formatDate("yy-mm-dd", checkoutMaxDate), checkInDates) == -1) {
                                break;
                            }
                        }
                        var tariffValidTo = new Date(' . implode(', ', $validTo) . ');

                        if (checkoutMaxDate > tariffValidTo) {
                            checkoutMaxDate = tariffValidTo;
                        }
                                                            
                        checkout_roomtype.datepicker( "option", "maxDate", new Date(checkoutMaxDate) );
                    }
                                                    
                    $("#sr-reservation-form-room input[name=\'checkout\']").val($.datepicker.formatDate("yy-mm-dd", checkoutMinDate));
                    $(".checkout_roomtype").html($.datepicker.formatDate("' . $jsDateFormat . '", checkoutMinDate) + "<i class=\"fa fa-calendar\"></i>");
                    $(".checkout_roomtype").removeClass("disabledCalendar");
                }
                
                changeCheckButtonState();
            },
            firstDay: ' . $weekStartDay . ',
            beforeShowDay: function(date) {
                var day = date.getDay();
                var dateFormatted = $.datepicker.formatDate("yy-mm-dd", date);
                
                if (isValidCheckInDate(day) && $.inArray(dateFormatted, unavailableDates) == -1 ) {
                    return [true, "bookable"];
                } else {
                    return [false, "notbookable"];
                }
            }
        });
        ';

		else : // For standard tariff
			echo '
        var minLengthOfStay = ' . $minLengthOfStay . ';
        var checkout_roomtype = $(".checkout_datepicker_inline").datepicker({
            minDate : "+' . ($minDaysBookInAdvance + $minLengthOfStay) . '",
            numberOfMonths : ' . $datePickerMonthNum . ',
            showButtonPanel : true,
            dateFormat : "' . $jsDateFormat . '",
            firstDay: ' . $weekStartDay . ',
            onSelect: function() {
                $("#sr-reservation-form-room input[name=\'checkout\']").val($.datepicker.formatDate("yy-mm-dd", $(this).datepicker("getDate")));
                $(".checkout_roomtype").html($.datepicker.formatDate("' . $jsDateFormat . '", $(this).datepicker("getDate")) + "<i class=\"fa fa-calendar\"></i>");
                $(".checkout_datepicker_inline").slideToggle();
                $(".checkin_roomtype").removeClass("disabledCalendar");
                changeCheckButtonState();
            }
        });
        var checkin_roomtype = $(".checkin_datepicker_inline").datepicker({
            minDate : "+' . ($minDaysBookInAdvance) . 'd",
            ' . ($maxDaysBookInAdvance > 0 ? 'maxDate: "+' . ($maxDaysBookInAdvance) . '",' : '') . '
            numberOfMonths : ' . $datePickerMonthNum . ',
            showButtonPanel : true,
            dateFormat : "' . $jsDateFormat . '",
            onSelect : function() {
                var currentSelectedDate = $(this).datepicker("getDate");
                var checkoutMinDate = $(this).datepicker("getDate", "+1d");
                checkoutMinDate.setDate(checkoutMinDate.getDate() + minLengthOfStay);
                checkout_roomtype.datepicker( "option", "minDate", checkoutMinDate );
                checkout_roomtype.datepicker( "setDate", checkoutMinDate);

                $("#sr-reservation-form-room input[name=\'checkin\']").val($.datepicker.formatDate("yy-mm-dd", currentSelectedDate));
                $("#sr-reservation-form-room input[name=\'checkout\']").val($.datepicker.formatDate("yy-mm-dd", checkoutMinDate));

                $(".checkin_roomtype").html($.datepicker.formatDate("' . $jsDateFormat . '", currentSelectedDate) + "<i class=\"fa fa-calendar\"></i>");
                $(".checkout_roomtype").html($.datepicker.formatDate("' . $jsDateFormat . '", checkoutMinDate) + "<i class=\"fa fa-calendar\"></i>");
                $(".checkin_datepicker_inline").slideToggle();
                $(".checkout_roomtype").removeClass("disabledCalendar");
                changeCheckButtonState();
            },
            firstDay: ' . $weekStartDay . '
        });
        ';
		endif;
		?>
        $(".ui-datepicker").addClass("notranslate");
    });
</script>