<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

/**
 * Reservation controller class.
 *
 * @package     Solidres
 * @subpackage	Reservation
 * @since		0.1.0
 */
class SolidresControllerMyReservation extends JControllerForm
{
	/**
	 * The URL view item variable.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $view_item = 'myreservation';

	/**
	 * The URL view list variable.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $view_list = 'customer';

	/**
	 * The URL edit variable.
	 *
	 * @var    string
	 * @since  3.2
	 */
	protected $urlVar = 'id';

	public function __construct($config = array())
	{
		parent::__construct($config);

		// This context is mainly used in front end reservation processing
		if (JFactory::getApplication()->isSite())
		{
			$this->context = 'com_solidres.reservation.process';
		}
	}

	/**
	 * Method to add a new record.
	 *
	 * @return  mixed  True if the record can be added, a error object if not.
	 *
	 * @since   1.6
	 */
	public function add()
	{
		if (!parent::add())
		{
			// Redirect to the return page.
			$this->setRedirect($this->getReturnPage());
		}
	}

	/**
	 * Method to cancel an edit.
	 *
	 * @param   string  $key  The name of the primary key of the URL variable.
	 *
	 * @return  boolean  True if access level checks pass, false otherwise.
	 *
	 * @since   1.6
	 */
	public function cancel($key = 'id')
	{
		parent::cancel($key);

		// Redirect to the return page.
		$this->setRedirect($this->getReturnPage());
	}

	/**
	 * Get the return URL.
	 *
	 * If a "return" variable has been passed in the request
	 *
	 * @return  string	The return URL.
	 *
	 * @since   1.6
	 */
	protected function getReturnPage()
	{
		$return = $this->input->get('return', null, 'base64');

		if (empty($return) || !JUri::isInternal(base64_decode($return)))
		{
			return JUri::base();
		}
		else
		{
			return base64_decode($return);
		}
	}

	/**
	 * Method to edit an existing record.
	 *
	 * @param   string  $key     The name of the primary key of the URL variable.
	 * @param   string  $urlVar  The name of the URL variable if different from the primary key
	 * (sometimes required to avoid router collisions).
	 *
	 * @return  boolean  True if access level check and checkout passes, false otherwise.
	 *
	 * @since   1.6
	 */
	public function edit($key = null, $urlVar = 'id')
	{
		$result = parent::edit($key, $urlVar);

		return $result;
	}

	public function getModel($name = 'MyReservation', $prefix = 'SolidresModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}

	/**
	 * Gets the URL arguments to append to an item redirect.
	 *
	 * @param   integer  $recordId  The primary key id for the item.
	 * @param   string   $urlVar    The name of the URL variable for the id.
	 *
	 * @return  string	The arguments to append to the redirect URL.
	 *
	 * @since   1.6
	 */
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'a_id')
	{
		// Need to override the parent method completely.
		$tmpl   = $this->input->get('tmpl');
//		$layout = $this->input->get('layout', 'edit');
		$append = '';

		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl='.$tmpl;
		}

		// TODO This is a bandaid, not a long term solution.
//		if ($layout)
//		{
//			$append .= '&layout=' . $layout;
//		}
		$append .= '&layout=edit';

		if ($recordId)
		{
			$append .= '&'.$urlVar.'='.$recordId;
		}

		$itemId	= $this->input->getInt('Itemid');
		$return	= $this->getReturnPage();
		$catId  = $this->input->getInt('catid', null, 'get');

		if ($itemId)
		{
			$append .= '&Itemid='.$itemId;
		}

		if ($catId)
		{
			$append .= '&catid='.$catId;
		}

		if ($return)
		{
			$append .= '&return='.base64_encode($return);
		}

		return $append;
	}

	/**
	 * Method override to check if you can add a new record.
	 *
	 * @param	array $data An array of input data.
	 * @return	boolean
	 * @since	1.6
	 */
	protected function allowAdd($data = array())
	{
		// Initialise variables.
		$user		= JFactory::getUser();
		$categoryId	= JArrayHelper::getValue($data, 'category_id', JRequest::getInt('filter_category_id'), 'int');
		$allow		= null;

		if ($categoryId)
		{
			// If the category has been passed in the data or URL check it.
			$allow	= $user->authorise('core.create', 'com_solidres.category.'.$categoryId);
		}

		if ($allow === null)
		{
			// In the absense of better information, revert to the component permissions.
			return parent::allowAdd($data);
		}
		else
		{
			return $allow;
		}
	}

	/**
	 * Method to check if you can add a new record.
	 *
	 * @param	array $data An array of input data.
	 * @param	string $key The name of the key for the primary key.
	 * @return	boolean
	 * @since	1.6
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
		$user = JFactory::getUser();
		$userId = $user->get('id');
		$tableCustomer = JTable::getInstance('Customer', 'SolidresTable');
		$tableCustomer->load(array('user_id' => $userId));

		// Check general edit permission first.
		if ($user->authorise('core.edit', 'com_solidres.reservationasset.' . $recordId))
		{
			return true;
		}

		// Fallback on edit.own.
		// First test if the permission is available.r
		if ($user->authorise('core.edit.own', 'com_solidres.reservationasset.' . $recordId))
		{
			// Now test the owner is the user.
			$ownerId = (int) isset($data['partner_id']) ? $data['partner_id'] : 0;
			if (empty($ownerId) && $recordId)
			{
				// Need to do a lookup from the model.
				$record = $this->getModel()->getItem($recordId);

				if (empty($record))
				{
					return false;
				}

				$ownerId = $record->partner_id;
			}

			// If the owner matches 'me' then do the test.
			if ($ownerId == $tableCustomer->id)
			{
				return true;
			}
		}

		// Since there is no asset tracking, revert to the component permissions.
		return parent::allowEdit($data, $key);
	}

	public function changeDates()
	{
		$newCheckin = $this->input->get('newcheckin', '');
		$newCheckout = $this->input->get('newcheckout', '');
		$oldCheckin = $this->input->get('oldcheckin', '');
		$oldCheckout = $this->input->get('oldcheckout', '');
		$reservationId = $this->input->get('reservation_id', 0);
		$return = $this->input->getString('return', '');
		$itemId = $this->input->getUInt('itemId', 0);
		JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');


		JModelLegacy::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/models', 'SolidresModel');
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables', 'SolidresTable');
		$modelReservation = JModelLegacy::getInstance('Reservation', 'SolidresModel', array('ignore_request' => true));
		$tableRoom = JTable::getInstance('Room', 'SolidresTable');
		$tableAsset = JTable::getInstance('ReservationAsset', 'SolidresTable');
		$reservationData = $modelReservation->getItem($reservationId);
		$tableAsset->load($reservationData->reservation_asset_id);
		$srRoomType = SRFactory::get('solidres.roomtype.roomtype');
		$currencyId = $reservationData->currency_id;
		$taxId = $tableAsset->tax_id;
		$solidresCurrency = new SRCurrency(0, $currencyId);
		$coupon = NULL;

		// Get imposed taxes
		$imposedTaxTypes = array();
		if (!empty($taxId))
		{
			$taxModel	= JModelLegacy::getInstance('Tax', 'SolidresModel', array('ignore_request' => true));
			$imposedTaxTypes[] = $taxModel->getItem($taxId);
		}

		// Get customer information
		$user = JFactory::getUser();
		$customerGroupId = NULL;  // Non-registered/Public/Non-loggedin customer
		if (SR_PLUGIN_USER_ENABLED)
		{
			$customerTable = JTable::getInstance('Customer', 'SolidresTable');
			//$customerTable->load(array('user_id' => $user->id));
			$customerTable->load($reservationData->customer_id);
			$customerGroupId = $customerTable->customer_group_id;
		}

		$numberOfNights = (int) $srRoomType->calculateDateDiff($newCheckin, $newCheckout);

		$totalNewCostTaxIncl = 0;
		$totalNewCostTaxExcl = 0;
		$newCostPerRoom = array();
		foreach ($reservationData->reserved_room_details as $index => $room)
		{
			// Find the room type id
			$tableRoom->load($room->room_id);
			$roomTypeId = $tableRoom->room_type_id;

			if (SR_PLUGIN_COMPLEXTARIFF_ENABLED)
			{
				$cost  = $srRoomType->getPrice(
					$roomTypeId,
					$customerGroupId,
					$imposedTaxTypes,
					false,
					true,
					$newCheckin,
					$newCheckout,
					$solidresCurrency,
					$coupon,
					$room->adults_number,
					(isset($room->children_number) ? $room->children_number : 0),
					(isset($room->children_ages) ? $room->children_ages : array()),
					$numberOfNights,
					$room->tariff_id
				);
			}
			else
			{
				$cost = $srRoomType->getPrice(
					$roomTypeId,
					$customerGroupId,
					$imposedTaxTypes,
					true,
					false,
					$newCheckin,
					$newCheckout,
					$solidresCurrency,
					$coupon,
					0,
					0,
					array(),
					0,
					$room->tariff_id
				);
			}

			$totalNewCostTaxIncl += $cost['total_price_tax_incl'];
			$totalNewCostTaxExcl += $cost['total_price_tax_excl'];

			// Also update for each room as well
			$newCostPerRoom[$index]['id'] = $room->id;
			$newCostPerRoom[$index]['room_price'] = $cost['total_price_tax_incl'];
			$newCostPerRoom[$index]['room_price_tax_incl'] = $cost['total_price_tax_incl'];
			$newCostPerRoom[$index]['room_price_tax_excl'] = $cost['total_price_tax_excl'];
		}

		$newData = array(
			'id' => $reservationId,
			'checkin' => $newCheckin,
			'checkout' => $newCheckout,
			'total_price' => $totalNewCostTaxIncl,
			'total_price_tax_incl' => $totalNewCostTaxIncl,
			'total_price_tax_excl' => $totalNewCostTaxExcl
		);


		// Store new data per reservation
		JFactory::getApplication()->setUserState($this->context.'.changeDatesNewData', $newData);

		// Store new data per room
		JFactory::getApplication()->setUserState($this->context.'.changeDatesNewDataPerRoom', $newCostPerRoom);

		echo '<table class="table table-bordered">
			<thead>
				<tr>
					<th></th>
					<th>Checkin</th>
					<th>Checkout</th>
					<th>Cost</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
					Old
					</td>
					<td>
					'.$oldCheckin.'
					</td>
					<td>
					'.$oldCheckout.'
					</td>
					<td>
					'.$reservationData->total_price_tax_incl . ' ' . $reservationData->currency_code .'
					</td>
				</tr>
				<tr>
					<td>
					New
					</td>
					<td>
					'.$newCheckin.'
					</td>
					<td>
					'.$newCheckout.'
					</td>
					<td>
					'.$totalNewCostTaxIncl . ' ' . $reservationData->currency_code .'
					</td>
				</tr>
				<tr>
					<td>

					</td>
					<td>

					</td>
					<td>

					</td>
					<td>
						<a href="'.JRoute::_('index.php?option=com_solidres&task=myreservation.applyChangeDates&return='.$return.'&Itemid='.$itemId).'" class="btn" type="button">Apply</a>
					</td>
				</tr>
			</tbody>


		</table>';
		die;
	}

	public function applyChangeDates()
	{
		JModelLegacy::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/models', 'SolidresModel');
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables', 'SolidresTable');
		$tableReservation = JTable::getInstance('Reservation', 'SolidresTable');

		$return = $this->input->getString('return', '');
		$itemId = $this->input->getUint('Itemid', 0);

		// Update new data per reservation
		$newData = JFactory::getApplication()->getUserState($this->context.'.changeDatesNewData');
		$tableReservation->bind($newData);
		$tableReservation->check();
		$tableReservation->store();

		// Update new data per room
		$newDataPerRoom = JFactory::getApplication()->getUserState($this->context.'.changeDatesNewDataPerRoom');
		$dbo = JFactory::getDbo();
		$query = $dbo->getQuery(true);
		if (is_array($newDataPerRoom))
		{
			foreach ($newDataPerRoom as $newRoomData)
			{
				$query->clear();
				$query->update('#__sr_reservation_room_xref')
					->set('room_price = '.$dbo->quote($newRoomData['room_price_tax_incl']))
					->set('room_price_tax_incl = '.$dbo->quote($newRoomData['room_price_tax_incl']))
					->set('room_price_tax_excl = '.$dbo->quote($newRoomData['room_price_tax_excl']))
					->where('id = '.$newRoomData['id']);
				$dbo->setQuery($query)->execute();
			}
		}

		$link = JRoute::_('index.php?option=com_solidres&view=myreservation&layout=edit&id='.$newData['id'].'&Itemid='.$itemId.'&return='.$return, false);
		JFactory::getApplication()->redirect($link);
	}

	public function cancelReservation()
	{
		$reservationId = $this->input->getUInt('id', 0);
		$user = JFactory::getUsers();

		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_solidres/tables');
		$tableReservation = JTable::getInstance('Reservation', 'SolidresTable');
		$tableCustomer = JTable::getInstance('Customer', 'SolidresTable');
		$tableReservation->load($reservationId);
		$tableCustomer->load(array('user_id' => $user->get('id')));
		if ( $tableReservation->customer_id == $tableCustomer->id )
		{
			$tableReservation->state = 4; // Cancelled
			$tableReservation->check();
			$tableReservation->store();
		}

		$this->setRedirect('index.php?option=com_solidres&view=myreservation&layout=edit&id='.$reservationId);
	}
}