<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');
$user      = JFactory::getUser();
$userId    = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn  = $this->state->get('list.direction');
$canCreate = $user->authorise('core.create', 'com_solidres');
$canEdit   = $user->authorise('core.edit', 'com_solidres');
$canChange = $user->authorise('core.edit.state', 'com_solidres');
?>

<div id="solidres">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
		<?php echo SolidresHelperSideNavigation::getSideNavigation($this->getName()); ?>
        <div id="sr_panel_right" class="sr_list_view <?php echo SR_UI_GRID_COL_10 ?>">
            <form action="<?php echo JRoute::_('index.php?option=com_solidres&view=states'); ?>" method="post"
                  name="adminForm" id="adminForm">
				<?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th width="1%" class="nowrap center">
							<?php echo JHtml::_('searchtools.sort', '', 'r.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                        </th>
                        <th width="1%" class="center hidden-phone">
							<?php echo JHtml::_('grid.checkall'); ?>
                        </th>
                        <th class="title" width="40%">
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_STATE_NAME', 'name', $listDirn, $listOrder); ?>
                        </th>
                        <th class="center hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_PUBLISHED', 'state', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_COUNTRY', 'country', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_COUNTRY_CODE_2', 'code_2', $listDirn, $listOrder); ?>
                        </th>
                        <th width="1%" class="nowrap hidden-phone">
							<?php echo JHtml::_('grid.sort', 'SR_COUNTRY_CODE_3', 'code_3', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
					<?php foreach ($this->items as $i => $item) : ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td class="center">
								<?php echo JHtml::_('grid.id', $i, $item->id); ?>
                            </td>
                            <td class="center hidden-phone">
								<?php echo (int) $item->id; ?>
                            </td>
                            <td>
								<?php if ($canCreate || $canEdit) : ?>
                                    <a href="<?php echo JRoute::_('index.php?option=com_solidres&task=state.edit&id=' . (int) $item->id); ?>">
										<?php echo $this->escape($item->name); ?></a>
								<?php else : ?>
									<?php echo $this->escape($item->name); ?>
								<?php endif; ?>
                            </td>
                            <td class="center hidden-phone">
								<?php echo JHtml::_('jgrid.published', $item->state, $i, 'states.', $canChange); ?>
                            </td>
                            <td class="hidden-phone">
								<?php echo $this->escape($item->country); ?>
                            </td>
                            <td class="hidden-phone">
								<?php echo $this->escape($item->code_2); ?>
                            </td>
                            <td class="hidden-phone">
								<?php echo $this->escape($item->code_3); ?>
                            </td>
                        </tr>
					<?php endforeach; ?>
                    </tbody>
                </table>
				<?php echo $this->pagination->getListFooter(); ?>
                <input type="hidden" name="task" value=""/>
                <input type="hidden" name="boxchecked" value="0"/>
				<?php echo JHtml::_('form.token'); ?>
            </form>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
            <p>Powered by <a href="https://www.solidres.com" target="_blank">Solidres</a></p>
        </div>
    </div>
</div>
