<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFactory::getDocument()->addScriptDeclaration('
	Solidres.jQuery(document).ready(function($) {
		$("#item-form").validate({onsubmit: false});
		Solidres.options.load({
			targetId: "' . (int) $this->form->getValue('id') . '",
			uriBase: "' . JUri::base(true) . '/",
			target: "roomtype",
			token: "' . JSession::getFormToken() . '"
		});
	});

	Joomla.submitbutton = function(task)
	{
		if (task != "roomtype.cancel") {
			if (Solidres.jQuery("input[name^=\"jform[rooms]\"]").length == 0) {
				alert("' . JText::_('SR_NO_ROOMS_CREATED') . '");
				return false;
			}
		}

		if (task == "roomtype.cancel" || Solidres.jQuery("#item-form").valid())
		{			
			Solidres.jQuery("#item-form").validate().resetForm();
			Joomla.submitform(task, document.getElementById("item-form"), false);
		} else {
			alert("' . $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')) . '");
		}
	}
');

?>
<div id="solidres">
    <div class="<?php echo SR_UI_GRID_CONTAINER; ?>">
		<?php echo SolidresHelperSideNavigation::getSideNavigation($this->getName()) ?>
        <div id="sr_panel_right" class="sr_form_view <?php echo SR_UI_GRID_COL_10 ?>">
            <div class="sr-inner">
                <form enctype="multipart/form-data"
                      action="<?php JRoute::_('index.php?option=com_solidres&view=roomtypes') ?>"
                      method="post"
                      name="adminForm"
                      id="item-form"
                      class="form-validate form-horizontal">
					<?php echo JHtml::_('bootstrap.startTabSet', 'sr-roomtype', array('active' => 'general')) ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'general', JText::_('SR_NEW_GENERAL_INFO', true)) ?>
					<?php echo $this->loadTemplate('general') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'publishing', JText::_('JGLOBAL_FIELDSET_PUBLISHING', true)) ?>
					<?php echo $this->loadTemplate('publishing') ?>
					<?php echo $this->loadTemplate('params'); ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'tariff', JText::_('SR_ROOM_TYPE_TARIFF', true)) ?>
					<?php echo $this->loadTemplate('tariff') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'room', JText::_('SR_ROOM_TYPE_ROOM', true)) ?>
					<?php echo $this->loadTemplate('room') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'media', JText::_('SR_MEDIA', true)) ?>
					<?php echo $this->loadTemplate('media') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'customfields', JText::_('SR_CUSTOM_FIELDS', true)) ?>
					<?php echo $this->loadTemplate('customfields') ?>
					<?php echo JHtml::_('bootstrap.endTab'); ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'facility', JText::_('SR_FACILITY', true)) ?>
					<?php echo $this->loadTemplate('facility') ?>
					<?php echo JHtml::_('bootstrap.endTab'); ?>

					<?php if (SRPlugin::isEnabled('channelmanager')) : ?>
						<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'channelmanager', JText::_('SR_CHANNEL_MANAGER', true)) ?>
						<?php echo $this->loadTemplate('channelmanager') ?>
						<?php echo JHtml::_('bootstrap.endTab') ?>
					<?php endif; ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'ical', JText::_('SR_ICAL_LABEL', true)) ?>
					<?php if (SRPlugin::isEnabled('ical')): ?>
						<?php foreach ($this->form->getFieldset('ical') as $field): ?>
							<?php echo $field->renderField(); ?>
						<?php endforeach; ?>
					<?php else: ?>
                        <div class="alert alert-info">
                            This feature allows you to export your room type availability as ICal format. It also allow
                            importing external ICal file.
                        </div>
                        <div class="alert alert-success">
                            <strong>Notice:</strong> plugin <strong>Ical</strong> is not installed or enabled.
                            <a target="_blank"
                               href="https://www.solidres.com/subscribe/levels">Become
                                a subscriber and download it now.</a>
                        </div>
					<?php endif; ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-roomtype', 'stream', JText::_('SR_STREAM', true)) ?>
					<?php if (SRPlugin::isEnabled('stream')): ?>
						<?php SolidresStreamHelper::displayByScope('roomtype', $this->form->getValue('id')) ?>
					<?php else: ?>
                        <div class="alert alert-info">
                            This feature allows you listen to all Solidres's events and record them
                        </div>
                        <div class="alert alert-success">
                            <strong>Notice:</strong> plugin <strong>Stream</strong> is not installed or enabled.
                            <a target="_blank"
                               href="https://www.solidres.com/subscribe/levels">Become
                                a subscriber and download it now.</a>
                        </div>
					<?php endif; ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.endTabSet') ?>

                    <input type="hidden" name="task" value=""/>
					<?php echo JHtml::_('form.token') ?>
                </form>
            </div>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
            <p>Powered by <a href="https://www.solidres.com" target="_blank">Solidres</a></p>
        </div>
    </div>
</div>
	
