<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * View to edit a Reservation.
 *
 * @package       Solidres
 * @subpackage    Reservation
 * @since         0.1.0
 */
class SolidresViewReservation extends JViewLegacy
{
	protected $state;
	protected $form;
	protected $invoiceTable;
	protected $reservationAsset;

	public function display($tpl = null)
	{
		$model       = $this->getModel();
		$this->state = $model->getState();
		$this->form  = $model->getForm();
		$lang        = JFactory::getLanguage();
		$lang->load('com_solidres', JPATH_SITE . '/components/com_solidres');
		$solidresConfig               = JComponentHelper::getParams('com_solidres');
		$this->dateFormat             = $solidresConfig->get('date_format', 'd-m-Y');
		$this->customer_id            = $this->form->getValue('customer_id', 0);
		$this->customerIdentification = '';
		$this->defaultAssetId         = 0;
		$this->totalPublishedAssets   = 0;

		$this->createdByUser = null;
		if ($this->form->getValue('created_by', 0))
		{
			$this->createdByUser = JFactory::getUser($this->form->getValue('created_by'));
		}

		$assetModel  = JModelLegacy::getInstance('ReservationAsset', 'SolidresModel');
		$assetsModel = JModelLegacy::getInstance('ReservationAssets', 'SolidresModel', array('ignore_request' => true));
		if ($this->form->getValue('reservation_asset_id', 0) > 0)
		{
			$this->reservationAsset = $assetModel->getItem($this->form->getValue('reservation_asset_id', 0));
		}
		else
		{
			$assetsModel->setState('filter.state', 1);
			$this->totalPublishedAssets = count($assetsModel->getItems());

			if ($this->totalPublishedAssets == 1)
			{
				$this->defaultAssetId = SRUtilities::getDefaultAssetId();
			}
		}

		$this->bookingRequireApproval = 0;
		if (isset($this->reservationAsset->params['booking_require_approval']))
		{
			$this->bookingRequireApproval = $this->reservationAsset->params['booking_require_approval'];
		}

		if ($this->customer_id > 0 && SRPlugin::isEnabled('user'))
		{
			JModelLegacy::addIncludePath(SRPlugin::getAdminPath('user') . '/models', 'SolidresModel');
			$customerModel                = JModelLegacy::getInstance('Customer', 'SolidresModel');
			$customer                     = $customerModel->getItem($this->customer_id);
			$this->customerIdentification = $customer->name . ' ( ' . $customer->id . ' - ' . (empty($customer->customer_group_name) ? JText::_('SR_GENERAL_CUSTOMER_GROUP') : $customer->customer_group_name) . ' )';
		}

		if ($errors = $this->get('Errors'))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		if (!in_array($this->form->getValue('payment_method_id'), array('paylater', 'bankwire')))
		{
			$lang->load('plg_solidrespayment_' . $this->form->getValue('payment_method_id'), JPATH_PLUGINS . '/solidrespayment/' . $this->form->getValue('payment_method_id'), null, 1);
		}

		JFactory::getDocument()->addScriptDeclaration('
			Solidres.child_max_age_limit = ' . $solidresConfig->get('child_max_age_limit', 17) . ';
			Solidres.jQuery(function($) {
				$("a#payment-data-delete-btn").on(\'click\', function(e){
				    if (confirm("' . JText::_('SR_DELETE_RESERVATION_PAYMENT_DATA_CONFIRM') . '") != true) {
				        e.preventDefault();
				    }
				});
			});
		');

		JText::script("SR_RESERVATION_NOTE_NOTIFY_CUSTOMER");
		JText::script("SR_RESERVATION_NOTE_DISPLAY_IN_FRONTEND");
		JText::script('SR_PROCESSING');
		JText::script('SR_NEXT');
		JText::script('SR_CHILD');
		JText::script('SR_CHILD_AGE_SELECTION_JS');
		JText::script('SR_CHILD_AGE_SELECTION_1_JS');
		JText::script('SR_WARN_ONLY_LETTERS_N_SPACES_MSG');
		JText::script('SR_WARN_INVALID_EXPIRATION_MSG');

		$jsOptions = ['version' => SRVersion::getHashVersion(), 'relative' => true];
		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', $jsOptions);

		JLoader::register('SRUtilities', SRPATH_LIBRARY . '/utilities/utilities.php');
		$this->lengthOfStay = (int) SRUtilities::calculateDateDiff($this->form->getValue('checkin'), $this->form->getValue('checkout'));
		if (SRPlugin::isEnabled('invoice'))
		{
			JPluginHelper::importPlugin('solidres');
			$this->invoiceTable = JFactory::getApplication()->triggerEvent('onSolidresLoadReservation', array($this->form->getValue('id')));
		}

		JPluginHelper::importPlugin('solidres');
		JFactory::getApplication()->triggerEvent('onSolidresReservationViewLoad', array(&$this->form));
		SRHtml::_('jquery.popover');
		SRHtml::_('jquery.datepicker');
		$this->addToolbar();

		$model->recordAccess();

		if (!empty($this->reservationAsset->category_id))
		{
			$lang = JFactory::getLanguage();
			$lang->load('com_solidres_category_' . $this->reservationAsset->category_id, JPATH_SITE . '/components/com_solidres');
		}

		JHtml::_('script', 'com_solidres/assets/cardform.min.js', $jsOptions);

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$id         = $this->form->getValue('id');
		$isNew      = ($id == 0);
		$isApproved = $this->form->getValue('is_approved');
		$checkInOut = $this->form->getValue('checkinout_status', '');
		$today      = new DateTime();
		$checkout   = new DateTime($this->form->getValue('checkout'));

		$approveLabel = '';
		if ($this->bookingRequireApproval)
		{
			$approveLabel = $isApproved ? JText::_('SR_RESERVATION_APPROVED') : JText::_('SR_RESERVATION_NOT_APPROVED');
		}

		JToolBarHelper::title($isNew ? JText::_('SR_ADD_NEW_RESERVATION') : JText::_('SR_EDIT_RESERVATION') . ' ' . $this->form->getValue('code') . ' ' . $approveLabel, 'generic.png');
		JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
		JLoader::register('SRToolBarHelper', JPATH_COMPONENT . '/helpers/toolbar.php');

		if ($this->_layout != 'edit2')
		{
			SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.amend&id=' . $id), 'JTOOLBAR_AMEND', 'icon-edit');

			if ($checkInOut == '' && $checkout >= $today)
			{
				SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.doCheckInOut&id=' . $id), 'SR_CHECKIN', 'fa fa-key');
			}

			if ($checkInOut == 1 && $checkout >= $today)
			{
				SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.doCheckInOut&id=' . $id), 'SR_CHECKOUT', 'fa fa-sign-out');
			}

			if ($checkInOut != '' && $checkInOut == 0 && $checkout >= $today)
			{
				SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.doCheckInOut&id=' . $id . '&reset=1'), 'SR_RESET_CHECKINOUT', 'fa fa-recycle');
			}

			if ($this->bookingRequireApproval)
			{
				if (!$isApproved)
				{
					SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.approve&id=' . $id), 'JTOOLBAR_APPROVE', 'icon-publish');
				}
			}

			if ($id && SRPLugin::isEnabled('feedback'))
			{
				JLoader::register('SolidresFeedBackHelper', SRPlugin::getAdminPath('feedback') . '/helpers/feedback.php');

				if (!SolidresFeedBackHelper::hasFeedback(0, $id))
				{
					SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=feedback.sendRequestFeedback&scope=0&reservationId=' . $id . '&' . JSession::getFormToken() . '=1', false), 'SR_SEND_REQUEST_FEEDBACK', 'fa fa-comments');
				}
			}
		}

		if ($this->_layout != 'edit' && !empty($id))
		{
			SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.edit&id=' . $id), 'JTOOLBAR_VIEW', 'icon-eye');
		}

		if (empty($id))
		{
			JToolBarHelper::cancel('reservationbase.cancel', 'JToolbar_Cancel');
		}
		else
		{
			if ($this->_layout != 'edit2')
			{
				JToolBarHelper::cancel('reservationbase.cancel', 'JToolbar_Close');
			}

			SRToolBarHelper::customLink(JRoute::_('index.php?option=com_solidres&task=reservationbase.downloadVoucher&id=' . $id . '&' . JSession::getFormToken() . '=1', false), 'SR_VOUCHER', 'icon-download');

			if (SRPlugin::isEnabled('invoice') && JFactory::getUser()->authorise('core.admin', 'com_solidres'))
			{
				$fileData = SRPlugin::getAdminPath('invoice') . '/views/registrationcard/data.json';

				if (is_file($fileData))
				{
					$printLink = JRoute::_('index.php?option=com_solidres&view=registrationcard&layout=print&tmpl=component&reservationId=' . $id, false);
					$bar       = JToolbar::getInstance();
					$bar->appendButton('Custom', '<a href="' . $printLink . '" onclick="window.open(this.href,\'win2\',\'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no\'); return false;" class="btn btn-small"><i class="icon-print"></i> ' . JText::_('SR_INVOICE_PRINT_REGISTRATION_CARD') . '</a>');
				}
			}
		}
	}
}
