<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');
$dateFormat      = 'Y-m-d H:i:s';
$document        = JFactory::getDocument();
$selectedPayment = $displayData['form']->getValue('payment_method_id', null, '');

if ($document->getType() == 'html')
{
	JText::script('SR_PAYMENT_HISTORY_DELETE_CONFIRM');
	JText::script('SR_PAYMENT_HISTORY_REFUND_CONFIRM');
	JHtml::_('behavior.formvalidator');
	$date    = JHtml::_('date', 'now', $dateFormat);
	$token   = JSession::getFormToken() . '=1';
	$baseUrl = JUri::base(true);
	$js      = <<<JS
Solidres.jQuery(document).ready(function($){
    var 
        form = $('#paymentHistoryForm'),
        showForm = function(){
            $('#sr-add').addClass('hide').siblings().removeClass('hide');
            form.removeClass('hide');
            $('.sr-payment-history-wrap .sr-payment-history-remove').addClass('disabled', true);
            $('html, body').animate({
                scrollTop: $('.sr-payment-history-wrap .well').offset().top - 80
            }, 400);
        },
        hideForm = function(){
            $('#sr-add').removeClass('hide').siblings().addClass('hide');
            form.addClass('hide');
            $('.sr-payment-history-wrap .sr-payment-history-remove').removeClass('disabled', false);
            $('html, body').animate({
                scrollTop: $('.sr-payment-history-wrap table').offset().top - 80
            }, 400);
        },
        resetForm = function(){
            form.find('#paymentHistoryForm_id').val('');
            form.find('#paymentHistoryForm_payment_method_id').val('{$selectedPayment}');
            form.find('#paymentHistoryForm_payment_status').find('>option:eq(0)').prop('selected', true);
            form.find('#paymentHistoryForm_payment_amount').val('');
            form.find('#paymentHistoryForm_payment_method_surcharge').val('');
            form.find('#paymentHistoryForm_payment_method_discount').val('');
            form.find('#paymentHistoryForm_title').val('');
            form.find('#paymentHistoryForm_payment_method_txn_id').val('');
        };
    
    $('.sr-payment-history-wrap').on('click', '.sr-payment-history-edit', function(e) {
        e.preventDefault();
        $(this).parents('tr').find('[data-target]').each(function(){
            $($(this).data('target')).val($(this).data('value'));
        });
        
        showForm();
    });
    
    var responseCallback = function (response) {
        if (typeof response.data.reservationData === 'object') {
                            
            if (response.data.reservationData.totalPaidFormatted !== 'undefined') {
                $('#total_paid')
                    .attr('data-value', response.data.reservationData.total_paid)
                    .text(response.data.reservationData.totalPaidFormatted);                                
                $('#total_due').text(response.data.reservationData.totalDueFormatted);
            }
                            
            if(response.data.reservationData.total_paid !== 'undefined') {
                var totalPaid = parseFloat(response.data.reservationData.total_paid);
                                
                if (!isNaN(totalPaid)) {
                    $('#jform_total_paid').val(totalPaid);
                }
            }
        }  
    };
    
    $('.sr-payment-history-wrap').on('click', '.sr-payment-history-remove', function(e) {
        e.preventDefault();
        
        if ($(this).hasClass('disabled') || !confirm(Joomla.JText._('SR_PAYMENT_HISTORY_DELETE_CONFIRM', 'Do you want to delete this payment history?'))) {
            return false;
        }
        
        var 
            icon = $(this).find('.fa'),    
            row = $(this).parents('tr'), 
            id = row.find('[data-target="#paymentHistoryForm_id"]').data('value');        
        icon.attr('class', 'fa fa-spin fa-spinner');
        $.ajax({
            url: '{$baseUrl}/index.php?option=com_solidres&task=paymenthistory.remove&{$token}',
            type: 'post',
            dataType: 'json',
            data: {
                id: id
            },
            success: function(response) {
                icon.attr('class', 'fa fa-save');
                if (response.success) {
                   row.remove();
                   responseCallback(response);
                } else {
                    alert(response.message);
                }
            }
        });
    });
    
    $('#sr-add').on('click',function(e){
        e.preventDefault();  
        resetForm();
        showForm();
    });
    
    $('#sr-close').on('click', function(e){
        e.preventDefault(); 
        resetForm();
        hideForm();
    });    
    
    $('#sr-save').on('click', function(e){
        e.preventDefault();       
        var icon = $(this).find('.fa');
        if (document.formvalidator.isValid(form[0])) {
            icon.attr('class', 'fa fa-spin fa-spinner');
            $.ajax({
                url: '{$baseUrl}/index.php?option=com_solidres&task=paymenthistory.save&{$token}',
                type: 'post',
                dataType: 'json',
                data: form.find('input, textarea, select').serialize(),
                success: function(response) {
                    icon.attr('class', 'fa fa-save');                    
                    if (response.success) {
                        $('.sr-payment-history-wrap tbody').html($(response.data.displayPaymentHistoryHTML).find('tbody').html());
                        responseCallback(response);
                        hideForm();
                    } else {
                        $(response.message).modal('show');
                    }
                }
            });
        }
    });
    
    $('.sr-payment-history-wrap').on('click', '.sr-payment-history-refund', function(e) {
        e.preventDefault();
        var a = $(this);
        if (a.hasClass('disabled') 
            || !$.trim(a.data('refundUrl')).length
            || !$.trim(a.data('transactionId')).length
            || !confirm(Joomla.JText._('SR_PAYMENT_HISTORY_REFUND_CONFIRM', 'Are you sure want to refund for this reservation?'))
        ) {
            return false;
        }
        
        Joomla.loadingLayer('show');
        $.ajax({
            url: a.data('refundUrl') + '&{$token}',
            type: 'post',
            dataType: 'json',
            data: a.data(),
            success: function(response) {
                Joomla.loadingLayer('hide');
                alert(response.message);
                
                if (response.success) {
                    location.reload();
                }
            }
        });
    });
    
});
JS;

	$document->addScriptDeclaration($js);
}

$app         = JFactory::getApplication();
$prefixEvent = $displayData['scope'] ? 'onExperiencePayment' : 'onSolidresPayment';
$suffixEvent = 'HistoryPrepare';
?>

<div class="sr-payment-history-wrap" style="overflow: auto">
    <table class="table table-striped">
        <thead>
        <tr>
            <th>
				<?php echo JText::_('SR_PAYMENT_HISTORY_DESCRIPTION'); ?>
            </th>
            <th class="nowrap">
				<?php echo JText::_('SR_PAYMENT_DATE'); ?>
            </th>
            <th class="center nowrap">
				<?php echo JText::_('SR_PAYMENT_METHOD'); ?>
            </th>
            <th width="1%" class="center nowrap">
				<?php echo JText::_('SR_PAYMENT_STATUS'); ?>
            </th>
            <th width="10%" class="center nowrap">
				<?php echo JText::_('SR_PAYMENT_AMOUNT'); ?>
            </th>
            <th width="10%" class="center nowrap">
				<?php echo JText::_('SR_PAYMENT_METHOD_SURCHARGE'); ?>
            </th>
            <th width="10%" class="center nowrap">
				<?php echo JText::_('SR_PAYMENT_METHOD_DISCOUNT'); ?>
            </th>
            <th class="center">
				<?php echo JText::_('SR_RESERVATION_PAYMENT_TRANSACTION_ID'); ?>
            </th>
            <th width="1%" class="center nowrap">
				<?php echo JText::_('SR_ACTION'); ?>
            </th>
        </tr>
        </thead>
        <tbody>
		<?php if ($displayData['paymentItems']): ?>
			<?php foreach ($displayData['paymentItems'] as $i => $payment):
				$app->triggerEvent($prefixEvent . ucfirst($payment->payment_method_id) . $suffixEvent, [$payment]);
				$currency = new SRCurrency(0, $payment->currency_id);

				?>
                <tr>
                    <input type="hidden" data-target="#paymentHistoryForm_id" data-value="<?php echo $payment->id; ?>"/>
                    <input type="hidden" data-target="#paymentHistoryForm_scope"
                           data-value="<?php echo $payment->scope; ?>"/>
                    <input type="hidden" data-target="#paymentHistoryForm_currency_id"
                           data-value="<?php echo $payment->currency_id; ?>"/>
                    <td class="nowrap" data-target="#paymentHistoryForm_title"
                        data-value="<?php echo htmlspecialchars($payment->title); ?>">
						<?php echo $payment->title ?: 'N/A'; ?>
                    </td>
                    <td class="nowrap" data-target="#paymentHistoryForm_payment_date"
                        data-value="<?php echo JHtml::_('date', $payment->payment_date, 'Y-m-d H:i:s'); ?>">
						<?php echo JHtml::_('date', $payment->payment_date, $dateFormat); ?>
                    </td>
                    <td class="center nowrap" data-target="#paymentHistoryForm_payment_method_id"
                        data-value="<?php echo $payment->payment_method_id; ?>">
						<?php echo @$displayData['payments'][$payment->payment_method_id]; ?>
                    </td>
                    <td class="center nowrap" data-target="#paymentHistoryForm_payment_status"
                        data-value="<?php echo $payment->payment_status; ?>">
                        <div style="color: #fff; width: 100%; min-width: 80px; padding: 2px 5px; box-sizing: border-box; border-radius: 4px; background: <?php echo $payment->payment_status_color; ?>">
							<?php echo $payment->payment_status_label; ?>
                        </div>
                    </td>
                    <td class="center nowrap" data-target="#paymentHistoryForm_payment_amount"
                        data-value="<?php echo $payment->payment_amount; ?>">
						<?php
						$currency->setValue($payment->payment_amount);
						echo $currency->format();
						?>
                    </td>
                    <td class="center nowrap" data-target="#paymentHistoryForm_payment_method_surcharge"
                        data-value="<?php echo $payment->payment_method_surcharge; ?>">
						<?php
						$currency->setValue($payment->payment_method_surcharge);
						echo $currency->format();
						?>
                    </td>

                    <td class="center nowrap" data-target="#paymentHistoryForm_payment_method_discount"
                        data-value="<?php echo $payment->payment_method_discount; ?>">
						<?php
						$currency->setValue($payment->payment_method_discount);
						echo $currency->format();
						?>
                    </td>

                    <td class="center nowrap" data-target="#paymentHistoryForm_payment_method_txn_id"
                        data-value="<?php echo $payment->payment_method_txn_id; ?>">
						<?php echo $payment->payment_method_txn_id; ?>
                    </td>

                    <td class="center nowrap">
                        <div class="btn-group">
                            <a href="javascript:" class="btn btn-success btn-small sr-payment-history-edit">
                                <i class="fa fa-edit"></i>
								<?php echo JText::_('SR_EDIT'); ?>
                            </a>
                            <a href="javascript:" class="btn btn-danger btn-small sr-payment-history-remove">
                                <i class="fa fa-times"></i>
								<?php echo JText::_('SR_REMOVE'); ?>
                            </a>
                            <a href="javascript:"
                               class="btn btn-warning btn-small sr-payment-history-refund<?php echo empty($payment->refundUrl) ? ' disabled' : ''; ?>"
                               data-payment-history-id="<?php echo $payment->id; ?>"
                               data-transaction-id="<?php echo $payment->payment_method_txn_id; ?>"
                               data-reservation-id="<?php echo $payment->reservation_id; ?>"
                               data-amount="<?php echo $payment->payment_amount; ?>"
                               data-refund-url="<?php echo empty($payment->refundUrl) ? '' : htmlspecialchars($payment->refundUrl); ?>">
                                <i class="fa fa-reply"></i>
								<?php echo JText::_('SR_REFUND'); ?>
                            </a>
                        </div>
                    </td>
                </tr>
			<?php endforeach; ?>
		<?php endif; ?>
        </tbody>
    </table>
    <div class="well">
        <a href="#" id="sr-add" class="btn btn-success btn-small">
            <i class="fa fa-plus"></i>
			<?php echo JText::_('JTOOLBAR_NEW'); ?>
        </a>
        <a href="#" id="sr-close" class="btn btn-danger btn-small hide">
            <i class="fa fa-times"></i>
			<?php echo JText::_('JTOOLBAR_CLOSE'); ?>
        </a>
        <a href="#" id="sr-save" class="btn btn-primary btn-small hide">
            <i class="fa fa-save"></i>
			<?php echo JText::_('JTOOLBAR_APPLY'); ?>
        </a>
    </div>
    <div id="paymentHistoryForm" class="form-horizontal hide">
		<?php echo $displayData['form']->renderFieldset('general') ?>
    </div>
</div>
