<?php
/**
------------------------------------------------------------------------
SOLIDRES - Accommodation booking extension for Joomla
------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory as CMSFactory;

class SolidresControllerOrigin extends FormController
{
	protected $view_list = 'origins';
	protected $view_item = 'origin';

	public function setDefault()
	{
		$this->checkToken('get');
		$user = CMSFactory::getUser();
		$app  = CMSFactory::getApplication();

		if (!$user->authorise('core.edit', 'com_solidres'))
		{
			throw new JAccessExceptionNotallowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		$table = parent::getModel('Origin', 'SolidresModel')->getTable('Origin', 'SolidresTable');
		$pk    = (int) $app->input->get('id', 0, 'uint');

		if ($pk > 0 && $table->load($pk))
		{
			$table->set('is_default', 1);

			if ($table->store())
			{
				$app->enqueueMessage(Text::sprintf('SR_ORIGIN_IS_DEFAULT_MSG', $table->name));
			}
		}

		$app->redirect(Route::_('index.php?option=com_solidres&view=origins', false));
	}
}