<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * Main controller for Solidres
 *
 * @package     Solidres
 * @since       0.1.0
 */
use Joomla\CMS\Component\ComponentHelper;

class SolidresController extends SRControllerLegacy
{
	/**
	 * @var        string    The default view.
	 */
	protected $default_view = 'reservationassets';

	/**
	 * Checks whether a user can see this view.
	 *
	 * @param    string $view The view name.
	 *
	 * @return    boolean
	 */
	protected function canView($view)
	{
		$canDo = SolidresHelper::getActions();

		switch ($view)
		{
			// Special permissions.
			case 'groups':
			case 'group':
			case 'levels':
			case 'level':
				return $canDo->get('core.admin');
				break;

			// Default permissions.
			default:
				return true;
		}
	}

	/**
	 * Method to display a view.
	 *
	 * @param    boolean $cachable  If true, the view output will be cached
	 * @param    boolean $urlparams An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return    JController        This object to support chaining.
	 */
	public function display($cachable = false, $urlparams = false)
	{
		$input   = JFactory::getApplication()->input;
		$params  = ComponentHelper::getParams('com_solidres');
		$expOnly = SRPlugin::isEnabled('experience') && $params->get('main_activity', '') == '1';

		if ($defaultView = trim($params->get('default_view', '')))
		{
			$this->default_view = $defaultView;
		}
		elseif ($expOnly)
		{
			$this->default_view = 'expdashboard';
		}
		elseif (SRPlugin::isEnabled('statistics'))
		{
			$this->default_view = 'statistics';
		}

		$view = $input->get('view', $this->default_view, 'word');

		if (!$this->canView($view))
		{
			throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', array('version' => SRVersion::getHashVersion(), 'relative' => true));

		return parent::display();
	}
}
