<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2017 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonOffice_location extends SppagebuilderAddons {

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
		$heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : '';
		$icon_name = (isset($this->addon->settings->icon_name) && $this->addon->settings->icon_name) ? $this->addon->settings->icon_name : '';
		$text = (isset($this->addon->settings->text) && $this->addon->settings->text) ? $this->addon->settings->text : '';

		$output = '';
		$output .= '<div class="sppb-addon-office-location-wrapper ' . $class . '">';
		$output .= '<'.$heading_selector.' class="sppb-addon-title" >' . $title . '</'.$heading_selector.'>';
		$output .= '<div class="sppb-row">';

		foreach ($this->addon->settings->sp_office_location_item as $key => $item) {
			$output .= '<div class="sppb-addon-content sppb-col-xs-12 sppb-col-sm-6 sppb-col-md-6">';
			$output .= '<div class="sppb-icon">';
			$output .= '<span>';
			$output .= '<i class="fa ' . $item->icon_name . '"></i>';
			$output .= '</span>';
			$output .= '</div>';
			$output .= '<div class="sppb-addon-text">';
			$output .= $item->text;
			$output .= '</div>';

			$output .='</div>';
		}
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public static function getTemplate() {
		$output = '
		<div class="sppb-addon-office-location-wrapper {{data.class}}">
		<{{data.heading_selector}} class="sppb-addon-title" >{{{data.title}}}</{{data.heading_selector}}>
		<div class="sppb-row">

		<# _.each (data.sp_office_location_item, function(item) { #>
			<div class="sppb-addon-content sppb-col-xs-12 sppb-col-sm-6 sppb-col-md-6">
			<div class="sppb-icon">
			<span>
			<i class="fa {{item.icon_name}}"></i>
			</span>
			</div>
			<div class="sppb-addon-text">
			{{{item.text}}}
			</div>
			</div>
		<# }) #>
		</div>
		</div>
		';

		return $output;
	}
}