<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonGallery extends SppagebuilderAddons{

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
		$heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';

		//Options
		$width = (isset($this->addon->settings->width) && $this->addon->settings->width) ? $this->addon->settings->width : 200;
		$height = (isset($this->addon->settings->height) && $this->addon->settings->height) ? $this->addon->settings->height : 200;

		$output  = '<div class="sppb-addon sppb-addon-gallery ' . $class . '">';
		$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>' : '';
		$output .= '<div class="sppb-addon-content">';
		$output .= '<div class="sppb-gallery sppb-row clearfix">';

		if(isset($this->addon->settings->sp_gallery_item) && count((array) $this->addon->settings->sp_gallery_item)){
			foreach ($this->addon->settings->sp_gallery_item as $key => $value) {
				if($value->thumb) {
					$output .= '<div class="sppb-col-sm-' . $value->column_size . ' gallery-image">';
					if($value->full) {
						$output .= '<a href="' . $value->full . '" class="sppb-gallery-btn">';
						$output .='<span class="link-icon">';
						$output .='<i class="fa fa-search-plus"></i>';
						$output .='</span>';
					}
					$output .= '<div class="gallery-image-box">';
						$output .= '<img class="sppb-img-responsive" src="' . $value->thumb . '" alt="' . $value->title . '">';
						$output .='<div class="gallery-text-wrapper">';
							$output .='<div class="gallery-text">';
							$output .= '<h4 class="sppb-gallery-image-title">'. $value->title . ' </h4>';
							$output .='</div>'; //end .gallery-text
						$output .='</div>'; //end .gallery-text-wrapper
					$output .='</div>'; //end .gallery-image-box
					if($value->full) {
						$output .= '</a>';
					}
					$output .= '</div>'; // .sppb-col-sm
					
				}
			}
		}

		$output .= '</div>';
		$output	.= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function stylesheets() {
		return array(JURI::base(true) . '/components/com_sppagebuilder/assets/css/magnific-popup.css');
	}

	public function scripts() {
		return array(JURI::base(true) . '/components/com_sppagebuilder/assets/js/jquery.magnific-popup.min.js');
	}

	public function js() {
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$js ='jQuery(function($){
			$("'.$addon_id.' .gallery-image").magnificPopup({
				delegate: "a",
				type: "image",
				mainClass: "mfp-no-margins mfp-with-zoom",
				gallery:{
					enabled:true
				},
				image: {
					verticalFit: true
				},
				zoom: {
					enabled: true,
					duration: 300
				}
			});
		})';

		return $js;
	}

	public static function getTemplate() {
		$output = '
		<div class="sppb-addon sppb-addon-gallery {{ data.class }}">
			<# if( !_.isEmpty( data.title ) ){ #><{{ data.heading_selector }} class="sppb-addon-title">{{ data.title }}</{{ data.heading_selector }}><# } #>
			<div class="sppb-addon-content">
				<ul class="sppb-gallery sppb-row clearfix">
				<# _.each(data.sp_gallery_item, function (value, key) { #>
					<div class="sppb-col-sm-{{value.column_size}} gallery-image">
					<# if(value.full) { #>
						<a href="{{value.full}}" class="sppb-gallery-btn">
						<span class="link-icon">
						<i class="fa fa-search-plus"></i>
						</span>
					<# } #>
					<div class="gallery-image-box">
						<img class="sppb-img-responsive" src="{{value.thumb}}" alt="{{value.title}}">
						<div class="gallery-text-wrapper">
							<div class="gallery-text">
							<h4 class="sppb-gallery-image-title">{{value.title}}</h4>
							</div>
						</div>
					</div>
					<# if(value.full) { #>
						</a>
					<# } #>
					</div>

				<# }); #>
				</ul>
			</div>
		</div>
		';

		return $output;
	}

}
