<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2018 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die;

extract($displayData);

if ( ! isset( $asset->params['enable_coupon'] ) ) :
	$asset->params['enable_coupon'] = 0;
endif;

if ( $asset->params['enable_coupon'] == 1 ) :
	if ( ! $isFresh ) :
		?>
        <div class="coupon">
            <div class="row">
            <div class="input-append">
                <div class="col-sm-10">
					<input type="text" name="coupon_code" class="input-block-level" id="coupon_code" placeholder="<?php echo JText::_('SR_COUPON_ENTER') ?>"/>
				</div>
                <div class="col-sm-2">
					<button id="coupon_code_check" class="btn btn-primary coupon-submit" type="button">Check</button>
				</div>
            </div>
            </div>
			<?php if ( isset( $coupon ) ) : ?>
                <span>
			<?php echo JText::_( 'SR_APPLIED_COUPON' ) ?>
                    <span class="label label-success">
			<?php echo $coupon['coupon_name'] ?>
			</span>&nbsp;
			<a id="sr-remove-coupon" href="javascript:void(0)" data-couponid="<?php echo $coupon['coupon_id'] ?>">
				<?php echo JText::_( 'SR_REMOVE' ) ?>
			</a>
		</span>
			<?php endif ?>
        </div>
        <script>
            Solidres.jQuery(function ($) {
                $('#coupon_code_check').click(function () {
                    var self = $('input#coupon_code');
                    var coupon_code = self.val();
                    if (coupon_code) {
                        $.ajax({
                            type: 'POST',
                            url: window.location.pathname,
                            data: 'option=com_solidres&format=json&task=coupon.isValid&coupon_code=' + coupon_code + '&raid=' + $('input[name="id"]').val(),
                            success: function (response) {
                                self.parent().next('span').remove();
                                self.parent().after(response.message);
                                if (!response.status) {
                                    $('#apply-coupon').attr('disabled', 'disabled');
                                } else {
                                    $('#apply-coupon').removeAttr('disabled');
                                }
                            },
                            dataType: 'JSON'
                        });
                    }
                });
            });
        </script>
	<?php
	endif;
endif;
?>