<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Toolbar\Toolbar;

if (!class_exists('SRToolbarHelper'))
{
	class SRToolbarHelper extends ToolbarHelper
	{
		public static function mediaManager($url = 'index.php?option=com_solidres&view=medialist&tmpl=component', $text = 'SR_MEDIA_MANAGER', $class = 'btn btn-default btn-sm btn-small')
		{
			$bar  = Toolbar::getInstance('toolbar');
			$html = '<a class="' . $class . '" rel="bsModal" href="' . JRoute::_($url, false) . '">';
			$html .= '<i class="fa fa-file-image-o"></i> ';
			$html .= JText::_($text);
			$html .= '</a>';
			$bar->appendButton('Custom', $html);

			JFactory::getDocument()->addScriptDeclaration('Solidres.jQuery(document).ready(function($){
			$("a[rel=\'bsModal\']").on("click", function(e){
				e.preventDefault();
				if(!$("#sr-media-modal").length){
					var modal = "<div id=\'sr-media-modal\' class=\'modal hide fade\'><div class=\'modal-header\'>"
							+ "<button type=\'button\' class=\'close\' data-dismiss=\'modal\' aria-hidden=\'true\'>&times;</button>"
							+ "<h3>' . JText::_('SR_MEDIA_MANAGER', true) . '</h3></div><div class=\'modal-body\'>"							
							+ "<iframe src=\'" + $(this).attr("href") + "\'></iframe></div></div>";
					$("body").append(modal);
				}				
				$("#sr-media-modal").modal("show");
			});				
		});');
		}

		public static function customLink($url, $text, $class)
		{
			$bar  = Toolbar::getInstance('toolbar');
			$html = '<a class="btn btn-default btn-sm btn-small" href="' . JRoute::_($url) . '">';
			$html .= '<i class="' . $class . '"></i> ';
			$html .= JText::_($text);
			$html .= '</a>';
			$bar->appendButton('Custom', $html);
		}
	}
}
