<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/com_solidres/reservationasset/default_roomtype.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

echo SRLayoutHelper::render('asset.coupon_form', array(
	'asset'   => $this->item,
	'coupon'  => $this->coupon,
	'isFresh' => $this->isFresh
));

?>

<a name="form"></a>

<?php if (!empty($this->item->email) || !empty($this->item->params['show_inquiry_form'])): ?>
	<?php echo $this->loadTemplate('inquiry_form'); ?>
<?php endif; ?>
<?php if (isset($this->item->params['show_inline_checkavailability_form'])
	&& $this->item->params['show_inline_checkavailability_form'] == 1
	&& !$this->disableOnlineBooking
) : ?>
    <div id="asset-checkavailability-form">
        <div class="inner">
			<?php echo $this->loadTemplate('checkavailability'); ?>
        </div>
    </div>
<?php endif ?>

<?php if (!$this->disableOnlineBooking) : ?>
    <div class="wizard wizard-default">
        <ul class="steps list-inline">
            <li data-target="#step1"
                class="list-inline-item active reservation-tab reservation-tab-room <?php echo SR_UI_GRID_COL_4 ?>">
                <span class="badge badge-info">1</span><?php echo JText::_('SR_STEP_ROOM_AND_RATE') ?><span
                        class="chevron"></span></li>
            <li data-target="#step2"
                class="list-inline-item reservation-tab reservation-tab-guestinfo <?php echo SR_UI_GRID_COL_4 ?>"><span
                        class="badge">2</span><?php echo JText::_('SR_STEP_GUEST_INFO_AND_PAYMENT') ?><span
                        class="chevron"></span></li>
            <li data-target="#step3"
                class="list-inline-item reservation-tab reservation-tab-confirmation <?php echo 'bs4' == SR_UI ? '' : SR_UI_GRID_COL_4 ?>">
                <span class="badge">3</span>
				<?php echo JText::_('SR_STEP_CONFIRMATION') ?><!--<span class="chevron"></span>--></li>
        </ul>
    </div>
<?php endif ?>

<div class="step-content">
    <div class="step-pane active" id="step1">
        <!-- Tab 1 -->
        <div class="reservation-single-step-holder room room-default">
			<?php echo $this->loadTemplate('searchinfo'); ?>
            <form enctype="multipart/form-data"
                  id="sr-reservation-form-room"
                  class="sr-reservation-form"
                  action="<?php echo JUri::base() ?>index.php?option=com_solidres&task=reservation.process&step=room&format=json"
                  method="POST">
				<?php if (count($this->item->roomTypes) > 0) : ?>
					<?php if (!$this->isFresh) : ?>
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-top">
                            <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                                <div class="inner">
                                    <p><?php echo JText::_('SR_ROOMINFO_STEP_NOTICE_MESSAGE') ?></p>
                                </div>
                            </div>
                            <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                                <div class="inner">
                                    <div class="btn-group">
                                        <button data-step="room" type="submit" class="btn btn-success">
                                            <i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
					<?php endif ?>

					<?php
					$count = 1;
					foreach ($this->item->roomTypes as $roomType) :
						if (isset($roomType->defaultTariffBreakDown)) :
							$defaultTariffBreakDownHtml = '<table class=\"tariff-break-down\">';
							foreach ($roomType->defaultTariffBreakDown as $key => $breakDownDetails) :
								if ($key % 7 == 0 && $key == 0) :
									$defaultTariffBreakDownHtml .= '<tr>';
                                elseif ($key % 7 == 0) :
									$defaultTariffBreakDownHtml .= '</tr><tr>';
								endif;
								$tmpKey                     = key($breakDownDetails);
								$defaultTariffBreakDownHtml .= '<td><p>' . $this->dayMapping[$tmpKey] . '</p><span class=\"' . $this->tariffNetOrGross . '\">' . $breakDownDetails[$tmpKey][$this->tariffNetOrGross]->format() . '</span>';
							endforeach;
							$defaultTariffBreakDownHtml .= '</tr></table>';

							$this->document->addScriptDeclaration('
					Solidres.jQuery(function($){
						$(".default_tariff_break_down_' . $roomType->id . '").popover({
							html: true,
							content: "' . $defaultTariffBreakDownHtml . '",
							title: "' . JText::_('SR_TARIFF_BREAK_DOWN') . '",
							placement: "bottom",
							trigger: "click"
						});
					});
				');
						endif;

						if (isset($roomType->complexTariffBreakDown)) :
							$complexTariffBreakDownHtml = '<table class=\"tariff-break-down\">';
							foreach ($roomType->complexTariffBreakDown as $key => $breakDownDetails) :
								if ($key % 7 == 0 && $key == 0) :
									$complexTariffBreakDownHtml .= '<tr>';
                                elseif ($key % 7 == 0) :
									$complexTariffBreakDownHtml .= '</tr><tr>';
								endif;
								$tmpKey                     = key($breakDownDetails);
								$complexTariffBreakDownHtml .= '<td><p>' . $this->dayMapping[$tmpKey] . '</p><span class=\"' . $this->tariffNetOrGross . '\">' . $breakDownDetails[$tmpKey][$this->tariffNetOrGross]->format() . '</span>';
							endforeach;

							$complexTariffBreakDownHtml .= '</tr></table>';
							$this->document->addScriptDeclaration('
					Solidres.jQuery(function($){
						$(".complex_tariff_break_down_' . $roomType->id . '").popover({
							html: true,
							content: "' . $complexTariffBreakDownHtml . '",
							title: "' . JText::_('SR_TARIFF_BREAK_DOWN') . '",
							placement: "bottom",
							trigger: "click"
						});
					});
				');
						endif;

						$this->document->addScriptDeclaration('
				Solidres.jQuery(function($){
					$(".sr-photo-' . $roomType->id . '").colorbox({rel:"sr-photo-' . $roomType->id . '", transition:"fade", width: "98%", height: "98%", className: "colorbox-w"});
					$(".carousel").carousel();
				});
			');

						$rowCSSClass                        = ($count % 2) ? ' even' : ' odd';
						$rowCSSClass                        .= $roomType->featured == 1 ? ' featured' : '';
						$currentSelectedRoomNumberPerTariff = array();

						if (!is_array($roomType->params)) :
							$roomType->params = json_decode($roomType->params, true);
						endif;

						$skipRoomForm = false;
						if (isset($roomType->params['skip_room_form']) && $roomType->params['skip_room_form'] == 1) :
							$skipRoomForm = true;
						endif;

						$isExclusive = false;
						if (isset($roomType->params['is_exclusive']) && $roomType->params['is_exclusive'] == 1) :
							$isExclusive = true;
						endif;

						$showRemainingRooms = true;
						if (isset($roomType->params['show_number_remaining_rooms']) && $roomType->params['show_number_remaining_rooms'] == 0) :
							$showRemainingRooms = false;
						endif;

						$showMoreInfo = true;
						if (isset($roomType->params['show_more_info_button']) && $roomType->params['show_more_info_button'] == 0) :
							$showMoreInfo = false;
						endif;

						$roomType->text = $roomType->description;
						JFactory::getApplication()->triggerEvent('onContentPrepare', array('com_solidres.roomtype', &$roomType, &$roomType->params, 0));
						?>
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?> <?php echo $rowCSSClass ?>"
                             id="room_type_row_<?php echo $roomType->id ?>">
                            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                        <div class="inner">
                                            <h4 class="roomtype_name" id="srt_<?php echo $roomType->id ?>">
									<span class="label label-default">
										<?php echo $roomType->occupancy_max > 0 ? $roomType->occupancy_max : (int) $roomType->occupancy_adult + (int) $roomType->occupancy_child ?>
                                        <i class="fa fa-user"></i>
									</span>

												<?php echo $roomType->name; ?>
												<?php if ($roomType->featured == 1) : ?>
                                                    <span class="label label-info"><?php echo JText::_('SR_FEATURED_ROOM_TYPE') ?></span>
												<?php endif ?>
                                            </h4>
                                        </div>
                                    </div>
                                </div>

                                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                    <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                                        <div class="inner">
											<?php
											if (!empty($roomType->media)) :
												echo '<div id="carousel' . $roomType->id . '" class="carousel slide">';
												echo '<div class="carousel-inner">';
												$countMedia = 0;
												$active     = '';
												foreach ($roomType->media as $media) :
													$active = ($countMedia == 0) ? 'active' : '';
													?>
                                                    <div class="<?php echo SR_UI_CAROUSEL_ITEM ?> <?php echo $active ?>">
                                                        <a class="room_type_details sr-photo-<?php echo $roomType->id ?>"
                                                           href="<?php echo $this->solidresMedia->getMediaUrl($media->value); ?>">
                                                            <img src="<?php echo $this->solidresMedia->getMediaUrl($media->value, 'roomtype_medium'); ?>"
                                                                 alt="<?php echo $roomType->name ?>"/>
                                                        </a>
                                                    </div>
													<?php
													$countMedia++;
												endforeach;
												echo '</div>';
												echo '<a class="carousel-control left" href="#carousel' . $roomType->id . '" data-slide="prev">&lsaquo;</a>';
												echo '<a class="carousel-control right" href="#carousel' . $roomType->id . '" data-slide="next">&rsaquo;</a>';
												echo '</div>';
											endif;
											?>
                                        </div>
                                    </div>

                                    <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                                        <div class="inner">
                                            <div class="roomtype_desc">
												<?php echo $roomType->text ?>
                                            </div>
											<?php
											if (!$this->isFresh && !empty($roomType->availableTariffs) && $showRemainingRooms) :
												if (isset($roomType->totalAvailableRoom)) :
													?>
                                                    <p>
									<span class="num_rooms_available_msg"
                                          id="num_rooms_available_msg_<?php echo $roomType->id ?>"
                                          data-original-text="<?php echo JText::plural('SR_WE_HAVE_X_' . ($roomType->is_private ? 'ROOM' : 'BED') . '_LEFT', $roomType->totalAvailableRoom) ?>">
										<?php echo JText::plural('SR_WE_HAVE_X_' . ($roomType->is_private ? 'ROOM' : 'BED') . '_LEFT', $roomType->totalAvailableRoom) ?>
									</span>
                                                    </p>
												<?php
												endif;
											endif;
											?>

											<?php if (!empty($roomType->facilities)): ?>
												<?php echo SRLayoutHelper::render('facility.facility', array('facilities' => $roomType->facilities)); ?>
											<?php endif; ?>

											<?php if ($showMoreInfo) : ?>
                                                <button type="button" class="btn btn-default toggle_more_desc"
                                                        data-target="<?php echo $roomType->id ?>">
                                                    <i class="fa fa-eye"></i>
													<?php echo JText::_('SR_SHOW_MORE_INFO') ?>
                                                </button>
											<?php endif ?>

											<?php if ($this->config->get('availability_calendar_enable', 1)) : ?>
                                                <button type="button" data-roomtypeid="<?php echo $roomType->id ?>"
                                                        class="btn btn-default load-calendar">
                                                    <i class="fa fa-calendar"></i> <?php echo JText::_('SR_AVAILABILITY_CALENDAR_VIEW') ?>
                                                </button>
											<?php endif ?>

											<?php if (SRPlugin::isEnabled('complextariff') && $this->showTariffs) : ?>
                                                <button type="button" data-roomtypeid="<?php echo $roomType->id ?>"
                                                        class="btn btn-default toggle-tariffs">
													<?php if ($this->showTariffs) : ?>
                                                        <i class="fa fa-compress"></i> <?php echo JText::_('SR_HIDE_TARIFFS') ?>
													<?php else : ?>
                                                        <i class="fa fa-expand"></i> <?php echo JText::_('SR_SHOW_TARIFFS') ?>
													<?php endif ?>
                                                </button>
											<?php endif ?>

                                            <div class="unstyled more_desc" id="more_desc_<?php echo $roomType->id ?>"
                                                 style="display: none">
												<?php
												if (!empty($roomType->roomtype_custom_fields['room_facilities'])) :
													echo '<p><strong>' . JText::_('SR_ROOM_FACILITIES') . ':</strong> ' . $roomType->roomtype_custom_fields['room_facilities'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['room_size'])) :
													echo '<p><strong>' . JText::_('SR_ROOM_SIZE') . ':</strong> ' . $roomType->roomtype_custom_fields['room_size'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['bed_size'])) :
													echo '<p><strong>' . JText::_('SR_BED_SIZE') . ':</strong> ' . $roomType->roomtype_custom_fields['bed_size'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['taxes'])) :
													echo '<p><strong>' . JText::_('SR_TAXES') . ':</strong> ' . $roomType->roomtype_custom_fields['taxes'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['prepayment'])) :
													echo '<p><strong>' . JText::_('SR_PREPAYMENT') . ':</strong> ' . $roomType->roomtype_custom_fields['prepayment'] . '</p>';
												endif;

												?>
                                            </div>
                                        </div>
                                    </div> <!-- end of span8 -->
                                </div> <!-- end of row-fluid -->

								<?php if ($this->config->get('availability_calendar_enable', 1)) : ?>
                                    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                        <div class="<?php echo SR_UI_GRID_COL_12 ?> availability-calendar"
                                             id="availability-calendar-<?php echo $roomType->id ?>"
                                             style="display: none">
                                        </div>
                                    </div>
								<?php endif ?>

								<?php if (SRPlugin::isEnabled('flexsearch')) :
									$layout = SRLayoutHelper::getInstance();
									$layout->addIncludePath(SRPlugin::getLayoutPath('flexsearch'));
									echo $layout->render('roomtype.flexsearch', array('roomType' => $roomType, 'bookingType' => $this->item->booking_type, 'enableAutoScroll' => $this->enableAutoScroll));
								endif ?>

								<?php if (!SRPlugin::isEnabled('flexsearch') || (SRPlugin::isEnabled('flexsearch') && empty($roomType->otherAvailableDates))) : ?>
                                    <div class="<?php echo SR_UI_GRID_CONTAINER ?>"
                                         id="tariff-holder-<?php echo $roomType->id ?>"
                                         style="<?php echo !$this->disableOnlineBooking || $this->showTariffs ? '' : 'display: none' ?>">
                                        <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                            <div class="inner">
												<?php
												if (!$this->isFresh) :
													if (!empty($roomType->availableTariffs)) :

														$countRatePerRoomType = 0;
														$countRatePerRoom     = 0;
														if ($roomType->number_of_room == $roomType->totalAvailableRoom) :
															foreach ($roomType->availableTariffs as $tariffKey => $tariffInfo) :

																if ($tariffInfo['tariffType'] != 4) :
																	$countRatePerRoom++;
																	continue;
																endif;

																$minPrice = $this->appendPriceSuffix(
																	$tariffInfo['val'],
																	$tariffInfo['tariffType'],
																	$this->item->booking_type,
																	($this->item->booking_type == 0 ? $this->stayLength : $this->stayLength + 1),
																	$tariffInfo['val_original'],
																	$roomType->is_private,
																	$tariffInfo['adults'],
																	$tariffInfo['children']
																);

																$layout = SRLayoutHelper::getInstance();
																echo $layout->render('asset.tariff_book', array(
																		'item'                 => $this->item,
																		'Itemid'               => $this->itemid,
																		'roomType'             => $roomType,
																		'bookingType'          => $this->item->booking_type,
																		'disableOnlineBooking' => $this->disableOnlineBooking,
																		'minPrice'             => $minPrice,
																		'tariffKey'            => $tariffKey,
																		'tariffInfo'           => $tariffInfo,
																		'stayLength'           => $this->stayLength,
																		'selectedRoomTypes'    => $this->selectedRoomTypes,
																		'skipRoomForm'         => $skipRoomForm,
																		'isExclusive'          => $isExclusive
																	)
																);
																$countRatePerRoomType++;
															endforeach;
														endif;

														if ($countRatePerRoomType > 0 && $countRatePerRoom > 0) :
															echo '<div class="tariff-sep"></div>';
														endif;

														foreach ($roomType->availableTariffs as $tariffKey => $tariffInfo) :

															if ($tariffInfo['tariffType'] == 4) continue;

															$minPrice = $this->appendPriceSuffix(
																$tariffInfo['val'],
																$tariffInfo['tariffType'],
																$this->item->booking_type,
																($this->item->booking_type == 0 ? $this->stayLength : $this->stayLength + 1),
																$tariffInfo['val_original'],
																$roomType->is_private,
																$tariffInfo['adults'],
																$tariffInfo['children']
															);

															$layout = SRLayoutHelper::getInstance();
															echo $layout->render('asset.tariff_book', array(
																	'item'                 => $this->item,
																	'Itemid'               => $this->itemid,
																	'roomType'             => $roomType,
																	'bookingType'          => $this->item->booking_type,
																	'disableOnlineBooking' => $this->disableOnlineBooking,
																	'minPrice'             => $minPrice,
																	'tariffKey'            => $tariffKey,
																	'tariffInfo'           => $tariffInfo,
																	'stayLength'           => $this->stayLength,
																	'selectedRoomTypes'    => $this->selectedRoomTypes,
																	'skipRoomForm'         => $skipRoomForm,
																	'isExclusive'          => $isExclusive
																)
															);
														endforeach;
													else :
														if (SRPlugin::isEnabled('flexsearch') && !empty($roomType->otherAvailableDates)) :

														else :
															$link = JRoute::_('index.php?option=com_solidres&view=reservationasset&id=' . $this->item->id . ($this->enableAutoScroll ? '#form' : ''));
															echo '<div class="alert alert-notice">' . JText::sprintf('SR_NO_TARIFF_MATCH_CHECKIN_CHECKOUT', $this->checkinFormatted, $this->checkoutFormatted, $link) . '</div>';
														endif;
													endif;
												endif;

												if ($this->isFresh && $this->showTariffs == 1 && isset($roomType->tariffs) && is_array($roomType->tariffs)) :

													$countRatePerRoomType = 0;
													foreach ($roomType->tariffs as $tariff) :

														if ($tariff->type != 4) continue;
														$minPrice = $this->getMinPrice($tariff, $roomType);
														$layout   = SRLayoutHelper::getInstance();
														echo $layout->render('asset.tariff_list', array(
																'item'                 => $this->item,
																'Itemid'               => $this->itemid,
																'roomType'             => $roomType,
																'bookingType'          => $this->item->booking_type,
																'disableOnlineBooking' => $this->disableOnlineBooking,
																'tariff'               => $tariff,
																'minPrice'             => $minPrice
															)
														);
														$countRatePerRoomType++;

													endforeach; // end foreach of complex tariffs

													if ($countRatePerRoomType > 0) :
														echo '<div class="tariff-sep"></div>';
													endif;

													foreach ($roomType->tariffs as $tariff) :

														if ($tariff->type == 4) continue;
														$minPrice = $this->getMinPrice($tariff, $roomType);
														$layout   = SRLayoutHelper::getInstance();
														echo $layout->render('asset.tariff_list', array(
																'item'                 => $this->item,
																'Itemid'               => $this->itemid,
																'roomType'             => $roomType,
																'bookingType'          => $this->item->booking_type,
																'disableOnlineBooking' => $this->disableOnlineBooking,
																'tariff'               => $tariff,
																'minPrice'             => $minPrice
															)
														);

													endforeach;
												endif ?>
                                            </div>
                                        </div> <!-- end of span12 -->
                                    </div> <!-- end of row-fluid and #tariff-holder -->
								<?php endif ?>
                            </div>  <!-- end of span12 -->
                        </div> <!-- end of row-fluid -->
						<?php
						$count++;
					endforeach
					?>
				<?php
				else :
					?>
                    <div class="alert alert-warning">
						<?php
						echo JText::sprintf('SR_NO_ROOM_TYPES_MATCHED_SEARCH_CONDITIONS',
							JDate::getInstance($this->checkin, $this->timezone)->format($this->dateFormat, true),
							JDate::getInstance($this->checkout, $this->timezone)->format($this->dateFormat, true)
						);
						?>
                        <a class=""
                           href="<?php echo JRoute::_('index.php?option=com_solidres&task=reservationasset.startOver&id=' . $this->item->id) ?>"><i
                                    class="fa fa-refresh"></i> <?php echo JText::_('SR_SEARCH_RESET') ?></a>
                    </div>
				<?php
				endif;
				?>

				<?php if (!$this->isFresh && count($this->item->roomTypes) > 0) : ?>
                    <div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-bottom">
                        <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                            <div class="inner">
                                <p><?php echo JText::_('SR_ROOMINFO_STEP_NOTICE_MESSAGE') ?></p>
                            </div>
                        </div>
                        <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                            <div class="inner">
                                <div class="btn-group">
                                    <button data-step="room" type="submit" class="btn btn-success">
                                        <i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
				<?php endif ?>

                <input type="hidden" name="jform[raid]" value="<?php echo $this->item->id ?>"/>
                <input type="hidden" name="jform[next_step]" value="guestinfo"/>
                <input type="hidden" name="jform[bookingconditions]"
                       value="<?php echo $this->item->params['termsofuse'] ?>"/>
                <input type="hidden" name="jform[privacypolicy]"
                       value="<?php echo $this->item->params['privacypolicy'] ?>"/>

				<?php echo JHtml::_('form.token'); ?>
            </form>
        </div>
        <!-- /Tab 1 -->

    </div>

    <div class="step-pane" id="step2">
        <!-- Tab 2 -->
        <div class="reservation-single-step-holder guestinfo nodisplay">
        </div>
        <!-- /Tab 2 -->
    </div>

    <div class="step-pane" id="step3">
        <!-- Tab 3 -->
        <div class="reservation-single-step-holder confirmation nodisplay">
        </div>
        <!-- /Tab 3 -->
    </div>

</div>