<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/com_solidres/reservationasset/default_information.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

if (!isset($this->item->params['show_facilities'])) :
	$this->item->params['show_facilities'] = 1;
endif;

if (!isset($this->item->params['show_policies'])) :
	$this->item->params['show_policies'] = 1;
endif;

?>

<?php if ($this->item->params['show_facilities']) : ?>
    <h3><?php echo JText::_('SR_CUSTOMFIELD_FACILITIES') ?></h3>

	<?php if (isset($this->item->reservationasset_extra_fields['general'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['general']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_GENERAL') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['activities'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['activities']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_ACTIVITIES') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['services'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['services']))): ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_SERVICES') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['internet'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['internet']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_INTERNET') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['parking'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['parking']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_PARKING') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>
<?php endif; ?>

<?php if ($this->item->params['show_policies']) : ?>
    <h3><?php echo JText::_('SR_CUSTOMFIELD_POLICIES') ?></h3>

	<?php if (isset($this->item->reservationasset_extra_fields['checkin_time'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['checkin_time']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_CHECKIN') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['checkout_time'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['checkout_time']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_CHECKOUT') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['cancellation_prepayment'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['cancellation_prepayment']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_CANCELLATION_PREPAYMENT') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['children_and_extra_beds'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['children_and_extra_beds']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_CHILDREN_EXTRA_BEDS') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['pets'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['pets']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_PETS') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>

	<?php if (isset($this->item->reservationasset_extra_fields['accepted_credit_cards'])
		&& ($value = SRUtilities::translateText($this->item->reservationasset_extra_fields['accepted_credit_cards']))) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> custom-field-row">
            <div class="<?php echo SR_UI_GRID_COL_2 ?> info-heading"><?php echo JText::_('SR_CUSTOMFIELD_ACCEPTED_CREDIT_CARDS') ?></div>
            <div class="<?php echo SR_UI_GRID_COL_10 ?>"><?php echo $value ?></div>
        </div>
	<?php endif; ?>
<?php endif; ?>
