<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

require_once JPATH_ADMINISTRATOR.'/components/com_solidres/models/discount.php';

class SolidresModelDiscountForm extends SolidresModelDiscount
{
	/**
	 * Get the return URL.
	 *
	 * @return  string	The return URL.
	 *
	 * @since   1.6
	 */
	public function getReturnPage()
	{
		return base64_encode($this->getState('return_page'));
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function populateState()
	{
		$app = JFactory::getApplication();

		// Load state from the request.
		$pk = $app->input->getInt('id');
		$this->setState('discount.id', $pk);

		//$this->setState('article.catid', $app->input->getInt('catid'));

		$return = $app->input->get('return', null, 'base64');
		$this->setState('return_page', base64_decode($return));

		// Load the parameters.
		$params	= $app->getParams();
		$this->setState('params', $params);

		$this->setState('layout', $app->input->get('layout'));
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$form = $this->loadForm('com_solidres.discount',
			'discountfrontend',
			array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = parent::loadFormData();

		// Compute selected asset permissions.
		$user = JFactory::getUser();
		$userId	= $user->get('id');
		$asset = 'com_solidres.reservationasset.' . $data->reservation_asset_id;
		$tableCustomer = JTable::getInstance('Customer', 'SolidresTable');
		$tableReservationAsset = JTable::getInstance('ReservationAsset', 'SolidresTable');
		$tableCustomer->load(array('user_id' => $userId));
		$tableReservationAsset->load($data->reservation_asset_id);

		// Check general edit permission first.
		if ($user->authorise('core.edit', $asset))
		{
			$data->params['access-edit'] = true;
		}

		// Now check if edit.own is available.
		if (!empty($userId) && !empty($tableCustomer->id) && $user->authorise('core.edit.own', $asset))
		{
			// Check for a valid user and that they are the owner.
			if ($tableCustomer->id == $tableReservationAsset->partner_id)
			{
				$data->params['access-edit'] = true;
			}
			else
			{
				$data->params['access-edit'] = false;
			}
		}

		// Check edit state permission.
		if ($data->id)
		{
			// Existing item
			$data->params['access-change'] = $user->authorise('core.edit.state', $asset);
		}
		else
		{
			// New item.
			/*$catId = (int) $this->getState('.catid');

			if ($catId)
			{
				$data->params['access-change'] = $user->authorise('core.edit.state', 'com_solidres.category.' . $catId);
				$data->catid = $catId;
			}
			else
			{*/
				$data->params['access-change'] = $user->authorise('core.edit.state', 'com_solidres');
			/*}*/
		}


		return $data;
	}
}