<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

$model=$displayData['model'];
$room_types=$displayData['room_types'];
$controller=$displayData['controller'];
$current_month=$displayData['current_month'];
$current_year=$displayData['current_year'];
$navigation_type=$displayData['navigation_type'];
$day_of_month=$displayData['day_of_month'];
$asset_id=$displayData['asset_id'];
$timezone=$displayData['timezone'];

$start_column=1;
$end_column=$day_of_month;
$total_columns=$day_of_month;

$table_class="sr_statistics_month_table".$day_of_month;
$frontend = JFactory::getApplication()->isSite();
?>
<table class="sr_statistics_table <?php echo $table_class;?>" id="selectable" border="0" cellpadding="0" cellspacing="0">
	<tr class="sr_statistics_rows sr_statistics_header_row">
	<?php
	for ($num_days=$start_column;$num_days<=$end_column;$num_days++) :
		$today_class="";
		$today_date=JDate::getInstance("now",$timezone)->format('D M d',true);
		$date_tmp=JDate::getInstance($current_year.'-'.$current_month.'-'.$num_days, $timezone)->format('D M d', true);

		if ($today_date==$date_tmp) :
			$today_class=' class="sr_dashboard_today" ';
		endif;

	?>
		<td <?php echo $today_class;?> id="<?php echo $current_year.'-'.$current_month.'-'.$num_days;?>"><?php echo $date_tmp;?></td>
	<?php
	endfor;
	?>
	</tr>

	<?php

	for($i=0;$i<count($room_types);$i++) :

		$room_type=$room_types[$i];
		?>
			<tr>
				<td colspan="<?php echo $end_column;?>"></td>
			</tr>
		<?php
		$rooms=$model->getRooms($room_type->id);
		$rows_n=1;
		for($r=0;$r<count($rooms);$r++) :
			$room=$rooms[$r];
			$tr_tmp_class=$rows_n%2 ?  "sr_odd_row" : "sr_even_row";
			?>

			<tr class="<?php echo $tr_tmp_class;?>">


				<?php
				for($num_days=$start_column;$num_days<=$end_column;$num_days++)
				{
					$limited_booking=$model->isLimitedBooking($asset_id,$room->id,$current_year.'-'.$current_month.'-'.$num_days);
					
					if(count($limited_booking))
					{
						$total_limited_days=0;
						$limit_booking_interval = date_diff(date_create($limited_booking->start_date), date_create($limited_booking->end_date));						
						$total_limited_days=(int)$limit_booking_interval->format('%a');
						
						$limit_start_date=JDate::getInstance($limited_booking->start_date,$timezone)->format('m',true);
						
						if($total_limited_days > $day_of_month || $limit_start_date!=$current_month){							
							$limit_booking_interval = date_diff(date_create($current_year.'-'.$current_month.'-01'), date_create($limited_booking->end_date));							
							$total_limited_days=(int)$limit_booking_interval->format('%a');
							$total_limited_days=$total_limited_days+1;// Increase 1, because that the date_diff not get the first day of month
						}
						
						$limited_colspan=$total_limited_days;
						$increased_steps=$num_days+$total_limited_days;



						if($increased_steps>$end_column)
						{

							$limited_colspan=($end_column - $num_days) + 1;
							$num_days=$end_column;
						}
						else
						{
							$num_days=$num_days+($total_limited_days-1);
						}

						?>
						<td class="sr_statistics_limited" colspan="<?php echo $limited_colspan;?>"><?php echo $limited_booking->title;?> </td>
						<?php
					}
					else
					{
						$booked_infoes=$model->getBookedRoom($asset_id,$room->id,$current_year.'-'.$current_month.'-'.$num_days);

						if(count($booked_infoes))
						{

							$booked_info=$booked_infoes[0];
							$reservation_text='<a title="'.JText::_('SR_STATISTICS_DASHBOARD_RESERVED_BY').' '.$booked_info->customer_firstname.' '.$booked_info->customer_middlename.' '.$booked_info->customer_lastname.'" href="index.php?option=com_solidres&task=reservation'.($frontend ? 'form' : '' ).'.edit&id='.$booked_info->id.'">'.JText::_('SR_STATISTICS_DASHBOARD_RESERVATION').' '.$booked_info->code.'</a>';
							$state_class=$controller->getStateClass($booked_info->state);

							$colspan=1;

							$checkin_date = date_create($booked_info->checkin);
							if($num_days==1)
							{
								$checkin_date = date_create($current_year.'-'.$current_month.'-01');
							}
							$checkout_date = date_create($booked_info->checkout);
							$interval = date_diff($checkin_date, $checkout_date);
							$total_booked_days=(int)$interval->format('%a');
							
							if($total_booked_days > $day_of_month){							
								$checkin_date = date_create($current_year.'-'.$current_month.'-01');
								$interval = date_diff($checkin_date, $checkout_date);
								$total_booked_days=(int)$interval->format('%a');
							}

							if($total_booked_days + $num_days > $end_column)
							{
								$colspan=($end_column - $num_days)+1;
							}
							else
							{
								$colspan=$total_booked_days;
							}


							?>
								<td class="booked_date <?php echo $state_class;?>" colspan="<?php echo $colspan;?>"><?php echo $reservation_text;?></td>
							<?php
							if($colspan>1){
								$num_days=$num_days+($colspan-1);
							}

						}
						else
						{
							$weekend="";
							$col_date=$current_year.'-'.$current_month.'-'.$num_days;
							$col_id_arr=array('col_date'=>$col_date,'col_room_id'=>$room->id,'asset_id'=>$room_type->reservation_asset_id);
							if(date('N',strtotime($col_date))>5){
								$weekend="weekends";
							}
							?>

							<td class="ui-widget-content <?php echo $weekend;?> free_dates" id="<?php echo base64_encode(base64_encode(json_encode($col_id_arr)));?>"></td>

							<?php
						}

					}

				}

			?>
			</tr>
			<?php
			$rows_n=$rows_n+1;
		endfor;
	endfor;
?>
</table>

<input type="hidden" name="temp_month" value="<?php echo $current_month;?>" />
<input type="hidden" name="temp_year" value="<?php echo $current_year;?>" />