<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

extract($displayData);

if (!isset($asset->params['enable_coupon'])) :
	$asset->params['enable_coupon'] = 0;
endif;

if ($asset->params['enable_coupon'] == 1) :
	if (!$isFresh) :
		?>
        <div class="coupon">
            <div class="input-append">
                <input type="text" name="coupon_code" class="" id="coupon_code"
                       placeholder="<?php echo JText::_('SR_COUPON_ENTER') ?>"/>
                <button id="coupon_code_check" class="btn btn-default"
                        type="button"><?php echo JText::_('SR_COUPON_CHECK') ?></button>
            </div>
			<?php if (isset($coupon)) : ?>
                <span>
			<?php echo JText::_('SR_APPLIED_COUPON') ?>
                    <span class="label label-success">
			<?php echo $coupon['coupon_name'] ?>
			</span>&nbsp;
			<a id="sr-remove-coupon" href="javascript:void(0)" data-couponid="<?php echo $coupon['coupon_id'] ?>">
				<?php echo JText::_('SR_REMOVE') ?>
			</a>
		</span>
			<?php endif ?>
        </div>
        <script>
            Solidres.jQuery(function ($) {
                $('#coupon_code_check').click(function () {
                    var self = $('input#coupon_code');
                    var coupon_code = self.val();
                    if (coupon_code) {
                        $.ajax({
                            type: 'POST',
                            url: window.location.pathname,
                            data: 'option=com_solidres&format=json&task=coupon.isValid&coupon_code=' + coupon_code + '&raid=' + $('input[name="id"]').val(),
                            success: function (response) {
                                self.parent().next('span').remove();
                                self.parent().after(response.message);
                                if (!response.status) {
                                    $('#apply-coupon').attr('disabled', 'disabled');
                                } else {
                                    $('#apply-coupon').removeAttr('disabled');
                                }
                            },
                            dataType: 'JSON'
                        });
                    }
                });
            });
        </script>
	<?php
	endif;
endif;
?>