<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * @package       Solidres
 * @subpackage    ReservationAsset
 * @since         0.1.0
 */
class SolidresControllerReservationAsset extends JControllerLegacy
{
	private $context;

	protected $reservationDetails;

	public function __construct($config = array())
	{
		$config['model_path'] = JPATH_COMPONENT_ADMINISTRATOR . '/models';

		parent::__construct($config);

		$this->app     = JFactory::getApplication();
		$this->context = 'com_solidres.reservation.process';

		// $raid is preferred because it does not conflict with core Joomla multilingual feature
		$this->reservationAssetId = $this->input->getUint('raid');
		if (empty($this->reservationAssetId))
		{
			$this->reservationAssetId = $this->input->getUint('id');
		}

		// Get the default currency
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables', 'SolidresTable');
		$tableAsset = JTable::getInstance('ReservationAsset', 'SolidresTable');
		$tableAsset->load($this->reservationAssetId);
		$this->reservationData['currency_id'] = $tableAsset->currency_id;

		$this->app->setUserState($this->context . '.currency_id', $tableAsset->currency_id);
		$this->app->setUserState($this->context . '.deposit_required', $tableAsset->deposit_required);
		$this->app->setUserState($this->context . '.deposit_is_percentage', $tableAsset->deposit_is_percentage);
		$this->app->setUserState($this->context . '.deposit_amount', $tableAsset->deposit_amount);
		$this->app->setUserState($this->context . '.deposit_by_stay_length', $tableAsset->deposit_by_stay_length);
		$this->app->setUserState($this->context . '.deposit_include_extra_cost', $tableAsset->deposit_include_extra_cost);
		$this->app->setUserState($this->context . '.tax_id', $tableAsset->tax_id);
		$this->app->setUserState($this->context . '.booking_type', $tableAsset->booking_type);

		if (isset($tableAsset->params))
		{
			$this->app->setUserState($this->context . '.asset_params', json_decode($tableAsset->params, true));
		}

		$this->app->setUserState($this->context . '.origin', JText::_('SR_RESERVATION_ORIGIN_DIRECT'));
		$this->app->setUserState($this->context . '.asset_category_id', $tableAsset->category_id);
		$this->app->setUserState($this->context . '.price_includes_tax', $tableAsset->price_includes_tax);
	}

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param    string $name   The model name. Optional.
	 * @param    string $prefix The class prefix. Optional.
	 * @param    array  $config Configuration array for model. Optional.
	 *
	 * @return    object    The model.
	 * @since    1.5
	 */
	public function &getModel($name = 'ReservationAsset', $prefix = 'SolidresModel', $config = array())
	{
		$model = parent::getModel($name, $prefix, $config);

		return $model;
	}

	public function checkavailability()
	{
		$id       = $this->input->getUint('id', 0, 'int');
		$checkIn  = $this->input->get('checkin', '', 'string');
		$checkOut = $this->input->get('checkout', '', 'string');

		if (!empty($checkIn) && !empty($checkOut))
		{
			$config   = JFactory::getConfig();
			$timezone = new DateTimeZone($config->get('offset'));
			$checkIn  = JDate::getInstance($checkIn, $timezone)->format('Y-m-d', true);
			$checkOut = JDate::getInstance($checkOut, $timezone)->format('Y-m-d', true);
		}

		$model            = $this->getModel();
		$solidresConfig   = JComponentHelper::getParams('com_solidres');
		$showPriceWithTax = $solidresConfig->get('show_price_with_tax', 0);

		$itemId                = $this->input->getUInt('Itemid', 0);
		$roomsOccupancyOptions = $this->input->get('room_opt', array(), 'array');
		$this->app->setUserState($this->context . '.checkin', $checkIn);
		$this->app->setUserState($this->context . '.checkout', $checkOut);
		$this->app->setUserState($this->context . '.room_opt', $roomsOccupancyOptions);

		// Get the current selected tariffs if available
		$tariffs = $this->app->getUserState($this->context . '.current_selected_tariffs');

		// Set the current active menu item id
		$this->app->setUserState($this->context . '.activeItemId', $itemId > 0 ? $itemId : null);

		$model->setState('id', $id);
		$model->setState('checkin', $checkIn);
		$model->setState('checkout', $checkOut);
		$model->setState('country_id', $this->input->get('country_id', 0, 'int'));
		$model->setState('geo_state_id', $this->input->get('geo_state_id', 0, 'int'));
		$model->setState('show_price_with_tax', $showPriceWithTax);
		$model->setState('tariffs', $tariffs);
		$model->setState('room_opt', $roomsOccupancyOptions);

		$document   = JFactory::getDocument();
		$viewType   = $document->getType();
		$viewName   = 'ReservationAsset';
		$viewLayout = 'default';

		$this->hit($id);

		$view = $this->getView($viewName, $viewType, '', array('base_path' => $this->basePath, 'layout' => $viewLayout));
		$view->setModel($model, true);
		$view->document = $document;
		$view->display();
	}

	/**
	 * Increase the hit counter
	 *
	 * @param $pk
	 *
	 * @return void
	 */
	public function hit($pk)
	{
		$table = JTable::getInstance('ReservationAsset', 'SolidresTable');
		$table->hit($pk);
	}

	/**
	 * Get the html output according to the room type quantity selection
	 *
	 * This output contains room specific form like adults and children's quantity (including children's ages) as well
	 * as some other information like room preferences like smoking and room's extra items
	 *
	 * @return string
	 */
	public function getRoomTypeForm()
	{
		$solidresRoomType  = SRFactory::get('solidres.roomtype.roomtype');
		$params            = JComponentHelper::getParams('com_solidres');
		$showTaxIncl       = $params->get('show_price_with_tax', 0);
		$childMaxAge       = $params->get('child_max_age_limit', 17);
		$confirmationState = $params->get('confirm_state', 5);
		$roomTypeId        = $this->input->get('rtid', 0, 'int');
		$raId              = $this->input->get('raid', 0, 'int');
		$tariffId          = $this->input->get('tariffid', 0, 'int');
		$adjoiningLayer    = $this->input->get('adjoininglayer', 0, 'int');
		$quantity          = $this->input->get('quantity', 0, 'int');
		$bookingType       = $solidresRoomType->getBookingType($roomTypeId);
		$modelRoomType     = $this->getModel('RoomType');
		$modelTariff       = $this->getModel('Tariff');
		$roomType          = $modelRoomType->getItem($roomTypeId);
		$tariff            = $modelTariff->getItem($tariffId);
		$modelExtras       = $this->getModel('Extras', 'SolidresModel', array('ignore_request' => true));
		$modelExtras->setState('filter.room_type_id', $roomTypeId);
		$modelExtras->setState('filter.state', 1);
		$modelExtras->setState('filter.show_price_with_tax', $showTaxIncl);
		$extras = $modelExtras->getItems();

		// Early arrival checking
		$checkin                     = $this->app->getUserState($this->context . '.checkin');
		$checkout                    = $this->app->getUserState($this->context . '.checkout');
		$allowedEarlyArrivalExtraIds = array();
		foreach ($extras as &$extra)
		{
			if (8 != $extra->charge_type)
			{
				continue;
			}

			$extraParams = new Joomla\Registry\Registry($extra->params);
			$distance    = $extraParams->get('previous_checkout_distance', 1);
			$newCheckin  = (new DateTime($checkin))->modify("-$distance day");

			$availableRooms              = $solidresRoomType->getListAvailableRoom($roomTypeId, $newCheckin->format('Y-m-d'), $checkout, $bookingType, 0, $confirmationState);
			$totalRoomTypeAvailableRooms = is_array($availableRooms) ? count($availableRooms) : 0;
			$extra->allow_early_arrival  = false;

			if ($totalRoomTypeAvailableRooms >= $quantity)
			{
				$extra->allow_early_arrival    = true;
				$allowedEarlyArrivalExtraIds[] = $extra->id;
			}
		}

		$this->app->setUserState($this->context . '.allowed_early_arrival_extra_ids', $allowedEarlyArrivalExtraIds);

		$this->reservationDetails = $this->app->getUserState($this->context);

		$form = SRLayoutHelper::getInstance();

		$displayData = array(
			'assetId'            => $raId,
			'roomTypeId'         => $roomTypeId,
			'tariffId'           => $tariffId,
			'quantity'           => $quantity,
			'roomType'           => $roomType,
			'reservationDetails' => $this->reservationDetails,
			'extras'             => $extras,
			'childMaxAge'        => $childMaxAge,
			'tariff'             => $tariff,
			'adjoiningLayer'     => $adjoiningLayer,
		);

		// Room form custom fields
		if (SRPlugin::isEnabled('customfield'))
		{
			$categories = isset($this->reservationDetails->asset_category_id) ? [$this->reservationDetails->asset_category_id] : [];
			$roomFields = SRCustomFieldHelper::findFields(['context' => 'com_solidres.room'], $categories);

			if (!empty($roomFields))
			{
				$roomsData                 = (array) $this->app->getUserState($this->context . '.room', []);
				$roomFieldsValues          = isset($roomsData['roomFields']) ? (array) $roomsData['roomFields'] : [];
				$displayData['roomFields'] = $roomFields;
				$displayData['roomForm']   = '';

				foreach ($roomFields as $roomField)
				{
					$roomField->field_name = 'roomFields][' . $roomField->id;
					$roomField->inputId    = 'roomFields-' . $roomField->id . '-{%ID_INCREMENT}';

					if (isset($roomFieldsValues[$roomField->id]))
					{
						$roomField->value = $roomFieldsValues[$roomField->id];
					}

					$displayData['roomForm'] .= SRCustomFieldHelper::render($roomField);
				}
			}
		}

		echo $form->render(
			'asset.roomtypeform' . ((defined('SR_LAYOUT_STYLE') && SR_LAYOUT_STYLE != '') ? '_' . SR_LAYOUT_STYLE : ''),
			$displayData
		);

		$this->app->close();
	}

	/**
	 * Get the availability calendar
	 *
	 * The number of months to be displayed in configured in component's options
	 *
	 * @return string
	 */
	public function getAvailabilityCalendar()
	{
		JLoader::register('SRCalendar', SRPATH_LIBRARY . '/utilities/calendar.php');
		$roomTypeId   = $this->input->get('id', 0, 'int');
		$params       = JComponentHelper::getParams('com_solidres');
		$weekStartDay = $params->get('week_start_day', 1) == 1 ? 'monday' : 'sunday';
		$calendarStyle = $params->get('availability_calendar_style', 1) == 1 ? 'modern' : 'legacy';

		$calendar = new SRCalendar(array('start_day' => $weekStartDay, 'style' => $calendarStyle));
		$html     = '';
		$html     .= '<span class="legend-busy"></span> ' . JText::_('SR_AVAILABILITY_CALENDAR_BUSY');
		$html     .= ' <span class="legend-restricted"></span> ' . JText::_('SR_AVAILABILITY_CALENDAR_RESTRICTED');
		$period   = $params->get('availability_calendar_month_number', 6);
		for ($i = 0; $i < $period; $i++)
		{
			if ($i % 3 == 0 && $i == 0)
			{
				$html .= '<div class="' . SR_UI_GRID_CONTAINER . '">';
			}
			else if ($i % 3 == 0)
			{
				$html .= '</div><div class="' . SR_UI_GRID_CONTAINER . '">';
			}

			$year  = date('Y', strtotime('first day of this month +' . $i . ' month'));
			$month = date('n', strtotime('first day of this month +' . $i . ' month'));
			$html  .= '<div class="' . SR_UI_GRID_COL_4 . '">' . $calendar->generate($year, $month, $roomTypeId) . '</div>';
		}

		echo $html;

		$this->app->close();
	}

	public function getCheckInOutForm()
	{
		$solidresConfig           = JComponentHelper::getParams('com_solidres');
		$systemConfig             = JFactory::getConfig();
		$datePickerMonthNum       = $solidresConfig->get('datepicker_month_number', 3);
		$weekStartDay             = $solidresConfig->get('week_start_day', 1);
		$dateFormat               = $solidresConfig->get('date_format', 'd-m-Y');
		$tzoffset                 = $systemConfig->get('offset');
		$tariffId                 = $this->input->getUInt('tariff_id', 0);
		$roomtypeId               = $this->input->getUInt('roomtype_id', 0);
		$assetId                  = $this->input->getUInt('id', 0);
		$itemId                   = $this->input->getUInt('Itemid', 0);
		$modelTariff              = JModelLegacy::getInstance('Tariff', 'SolidresModel', array('ignore_request' => true));
		$tariff                   = $modelTariff->getItem($tariffId);
		$this->reservationDetails = $this->app->getUserState($this->context);
		$timezone                 = new DateTimeZone($tzoffset);
		$checkin                  = isset($this->reservationDetails->checkin) ? $this->reservationDetails->checkin : null;
		$checkout                 = isset($this->reservationDetails->checkout) ? $this->reservationDetails->checkout : null;

		$currentSelectedTariffs                = $this->app->getUserState($this->context . '.current_selected_tariffs');
		$currentSelectedTariffs[$roomtypeId][] = $tariffId;
		$this->app->setUserState($this->context . '.current_selected_tariffs', $currentSelectedTariffs);

		$jsDateFormat = SRUtilities::convertDateFormatPattern($dateFormat);
		$bookingType  = $this->app->getUserState($this->context . '.booking_type');

		$form = SRLayoutHelper::getInstance();

		$displayData = array(
			'tariff'               => $tariff,
			'assetId'              => $assetId,
			'roomTypeId'           => $roomtypeId,
			'checkIn'              => $checkin,
			'checkOut'             => $checkout,
			'minDaysBookInAdvance' => $solidresConfig->get('min_days_book_in_advance', 0),
			'maxDaysBookInAdvance' => $solidresConfig->get('max_days_book_in_advance', 0),
			'minLengthOfStay'      => $solidresConfig->get('min_length_of_stay', 1),
			'timezone'             => $timezone,
			'itemId'               => $itemId,
			'datePickerMonthNum'   => $datePickerMonthNum,
			'weekStartDay'         => $weekStartDay,
			'dateFormat'           => $dateFormat, // default format d-m-y
			'jsDateFormat'         => $jsDateFormat,
			'bookingType'          => $bookingType,
			'enableAutoScroll'     => $solidresConfig->get('enable_auto_scroll', 1)
		);

		echo $form->render(
			'asset.checkinoutform',
			$displayData
		);

		$this->app->close();
	}

	public function getCheckInOutFormChangeDates()
	{
		$solidresConfig           = JComponentHelper::getParams('com_solidres');
		$systemConfig             = JFactory::getConfig();
		$tariffId                 = $this->input->getUInt('tariff_id', 0);
		$roomtypeId               = $this->input->getUInt('roomtype_id', 0);
		$assetId                  = $this->input->getUInt('id', 0);
		$itemId                   = $this->input->getUInt('Itemid', 0);
		$return                   = $this->input->getString('return', '');
		$reservationId            = $this->input->getUInt('reservation_id', 0);
		$modelTariff              = JModelLegacy::getInstance('Tariff', 'SolidresModel', array('ignore_request' => true));
		$tariff                   = $modelTariff->getItem($tariffId);
		$this->reservationDetails = $this->app->getUserState($this->context);
		$tzoffset                 = $systemConfig->get('offset');
		$timezone                 = new DateTimeZone($tzoffset);
		/*$checkin = isset($this->reservationDetails->checkin) ? $this->reservationDetails->checkin : NULL;
		$checkout = isset($this->reservationDetails->checkout) ? $this->reservationDetails->checkout : NULL;*/
		$checkin  = $this->input->getString('checkin', '');
		$checkout = $this->input->getString('checkout', '');

		$datePickerMonthNum                    = $solidresConfig->get('datepicker_month_number', 3);
		$weekStartDay                          = $solidresConfig->get('week_start_day', 1);
		$currentSelectedTariffs                = $this->app->getUserState($this->context . '.current_selected_tariffs');
		$currentSelectedTariffs[$roomtypeId][] = $tariffId;
		$this->app->setUserState($this->context . '.current_selected_tariffs', $currentSelectedTariffs);
		JLoader::register('SRUtilities', SRPATH_LIBRARY . '/utilities/utilities.php');
		$dateFormat   = $solidresConfig->get('date_format', 'd-m-Y');
		$jsDateFormat = SRUtilities::convertDateFormatPattern($dateFormat);

		$form = SRLayoutHelper::getInstance();

		$displayData = array(
			'tariff'               => $tariff,
			'assetId'              => $assetId,
			'checkin'              => $checkin,
			'checkout'             => $checkout,
			'minDaysBookInAdvance' => $solidresConfig->get('min_days_book_in_advance', 0),
			'maxDaysBookInAdvance' => $solidresConfig->get('max_days_book_in_advance', 0),
			'minLengthOfStay'      => $solidresConfig->get('min_length_of_stay', 1),
			'timezone'             => $timezone,
			'itemId'               => $itemId,
			'reservationId'        => $reservationId,
			'datePickerMonthNum'   => $datePickerMonthNum,
			'weekStartDay'         => $weekStartDay,
			'dateFormat'           => $dateFormat, // default format d-m-y
			'jsDateFormat'         => $jsDateFormat,
			'return'               => $return
		);

		echo $form->render('asset.changedates', $displayData);

		$this->app->close();
	}


	public function startOver()
	{
		$id               = $this->input->getUint('id');
		$solidresConfig   = JComponentHelper::getParams('com_solidres');
		$enableAutoScroll = $solidresConfig->get('enable_auto_scroll', 1);

		$this->app->setUserState($this->context . '.room', null);
		$this->app->setUserState($this->context . '.extra', null);
		$this->app->setUserState($this->context . '.guest', null);
		/*$this->app->setUserState($this->context . '.payment', NULL);*/
		$this->app->setUserState($this->context . '.discount', null);
		$this->app->setUserState($this->context . '.deposit', null);
		$this->app->setUserState($this->context . '.coupon', null);
		$this->app->setUserState($this->context . '.token', null);
		$this->app->setUserState($this->context . '.cost', null);
		$this->app->setUserState($this->context . '.checkin', null);
		$this->app->setUserState($this->context . '.checkout', null);
		$this->app->setUserState($this->context . '.room_type_prices_mapping', null);
		$this->app->setUserState($this->context . '.selected_room_types', null);
		$this->app->setUserState($this->context . '.reservation_asset_id', null);
		$this->app->setUserState($this->context . '.current_selected_tariffs', null);
		$this->app->setUserState($this->context . '.room_opt', null);

		$this->setRedirect(JRoute::_('index.php?option=com_solidres&view=reservationasset&id=' . $id . ($enableAutoScroll ? '#form' : ''), false));
	}
}
