<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JLoader::register('SolidresHelper', JPATH_COMPONENT_ADMINISTRATOR . '/helpers/helper.php');
JLoader::register('SolidresControllerReservationBase', JPATH_COMPONENT_ADMINISTRATOR . '/controllers/reservationbase.php');

/**
 * @package       Solidres
 * @subpackage    Reservation
 * @since         0.1.0
 */
class SolidresControllerReservation extends SolidresControllerReservationBase
{
	public function __construct($config = array())
	{
		$this->view_item = 'reservation';
		$this->view_list = 'reservations';
		parent::__construct($config);
	}

	/**
	 * Method to save a record.
	 *
	 * @param   string $key    The name of the primary key of the URL variable.
	 * @param   string $urlVar The name of the URL variable if different from the primary key (sometimes required to avoid router collisions).
	 *
	 * @return  boolean  True if successful, false otherwise.
	 *
	 * @since   12.2
	 */
	public function save($key = null, $urlVar = null)
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$model                    = $this->getModel();
		$resTable                 = JTable::getInstance('Reservation', 'SolidresTable');
		$hubDashboard             = $this->app->getUserState($this->context . '.hub_dashboard');
		$isGuestMakingReservation = $this->app->isClient('site') && !$hubDashboard;
		$assetId                  = $this->input->getUInt('id', 0);
		$sendOutgoingEmails       = true;

		if (!$isGuestMakingReservation && SRUtilities::isAssetPartner(JFactory::getUser()->get('id'), $assetId))
		{
			// Get override cost
			$amendData = $this->input->post->get('jform', array(), 'array');

			if (!isset($amendData['sendoutgoingemails']))
			{
				$sendOutgoingEmails = false;
			}

			// Get current cost
			$roomTypePricesMapping = $this->app->getUserState($this->context . '.room_type_prices_mapping');
			$cost                  = $this->app->getUserState($this->context . '.cost');
			$reservationRooms      = $this->app->getUserState($this->context . '.room');
			$reservationGuest      = $this->app->getUserState($this->context . '.guest');
			$deposit               = $this->app->getUserState($this->context . '.deposit');

			$totalPriceTaxExcl               = 0;
			$totalImposedTaxAmount           = 0;
			$totalRoomTypeExtraCostTaxExcl   = 0;
			$totalRoomTypeExtraCostTaxIncl   = 0;
			$totalPerBookingExtraCostTaxIncl = 0;
			$totalPerBookingExtraCostTaxExcl = 0;
			foreach ($amendData['override_cost']['room_types'] as $roomTypeId => $tariffs)
			{
				foreach ($tariffs as $tariffId => $rooms)
				{
					foreach ($rooms as $roomId => $room)
					{
						$totalPriceTaxExcl += $room['total_price_tax_excl'];

						$totalImposedTaxAmount += $room['tax_amount'];
						$roomTotalPriceTaxIncl = $room['total_price_tax_excl'] + $room['tax_amount'];

						$roomTypePricesMapping[$roomTypeId][$tariffId][$roomId]['total_price']          = $roomTotalPriceTaxIncl;
						$roomTypePricesMapping[$roomTypeId][$tariffId][$roomId]['total_price_tax_incl'] = $roomTotalPriceTaxIncl;
						$roomTypePricesMapping[$roomTypeId][$tariffId][$roomId]['total_price_tax_excl'] = $room['total_price_tax_excl'];

						// Override extra cost
						if (is_array($room['extras']))
						{
							foreach ($room['extras'] as $overriddenExtraKey => $overriddenExtraCost)
							{
								$reservationRooms['room_types'][$roomTypeId][$tariffId][$roomId]['extras'][$overriddenExtraKey]['total_extra_cost_tax_incl'] = $overriddenExtraCost['price'] + $overriddenExtraCost['tax_amount'];
								$reservationRooms['room_types'][$roomTypeId][$tariffId][$roomId]['extras'][$overriddenExtraKey]['total_extra_cost_tax_excl'] = $overriddenExtraCost['price'];
								$totalRoomTypeExtraCostTaxIncl                                                                                               += $reservationRooms['room_types'][$roomTypeId][$tariffId][$roomId]['extras'][$overriddenExtraKey]['total_extra_cost_tax_incl'];
								$totalRoomTypeExtraCostTaxExcl                                                                                               += $reservationRooms['room_types'][$roomTypeId][$tariffId][$roomId]['extras'][$overriddenExtraKey]['total_extra_cost_tax_excl'];

							}
						}

					}
				}
			}

			// Override extra per booking if available
			if (is_array($amendData['override_cost']['extras_per_booking']))
			{
				foreach ($amendData['override_cost']['extras_per_booking'] as $overriddenExtraBookingKey => $overriddenExtraBookingCost)
				{
					$reservationGuest['extras'][$overriddenExtraBookingKey]['total_extra_cost_tax_incl'] = $overriddenExtraBookingCost['price'] + $overriddenExtraBookingCost['tax_amount'];
					$reservationGuest['extras'][$overriddenExtraBookingKey]['total_extra_cost_tax_excl'] = $overriddenExtraBookingCost['price'];
					$totalPerBookingExtraCostTaxIncl                                                     += $reservationGuest['extras'][$overriddenExtraBookingKey]['total_extra_cost_tax_incl'];
					$totalPerBookingExtraCostTaxExcl                                                     += $reservationGuest['extras'][$overriddenExtraBookingKey]['total_extra_cost_tax_excl'];
				}
			}

			$totalPriceTaxIncl                                       = $totalPriceTaxExcl + $totalImposedTaxAmount;
			$reservationRooms['total_extra_price_per_room']          = $totalRoomTypeExtraCostTaxIncl;
			$reservationRooms['total_extra_price_tax_incl_per_room'] = $totalRoomTypeExtraCostTaxIncl;
			$reservationRooms['total_extra_price_tax_excl_per_room'] = $totalRoomTypeExtraCostTaxExcl;

			$reservationGuest['total_extra_price_per_booking']          = $totalPerBookingExtraCostTaxIncl;
			$reservationGuest['total_extra_price_tax_incl_per_booking'] = $totalPerBookingExtraCostTaxIncl;
			$reservationGuest['total_extra_price_tax_excl_per_booking'] = $totalPerBookingExtraCostTaxExcl;

			$cost['total_price']          = $totalPriceTaxIncl;
			$cost['total_price_tax_incl'] = $totalPriceTaxIncl;
			$cost['total_price_tax_excl'] = $totalPriceTaxExcl;
			$cost['tax_amount']           = $totalImposedTaxAmount;
			$deposit['deposit_amount']    = $amendData['override_cost']['deposit_amount'];

			// Update existing prices with overridden prices
			$this->app->setUserState($this->context . '.cost', $cost);
			$this->app->setUserState($this->context . '.room_type_prices_mapping', $roomTypePricesMapping);
			$this->app->setUserState($this->context . '.room', $reservationRooms);
			$this->app->setUserState($this->context . '.guest', $reservationGuest);
			$this->app->setUserState($this->context . '.deposit', $deposit);
		}

		// Get the data from user state and build a correct array that is ready to be stored
		$this->prepareSavingData();

		$isNew = true;
		if (isset($this->reservationData['id']) && $this->reservationData['id'] > 0)
		{
			$isNew = false;
		}

		if (!$model->save($this->reservationData))
		{
			// Fail, turn back and correct
			$msg       = JText::_('SR_RESERVATION_SAVE_ERROR');
			$returnUrl = 'index.php?option=com_solidres&Itemid=' . $this->app->getUserState($this->context . '.activeItemId') .
				'&task=reservationasset.checkavailability&id=' . $this->reservationData['reservation_asset_id'] .
				'&checkin=' . $this->reservationData['checkin'] .
				'&checkout=' . $this->reservationData['checkout'];

			$roomsOccupancyOptions = $this->app->getUserState($this->context . '.room_opt');
			if (count($roomsOccupancyOptions) > 0)
			{
				for ($r = 1, $rCount = count($roomsOccupancyOptions); $r <= $rCount; $r++)
				{
					$returnUrl .=
						"&room_opt[$r][adults]={$roomsOccupancyOptions[$r]['adults']}" .
						"&room_opt[$r][children]={$roomsOccupancyOptions[$r]['children']}";
				}
			}

			$returnUrl = JRoute::_($returnUrl, false);
			$this->setRedirect($returnUrl, $msg);
		}
		else
		{
			// Prepare some data for final layout
			$savedReservationId = $model->getState($model->getName() . '.id');
			$resTable->load($savedReservationId);
			$this->app->setUserState($this->context . '.savedReservationId', $savedReservationId);
			$this->app->setUserState($this->context . '.code', $resTable->code);
			$this->app->setUserState($this->context . '.payment_method_id', $resTable->payment_method_id);
			$this->app->setUserState($this->context . '.customer_firstname', $this->reservationData['customer_firstname']);
			$this->app->setUserState($this->context . '.customer_lastname', $this->reservationData['customer_lastname']);
			$this->app->setUserState($this->context . '.customeremail', $this->reservationData['customer_email']);
			$this->app->setUserState($this->context . '.reservation_asset_name', $this->reservationData['reservation_asset_name']);

			if ($hubDashboard == 0)
			{
				if (!in_array($resTable->payment_method_id, array('paylater', 'bankwire')))
				{
					// Run payment plugin here
					JPluginHelper::importPlugin('solidrespayment', $resTable->payment_method_id);
					$responses  = $this->app->triggerEvent('OnSolidresPaymentNew', array($resTable));
					$document   = JFactory::getDocument();
					$viewType   = $document->getType();
					$viewName   = 'Reservation';
					$viewLayout = 'payment';

					$view = $this->getView($viewName, $viewType, '', array('base_path' => $this->basePath, 'layout' => $viewLayout));
					if (!empty($responses))
					{
						foreach ($responses as $response)
						{
							if ($response === false) continue;
							$view->paymentForm = $response;
						}
					}

					if (!empty($view->paymentForm))
					{
						$view->display();
					}
					else
					{
						$link = JRoute::_('index.php?option=com_solidres&task=reservation.finalize&reservation_id=' . $savedReservationId, false);
						$this->setRedirect($link);
					}
				}
				else
				{
					$link = JRoute::_('index.php?option=com_solidres&task=reservation.finalize&reservation_id=' . $savedReservationId, false);
					$this->setRedirect($link);
				}
			}
			else
			{
				$processOnlinePayment = isset($reservationGuest['processonlinepayment']) ?
					$reservationGuest['processonlinepayment'] : 0;
				if ($resTable->payment_method_id != 'paylater' && $resTable->payment_method_id != 'bankwire' && $processOnlinePayment)
				{
					// Work fine with payment gateway that does not require redirection, for example stripe, authorize.net
					JPluginHelper::importPlugin('solidrespayment', $resTable->payment_method_id);
					$responses = $this->app->triggerEvent('OnSolidresPaymentNew', array($resTable));
				}

				if ($sendOutgoingEmails)
				{
					$this->sendEmail();
				}

				$this->app->setUserState($this->context, null);

				$msg = $isNew ? JText::_('SR_YOUR_RESERVATION_HAS_BEEN_ADDED') : JText::_('SR_YOUR_RESERVATION_HAS_BEEN_AMENDED');

				// Redirect to the list screen.
				$this->setRedirect(
					JRoute::_(
						'index.php?option=' . $this->option . '&view=' . $this->view_list
						. $this->getRedirectToListAppend(), false
					), $msg
				);
			}
		}
	}

	/**
	 * Finalize the reservation process
	 *
	 * @since  0.3.0
	 *
	 * @return void
	 */
	public function finalize()
	{
		JPluginHelper::importPlugin('solidrespayment');
		$reservationId  = $this->input->get('reservation_id', 0, 'int');
		$results        = $this->app->triggerEvent('OnReservationFinalize', array($this->context, &$reservationId));
		$assetParams    = $this->app->getUserState($this->context . '.asset_params');
		$solidresConfig = JComponentHelper::getParams('com_solidres');

		$bookingRequireApproval = 0;
		if (isset($assetParams['booking_require_approval']))
		{
			$bookingRequireApproval = $assetParams['booking_require_approval'];
		}

		$this->app->setUserState($this->context . '.booking_require_approval', $bookingRequireApproval);

		if ($bookingRequireApproval)
		{
			$this->app->setUserState($this->context . '.payment_method_message', JText::sprintf('SR_RESERVATION_COMPLETE_REQUIRE_APPROVAL',
				$this->app->getUserState($this->context . '.customer_firstname'),
				$this->app->getUserState($this->context . '.code'),
				JUri::root())
			);
		}

		$savedReservationId = $this->app->getUserState($this->context . '.savedReservationId');
		$activeItemId       = $this->app->getUserState($this->context . '.activeItemId');

		if ($savedReservationId == $reservationId)
		{
			JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables', 'SolidresTable');
			$tableReservation = JTable::getInstance('Reservation', 'SolidresTable');
			$tableReservation->load($savedReservationId);

			// Show different completion message depends on the payment status, however let ignore the following payment
			// gateways from checking.
			$isPaid = true;
			if (!in_array($tableReservation->payment_method_id, array('paylater', 'bankwire', 'offline')))
			{
				$isPaid = $tableReservation->payment_status == $solidresConfig->get('confirm_payment_state', 1);
			}

			if (!$bookingRequireApproval)
			{
				if (!$isPaid)
				{
					$this->app->setUserState($this->context . '.payment_method_message', JText::sprintf('SR_RESERVATION_PAYMENT_FAILED',
						JUri::root())
					);
				}
				else
				{
					$msg = $this->sendEmail();
				}
			}
			else
			{
				$solidresReservation = SRFactory::get('solidres.reservation.reservation');
				$msg                 = $solidresReservation->sendBookingInquiryNotificationEmail($reservationId);
			}

			if (!is_string($msg))
			{
				$msg = null;
			}

			// Done, we do not need these data, wipe them !!!
			$this->app->setUserState($this->context . '.room', null);
			$this->app->setUserState($this->context . '.extra', null);
			$this->app->setUserState($this->context . '.guest', null);
			$this->app->setUserState($this->context . '.discount', null);
			$this->app->setUserState($this->context . '.deposit', null);
			$this->app->setUserState($this->context . '.coupon', null);
			$this->app->setUserState($this->context . '.token', null);
			$this->app->setUserState($this->context . '.cost', null);
			$this->app->setUserState($this->context . '.checkin', null);
			$this->app->setUserState($this->context . '.checkout', null);
			$this->app->setUserState($this->context . '.room_type_prices_mapping', null);
			$this->app->setUserState($this->context . '.selected_room_types', null);
			$this->app->setUserState($this->context . '.reservation_asset_id', null);
			$this->app->setUserState($this->context . '.current_selected_tariffs', null);
			$this->app->setUserState($this->context . '.room_opt', null);
			$this->app->setUserState($this->context . '.processed_extra_room_daily_rate', null);

			$link = JRoute::_('index.php?option=com_solidres&view=reservation&layout=final&Itemid=' . $activeItemId . '#solidres', false);
			$this->setRedirect($link, $msg);
		}
	}

	public function paymentcallback()
	{
		$callbackData = $this->input->getArray($_REQUEST);
		JPluginHelper::importPlugin('solidrespayment', $callbackData['payment_method_id']);

		$responses = $this->app->triggerEvent('OnSolidresPaymentCallback', array(
			$callbackData['payment_method_id'],
			$callbackData
		));
	}

	protected function redirectPayment($type)
	{
		$app   = JFactory::getApplication();
		$token = $app->input->get('token');

		if ($token && strlen($token) === 32)
		{
			try
			{
				$scope = $app->input->getUint('scope', 0);

				if ($scope && !SRPlugin::isEnabled('experience'))
				{
					throw new RuntimeException('Plugin Solidres Experience not enabled.');
				}

				$db    = JFactory::getDbo();
				$query = $db->getQuery(true)
					->select('a.id');

				if ($scope)
				{
					JTable::addIncludePath(SRPlugin::getAdminPath('experience') . '/tables');
					$reservationTable = JTable::getInstance('ExpReservation', 'SolidresTable');
					$query->from($db->qn('#__sr_experience_reservations', 'a'))
						->where('MD5(CONCAT_WS(' . $db->q(':') . ', a.id, a.code, a.experience_id, a.experience_name)) = ' . $db->q($token));

				}
				else
				{
					JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables');
					$reservationTable = JTable::getInstance('Reservation', 'SolidresTable');
					$query->from($db->qn('#__sr_reservations', 'a'))
						->where('MD5(CONCAT_WS(' . $db->q(':') . ', a.id, a.code, a.reservation_asset_id, a.reservation_asset_name)) = ' . $db->q($token));
				}

				$db->setQuery($query);
				$reservationId = $db->loadResult();

				if ($reservationId
					&& $reservationTable
					&& $reservationTable->load($reservationId)
				)
				{
					$identifier     = $app->input->getString('identifier');
					$solidresConfig = JComponentHelper::getParams('com_solidres');

					if ($scope)
					{
						$scopeId                   = (int) $reservationTable->experience_id;
						$property                  = $reservationTable->experience_name;
						$namespace                 = 'experience/payments/' . $identifier;
						$search                    = 'experience/payments/' . $identifier . '_';
						$paymentCancellationStatus = (int) $solidresConfig->get('exp_payment_cancelled_state', 2);
					}
					else
					{
						$scopeId                   = (int) $reservationTable->reservation_asset_id;
						$property                  = $reservationTable->reservation_asset_name;
						$namespace                 = 'payments/' . $identifier;
						$search                    = 'payments/' . $identifier . '/' . $identifier . '_';
						$paymentCancellationStatus = $solidresConfig->get('cancel_payment_state', 2);
					}

					if ($identifier && $scopeId)
					{
						$query = $db->getQuery(true)
							->select('a.data_key, a.data_value')
							->from($db->qn('#__sr_config_data', 'a'))
							->where('a.data_key LIKE ' . $db->q($namespace . ($scope ? '_%' : '/%')))
							->where('a.scope_id = ' . $scopeId);
						$db->setQuery($query);
						$paymentParams = new \Joomla\Registry\Registry;

						if ($rows = $db->loadObjectList())
						{
							foreach ($rows as $row)
							{
								$name  = str_replace($search, '', $row->data_key);
								$value = $row->data_value;

								if (is_string($value)
									&& is_array(json_decode($value, true))
									&& (json_last_error() == JSON_ERROR_NONE)
								)
								{
									$value = json_decode($value, true);
								}

								$paymentParams->set($name, $value);
							}
						}

						if ($type === 'cancel')
						{
							$reservationTable->set('payment_status', $paymentCancellationStatus);
							$reservationTable->store();
						}

						$group = $scope ? 'experience' : 'solidres';
						JPluginHelper::importPlugin($group . 'payment', $identifier);
						$app->triggerEvent('on' . ucfirst($group) . 'Payment' . ucfirst($type), array($reservationTable, $paymentParams));
						$message  = $paymentParams->get($type . '_message');
						$redirect = $paymentParams->get($type . '_redirect');

						if (empty($message))
						{
							$message = JText::sprintf('SR_RESERVATION_' . strtoupper($type) . '_MESSAGE_FORMAT', $reservationTable->code, $property, ucfirst($identifier));
						}

						if ($scope)
						{
							$message = SRExpPayment::parseReplaceMessage($reservationTable, $message);
						}

						if (is_numeric($redirect))
						{
							$query = $db->getQuery(true)
								->select('a.language')
								->from($db->qn('#__menu', 'a'))
								->where('a.client_id = 0')
								->where('a.id =' . (int) $redirect);
							$db->setQuery($query);
							$language = $db->loadResult();
							$redirect = 'index.php?Itemid=' . (int) $redirect;

							if ($language !== '*')
							{
								$redirect .= '&lang=' . $language;
							}
						}

						if (empty($redirect) || !JUri::isInternal($redirect))
						{
							$redirect = 'index.php';
						}

						if ($redirect == 'index.php')
						{
							$redirect = JUri::root();
						}
						else
						{
							$redirect = JRoute::_($redirect, false);
						}

						$app->redirect($redirect, trim($message));
					}

				}
			}
			catch (RuntimeException $e)
			{

			}
		}

		$app->redirect('index.php');
	}

	public function cancelPayment()
	{
		$this->redirectPayment('cancel');
	}

	public function returnPayment()
	{
		$this->redirectPayment('return');
	}
}
