<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

/**
 * Coupon Form controller class.
 *
 * @package     Solidres
 * @subpackage	Coupon
 * @since		0.6.0
 */
class SolidresControllerMyProfile extends JControllerLegacy
{
	public function __construct($config = array())
	{
		parent::__construct($config = array());

		$this->registerTask('apply', 'save');
	}
	/**
	 * Method to check out a user for editing and redirect to the edit form.
	 *
	 * @since   1.6
	 */
	public function edit()
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$loginUserId = (int) $user->get('id');
		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables', 'SolidresTable');

		// Get the previous user id (if any) and the current user id.
		$previousId = (int) $app->getUserState('com_solidres.edit.myprofile.id');
		$customerId = $this->input->getInt('id', null, 'array');
		$customerTable = JTable::getInstance('Customer', 'SolidresTable');
		$customerTable->load($customerId);
		$userId = $customerTable->user_id;

		// Check if the user is trying to edit another users profile.
		if ($userId != $loginUserId)
		{
			JError::raiseError(403, JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}

		$cookieLogin = $user->get('cookieLogin');

		// Check if the user logged in with a cookie
		if (!empty($cookieLogin))
		{
			// If so, the user must login to edit the password and other data.
			$app->enqueueMessage(JText::_('JGLOBAL_REMEMBER_MUST_LOGIN'), 'message');
			$this->setRedirect(JRoute::_('index.php?option=com_users&view=login&return=' . base64_encode(JRoute::_('index.php?option=com_solidres&view=myprofile&layout=edit')), false));

			return false;
		}

		// Set the user id for the user to edit in the session.
		$app->setUserState('com_solidres.edit.myprofile.id', $customerId);

		// Redirect to the edit screen.
		$this->setRedirect(JRoute::_('index.php?option=com_solidres&view=myprofile&layout=edit', false));
	}

	/**
	 * Method to save a user's profile data.
	 *
	 * @return  void
	 * @since   1.6
	 */
	public function save()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app	= JFactory::getApplication();
		$model	= $this->getModel('MyProfile', 'SolidresModel');
		$user	= JFactory::getUser();
		$userId	= (int) $user->get('id');

		// Get the user data.
		$data = $app->input->post->get('jform', array(), 'array');

		// Force the ID to this user.
		$data['user_id'] = $userId;

		// Validate the posted data.
		$form = $model->getForm();
		if (!$form)
		{
			JError::raiseError(500, $model->getError());
			return false;
		}

		// Validate the posted data.
		$data = $model->validate($form, $data);

		// Check for errors.
		if ($data === false)
		{
			// Get the validation messages.
			$errors	= $model->getErrors();

			// Push up to three validation messages out to the user.
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
			{
				if ($errors[$i] instanceof Exception)
				{
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				}
				else
				{
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}

			// Save the data in the session.
			$app->setUserState('com_solidres.edit.myprofile.data', $data);

			// Redirect back to the edit screen.
			$customerId = (int) $app->getUserState('com_solidres.edit.myprofile.id');
			$this->setRedirect(JRoute::_('index.php?option=com_solidres&view=myprofile&layout=edit&id=' . $customerId, false));
			return false;
		}

		// Attempt to save the data.
		$return	= $model->save($data);

		// Check for errors.
		if ($return === false)
		{
			// Save the data in the session.
			$app->setUserState('com_solidres.edit.myprofile.data', $data);

			// Redirect back to the edit screen.
			$customerId = (int) $app->getUserState('com_solidres.edit.myprofile.id');
			$this->setMessage(JText::sprintf('SR_PROFILE_SAVE_FAILED', $model->getError()), 'warning');
			$this->setRedirect(JRoute::_('index.php?option=com_solidres&view=myprofile&layout=edit&id=' . $customerId, false));
			return false;
		}

		// Redirect the user and adjust session state based on the chosen task.
		switch ($this->getTask())
		{
			case 'apply':
			default:
				// Redirect back to the edit screen.
				$this->setMessage(JText::_('SR_PROFILE_SAVE_SUCCESS'));
				$this->setRedirect(JRoute::_(($redirect = $app->getUserState('com_solidres.edit.myprofile.redirect')) ? $redirect : 'index.php?option=com_solidres&view=myprofile&layout=edit&hidemainmenu=1', false));
				break;
		}

		// Flush the data from the session.
		$app->setUserState('com_solidres.edit.myprofile.data', null);
	}

	public function cancel()
	{
		$this->setRedirect(JRoute::_('index.php?option=com_solidres&view=customer', false));
	}
}