<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JLoader::register('SRUtilities', SRPATH_LIBRARY . '/utilities/utilities.php');
JLoader::import('joomla.filesystem.folder');

/**
 * System view class
 *
 * @package       Solidres
 * @subpackage    System
 * @since         0.6.0
 */
class SolidresViewSystem extends JViewLegacy
{
	protected $solidresPlugins = array(
		'content'           => array(
			'solidres'
		),
		'extension'         => array(
			'solidres'
		),
		'system'            => array(
			'solidres'
		),
		'solidres'          => array(
			'simple_gallery',
			'hub',
			'channelmanager',
			'acl',
			'advancedextra',
			'camera_slideshow',
			'complextariff',
			'currency',
			'customfield',
			'discount',
			'facebook',
			'feedback',
			'flexsearch',
			'googleanalytics',
			'googleadwords',
			'housekeeping',
			'ical',
			'invoice',
			'limitbooking',
			'loadmodule',
			'rescode',
			'stream',
			'sms',
			'statistics',
			'experience',
			'experienceinvoice',
		),
		'user'              => array(
			'solidres'
		),
		'solidrespayment'   => array(
			'paypal',
			'offline',
			'alipay',
			'atlantic',
			'authorizenet',
			'braintree',
			'cielo',
			'cimb',
			'easypay',
			'eway',
			'migs',
			'mercadopago',
			'mollie',
			'onlinepay',
			'paydollar',
			'payfast',
			'paypal_pro',
			'payplug',
			'postfinance',
			'stripe',
			'unionpay'
		),
		'experiencepayment' => array(
			'bankwire',
			'paylater',
			'authorizenet',
			'paypal',
			'paypalpro',
			'stripe'
		)
	);

	protected $solidresModules = array(
		'mod_sr_checkavailability',
		'mod_sr_currency',
		'mod_sr_availability',
		'mod_sr_camera',
		'mod_sr_clocks',
		'mod_sr_coupons',
		'mod_sr_extras',
		'mod_sr_feedbacks',
		'mod_sr_map',
		'mod_sr_quicksearch',
		'mod_sr_roomtypes',
		'mod_sr_statistics',
		'mod_sr_vegas',
		'mod_sr_tracking',
		'mod_sr_experience_extras',
		'mod_sr_experience_list',
		'mod_sr_experience_filter',
		'mod_sr_experience_search',
		'mod_sr_experience_tracking',
		'mod_sr_advancedsearch',
		'mod_sr_assets',
		'mod_sr_filter',
		'mod_sr_locationmap',
		'mod_sr_myrecentsearches',
		'mod_sr_surroundings',
	);

	protected $solidresTemplates = array();
	protected $languageFiles = array();
	protected $updates = array();

	public function display($tpl = null)
	{
		$this->addToolbar();

		$dbo   = JFactory::getDbo();
		$query = $dbo->getQuery(true);
		$query->select('COUNT(*)')->from($dbo->quoteName('#__sr_reservation_assets'));
		$this->hasExistingData = $dbo->setQuery($query)->loadResult();
		$this->updates         = SRUtilities::getUpdates();
		$this->loadProperties();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		$canDo = SolidresHelper::getActions();

		JToolBarHelper::title(JText::_('SR_SUBMENU_SYSTEM'), 'generic.png');
		require_once JPATH_COMPONENT . '/helpers/toolbar.php';
		SRToolBarHelper::customLink('index.php?option=com_solidres', 'JToolbar_Close', 'fa fa-arrow-left');

		if ($canDo->get('core.admin'))
		{
			$token = '&' . JSession::getFormToken() . '=1';
			$url   = 'index.php?option=com_solidres&task=system.checkUpdates' . $token;
			SRToolBarHelper::customLink($url, 'SR_CHECK_UPDATES', 'fa fa-refresh');

			$url = 'index.php?option=com_solidres&task=system.downloadJson' . $token;
			SRToolBarHelper::customLink($url, 'SR_TOOLBAR_DOWNLOAD_AS_JSON', 'fa fa-download');
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_solidres');
		}
	}

	public function loadProperties()
	{
		$this->solidresTemplates = $this->get('SolidresTemplates');

		$languageFiles = JFolder::files(JPATH_ROOT . '/administrator/components/com_solidres/language', '\.ini$', true, true);
		$languageFiles = array_merge($languageFiles, JFolder::files(JPATH_ROOT . '/components/com_solidres/language', '\.ini$', true, true));

		foreach ($this->solidresModules as $module)
		{
			$moduleAdmin = JPATH_ADMINISTRATOR . '/modules/' . $module . '/language';
			$moduleSite  = JPATH_ROOT . '/modules/' . $module . '/language';

			if (is_dir($moduleAdmin))
			{
				$languageFiles = array_merge($languageFiles, JFolder::files($moduleAdmin, '\.ini$', true, true));
			}
			elseif (is_dir($moduleSite))
			{
				$languageFiles = array_merge($languageFiles, JFolder::files($moduleSite, '\.ini$', true, true));
			}
		}

		foreach ($this->solidresPlugins as $group => $plugins)
		{
			foreach ($plugins as $plugin)
			{
				$pluginLanguagePath = JPATH_PLUGINS . '/' . $group . '/' . $plugin . '/language';

				if (is_dir($pluginLanguagePath))
				{
					$languageFiles = array_merge($languageFiles, JFolder::files($pluginLanguagePath, '\.ini$', true, true));
				}
			}
		}

		if ($this->solidresTemplates)
		{
			foreach ($this->solidresTemplates as $solidresTemplate)
			{
				$templatePath = JPATH_ROOT . '/templates/' . $solidresTemplate->template . '/language';

				if (is_dir($templatePath))
				{
					$languageFiles = array_merge($languageFiles, JFolder::files($templatePath, '\.ini$', true, true));
				}
			}
		}

		$this->languageFiles = $languageFiles;
	}
}