<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class SolidresViewStatuses extends JViewLegacy
{
	protected $state;
	protected $items;
	protected $pagination;
	public $filterForm;
	public $activeFilters;

	public function display($tpl = null)
	{
		$this->state         = $this->get('State');
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', false, true);

		$this->addToolbar();
		parent::display($tpl);

	}

	protected function addToolbar()
	{
		$canDo = SolidresHelper::getActions();
		JToolBarHelper::title(JText::_('SR_MANAGE_STATUSES'));

		if ($canDo->get('core.create'))
		{
			JToolBarHelper::addNew('status.add', 'JTOOLBAR_NEW');
		}

		if ($canDo->get('core.edit.state') && $this->state->get('filter.state') != 2)
		{
			JToolBarHelper::publish('statuses.publish');
			JToolBarHelper::unpublish('statuses.unpublish');
		}

		if ($this->state->get('filter.state') == -2 && $canDo->get('core.delete'))
		{
			JToolBarHelper::deleteList('', 'statuses.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		else if ($canDo->get('core.edit.state'))
		{
			JToolBarHelper::trash('statuses.trash', 'JTOOLBAR_TRASH');
		}

		if ($canDo->get('core.admin'))
		{

			JToolBarHelper::preferences('com_solidres');
		}
	}
}