<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

?>

<fieldset>
    <div class="control-group">
		<?php echo $this->form->getLabel('name'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('name'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('alias'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('alias'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('reservation_asset_id'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('reservation_asset_id'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('is_private'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('is_private'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('is_master'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('is_master'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('occupancy_max'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('occupancy_max'); ?>
            <span class="help-inline">
				<?php echo JText::_('SR_FIELD_OCCUPANCY_MAX_LABEL'); ?>
			</span>
        </div>
        <div class="controls">
			<?php echo $this->form->getInput('occupancy_adult'); ?>
            <span class="help-inline">
				<?php echo JText::_('SR_FIELD_OCCUPANCY_ADULT_LABEL'); ?>
			</span>
        </div>
        <div class="controls">
			<?php echo $this->form->getInput('occupancy_child'); ?>
            <span class="help-inline">
				<?php echo JText::_('SR_FIELD_OCCUPANCY_CHILD_LABEL'); ?>
			</span>
        </div>
        <div class="controls">
			<?php echo $this->form->getInput('occupancy_child_age_range'); ?>
            <span class="help-inline">
				<?php echo JText::_('SR_FIELD_OCCUPANCY_CHILD_AGE_RANGE_LABEL'); ?>
			</span>
        </div>
    </div>
    <div class="control-group default-tariff">
        <label id="jform_price-lbl"
               for="jform_price"
               class="required control-label hasPopover"
               data-content="<?php echo JText::_('SR_FIELD_ROOM_TYPE_PRICE_DESC'); ?>"
               data-original-title="<?php echo JText::_('SR_FIELD_ROOM_TYPE_PRICE_LABEL') ?>">
			<?php echo JText::_('SR_FIELD_ROOM_TYPE_PRICE_LABEL') ?>
            (<?php echo isset($this->form->getValue('currency')->currency_code) ? $this->form->getValue('currency')->currency_code : '' ?>
            )
			<?php if (!$this->enabledComplexTariff) : ?>
                <span class="star">&nbsp;*</span>
			<?php endif ?>
        </label>
        <div class="controls">
			<?php if (SRPlugin::isEnabled('user') && SRPlugin::isEnabled('complextariff')) : ?>
                <div class="alert alert-info">
                    <button type="button" class="close" data-dismiss="alert">×</button>
					<?php echo JText::_('SR_NOTICE_FOR_COMPLEX_TARIFF_PLUGIN') ?>
                </div>
			<?php endif ?>
			<?php echo $this->form->getInput('default_tariff'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('standard_tariff_title'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('standard_tariff_title'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('standard_tariff_description'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('standard_tariff_description'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('coupon_id'); ?>
        <div class="controls">
            <div id="coupon-selection-holder">
				<?php echo $this->form->getInput('coupon_id'); ?>
            </div>
        </div>
    </div>

    <div class="control-group">
		<?php echo $this->form->getLabel('extra_id'); ?>
        <div class="controls">
            <div id="extra-selection-holder">
				<?php echo $this->form->getInput('extra_id'); ?>
            </div>
        </div>
    </div>

    <div class="control-group">
		<?php echo $this->form->getLabel('state'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('state'); ?>
        </div>
    </div>
    <div class="control-group">
		<?php echo $this->form->getLabel('description'); ?>
        <div class="controls">
			<?php echo $this->form->getInput('description'); ?>
        </div>
    </div>
</fieldset>