<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

SRHtml::_('jquery.editable');
$user                    = JFactory::getUser();
$userId                  = $user->get('id');
$listOrder               = $this->state->get('list.ordering');
$listDirn                = $this->state->get('list.direction');
$saveOrder               = $listOrder == 'r.id';
$config                  = JFactory::getConfig();
$timezone                = new DateTimeZone($config->get('offset'));
$reservationStatusesList = SolidresHelper::getStatusesList(0);
$paymentStatusesList     = SolidresHelper::getStatusesList(1);
$statuses                = $paymentStatuses = $statusesColor = $paymentsColor = $source = array();
$lang                    = JFactory::getLanguage();

foreach ($reservationStatusesList as $status)
{
	$statuses[$status->value]      = $status->text;
	$statusesColor[$status->value] = $status->color_code;
}

foreach ($paymentStatusesList as $status)
{
	$paymentStatuses[$status->value] = $status->text;
	$paymentsColor[$status->value]   = $status->color_code;
}

$script =
	' Solidres.jQuery(function($) {
		$.fn.editable.defaults.mode = "inline";
		$( ".state_edit" ).editable({
			url: "' . JRoute::_('index.php?option=com_solidres&task=reservationbase.save&format=json', false) . '",
			source: ' . json_encode($reservationStatusesList) . ',
			success: function(response, newValue) {
				var parent = $(this).parents("tr"); 
		        var span = parent.find("td.reservation-code-row span")
		        span.removeClass(span.attr("class")).addClass("reservation-code reservation-code-" + newValue);
		    }
		});


		$( ".state_edit" ).on("save", function(e, params) {
			' . ((SRPlugin::isEnabled('channelmanager')) ? 'showARIUpdateStatus($(this).data("editable").options.assetid);' : '') . '
		});
	});';
JFactory::getDocument()->addScriptDeclaration($script);
$paymentHistoryModel = JModelLegacy::getInstance('PaymentHistory', 'SolidresModel', ['ignore_request' => true]);
$paymentHistoryModel->setState('filter.scope', 0);
$paymentHistoryModel->setState('list.ordering', 'a.payment_date');
$paymentHistoryModel->setState('list.direction', 'DESC');
$paymentHistoryModel->setState('list.select', 'a.payment_method_txn_id');
$userEnabled    = SRPlugin::isEnabled('user');
$customerFilter = JFactory::getApplication()->input->get('customer', null) !== null;
$canCreate      = $user->authorise('core.create', 'com_solidres');
$canEdit        = $user->authorise('core.edit', 'com_solidres');
$canManage      = $user->authorise('core.manage', 'com_checkin');
$canChange      = $user->authorise('core.edit.state', 'com_solidres');

?>

<div id="solidres">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
		<?php echo SolidresHelperSideNavigation::getSideNavigation($this->getName()); ?>
        <div id="sr_panel_right" class="sr_list_view <?php echo SR_UI_GRID_COL_10 ?>">
            <form action="<?php echo JRoute::_('index.php?option=com_solidres&view=reservations'); ?>" method="post"
                  name="adminForm" id="adminForm">
				<?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th width="1%">
							<?php echo JHtml::_('grid.checkall'); ?>
                        </th>
                        <th class="nowrap hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_ID', 'r.id', $listDirn, $listOrder); ?>
                        </th>
                        <th>
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_RESERVATION_CODE', 'r.code', $listDirn, $listOrder); ?>
                        </th>
                        <th>
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_RESERVATIONASSET', 'reservationasset', $listDirn, $listOrder); ?>
                        </th>
                        <th>
							<?php echo JHtml::_('searchtools.sort', 'SR_RESERVATION_STATUS', 'r.state', $listDirn, $listOrder); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_RESERVATION_CHECKIN', 'r.checkin', $listDirn, $listOrder); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_RESERVATION_CHECKOUT', 'r.checkout', $listDirn, $listOrder); ?>
                        </th>
                        <th>
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_RESERVATION_LENGTH_OF_STAY', 'r.length_of_stay', $listDirn, $listOrder); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_RESERVATION_RESERVED_ROOMS', '', $listDirn, $listOrder); ?>
                        </th>
                        <th>
							<?php echo JHtml::_('searchtools.sort', 'SR_HEADING_RESERVATION_TOTAL_AMOUNT', 'r.total_amount', $listDirn, $listOrder); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JText::_('SR_RESERVATION_PAYMENT_STATUS'); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_RESERVATION_CUSTOMER', 'customer_fullname', $listDirn, $listOrder); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_CUSTOM_FIELD_RESERVATION_CREATE_DATE', 'r.created_date', $listDirn, $listOrder); ?>
                        </th>
                        <th class="hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'SR_RESERVATION_ORIGIN', 'r.origin', $listDirn, $listOrder); ?>
                        </th>
						<?php if (SRPlugin::isEnabled('channelmanager')) : ?>
                            <th class="hidden-phone">
								<?php echo JHtml::_('searchtools.sort', 'SR_RESERVATION_CHANNEL_ORDER_ID', 'r1.cm_channel_order_id', $listDirn, $listOrder); ?>
                            </th>
						<?php endif ?>
                    </tr>
                    </thead>
                    <tbody>
					<?php
					foreach ($this->items as $i => $item) :
						$ordering = ($listOrder == 'a.ordering');
						$canCheckin = $canManage || $item->checked_out == $user->get('id') || $item->checked_out == 0;
						$editLink = JRoute::_('index.php?option=com_solidres&task=reservationbase.edit&id=' . (int) $item->id);
						$reservationMeta = [];
						if (!empty($item->reservation_meta)) :
							$reservationMeta = json_decode($item->reservation_meta, true);
						endif;
						if (!empty($item->payment_method_id)) :
							$lang->load('plg_solidrespayment_' . $item->payment_method_id, JPATH_PLUGINS . '/solidrespayment/' . $item->payment_method_id);
						endif;
						?>
                        <tr class="row<?php echo $i % 2; ?> <?php echo $item->accessed_date == '0000-00-00 00:00:00' ? 'warning' : '' ?>">
                            <td class="center">
								<?php echo JHtml::_('grid.id', $i, $item->id); ?>
                            </td>
                            <td class="hidden-phone">
								<?php echo $item->id; ?>
                            </td>
                            <td class="reservation-code-row">
								<span class="reservation-code-<?php echo $item->state ?> reservation-code">
									<a href="<?php echo $editLink ?>">
										<?php echo $this->escape($item->code); ?>
									</a>
								</span>
								<?php echo ($item->is_approved == 0) ? '<span title="' . JText::_('SR_APPROVAL_NOTICE') . '" class="fa fa-warning approval-notice"></span>' : '' ?>
								<?php if ($item->checkinout_status == 1) : ?>
                                    <span class="fa fa-key"
                                          title="<?php echo JText::_('SR_RESERVATION_CHECKIN_HINT') ?>"></span>
								<?php elseif (is_numeric($item->checkinout_status) && $item->checkinout_status == 0) : ?>
                                    <span class="fa fa-sign-out"
                                          title="<?php echo JText::_('SR_RESERVATION_CHECKOUT_HINT') ?>"></span>
								<?php endif ?>
								<?php if ($item->checked_out) : ?>
									<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'reservations.', $canCheckin); ?>
								<?php endif; ?>
                            </td>
                            <td>
								<?php echo $item->reservation_asset_name; ?>
                            </td>
                            <td>
                                <a href="#"
                                   id="state<?php echo $item->id ?>"
                                   class="state_edit"
                                   data-type="select"
                                   data-name="state"
                                   data-pk="<?php echo $item->id ?>"
                                   data-value="<?php echo $item->state ?>"
                                   data-assetid="<?php echo $item->reservation_asset_id ?>"
                                   data-original-title="">
									<?php echo $statuses[$item->state]; ?>
                                </a>
                            </td>
                            <td class="hidden-phone">
								<?php
								echo JHtml::_('date', $item->checkin, $this->dateFormat, null);
								?>
                            </td>
                            <td class="hidden-phone">
								<?php
								echo JHtml::_('date', $item->checkout, $this->dateFormat, null);
								?>
                            </td>
                            <td>
								<?php
								if ($item->booking_type == 0) :
									echo JText::plural('SR_NIGHTS', $item->length_of_stay);
								else :
									echo JText::plural('SR_DAYS', $item->length_of_stay + 1);
								endif;
								?>
                            </td>
                            <td class="hidden-phone">
								<?php
								if (!empty($reservationMeta) && isset($reservationMeta['reserved_rooms'])) :
									echo implode(', ', $reservationMeta['reserved_rooms']);
								endif;
								?>
                            </td>
                            <td class="sr-align-right">
								<?php
								$baseCurrency = new SRCurrency(0, $item->currency_id);
								$baseCurrency->setValue($item->total_amount);
								echo $baseCurrency->format(); ?>
                            </td>
                            <td class="hidden-phone">
                                <span style="color: <?php echo $paymentsColor[$item->payment_status]; ?>">
								    <?php echo $paymentStatuses[$item->payment_status]; ?><br/>
                                </span>
                                <span class="res-payment-method-id" data-target="<?php echo $item->id ?>">
                                    <?php echo !empty($item->payment_method_id) ? JText::_('SR_PAYMENT_METHOD_' . strtoupper($item->payment_method_id)) . '<br />' : ''; ?>
                                </span>
                                <span id="res-payment-method-txn-id-<?php echo $item->id ?>" style="display: none">
                                <?php $paymentHistoryModel->setState('filter.search', 'reservation:' . $item->id); ?>
									<?php if ($paymentHistories = $paymentHistoryModel->getItems()): ?>

										<?php foreach ($paymentHistories as $paymentHistory): ?>
											<?php if (!empty($paymentHistory->payment_method_txn_id)): ?>
                                                <div>
                                                <i class="fa fa-barcode"></i>
													<?php echo $paymentHistory->payment_method_txn_id; ?>
                                            </div>
											<?php endif; ?>
										<?php endforeach; ?>

									<?php else: ?>
										<?php echo !empty($item->payment_method_txn_id) ? $item->payment_method_txn_id . '<br />' : ''; ?>
									<?php endif; ?>
                                </span>
								<?php
								if (SRPlugin::isEnabled('channelmanager') && isset($item->cm_payment_collect)) :
									echo JText::_('SR_CHANNEL_PAYMENT_COLLECT_' . ($item->cm_payment_collect == 0 ? 'PROPERTY' : 'CHANNEL'));
								endif;
								?>
                            </td>
                            <td class="hidden-phone">
								<?php $customerName = trim($item->customer_firstname . ' ' . $item->customer_middlename . ' ' . $item->customer_lastname); ?>
								<?php echo $customerName; ?>

								<?php if ($canEdit): ?>
									<?php if ($userEnabled && $item->customer_id): ?>
                                        <a class="hasTooltip link-ico"
                                           href="<?php echo JRoute::_('index.php?option=com_solidres&task=customer.edit&id=' . $item->customer_id, false); ?>"
                                           title="<?php echo JText::_('SR_VIEW_PROFILE', true); ?>" target="_blank">
                                            <i class="fa fa-address-card" aria-hidden="true"></i>
                                        </a>
									<?php endif; ?>

									<?php if (!$customerFilter): ?>
										<?php $filterCustomer = 'customer=' . ($item->customer_id ? $item->customer_id : urlencode($customerName)); ?>

                                        <a class="hasTooltip link-ico"
                                           href="<?php echo JRoute::_('index.php?option=com_solidres&view=reservations&' . $filterCustomer, false); ?>"
                                           title="<?php echo JText::_('SR_VIEW_OTHER_RESERVATIONS', true); ?>"
                                           target="_blank">
                                            <i class="fa fa-search-plus" aria-hidden="true"></i>
                                        </a>
									<?php endif; ?>
								<?php endif; ?>
                            </td>
                            <td class="hidden-phone">
								<?php
								//echo JHtml::_('date', $item->created_date, $this->dateFormat);
								echo SRHtml::_('dateRelative', $item->created_date, null, null, $this->dateFormat)
								?>
                            </td>
                            <td class="hidden-phone">
								<?php
								if (SRPlugin::isEnabled('channelmanager')) :
									if (isset(plgSolidresChannelManager::$channelKeyMapping[$item->cm_provider][$item->origin])) :
										echo plgSolidresChannelManager::$channelKeyMapping[$item->cm_provider][$item->origin];
									else:
										echo $item->origin;
									endif;
								endif;
								?>
                            </td>
							<?php if (SRPlugin::isEnabled('channelmanager')) : ?>
                                <td class="hidden-phone">
									<?php echo $item->cm_channel_order_id; ?>
                                </td>
							<?php endif ?>
                        </tr>
					<?php endforeach; ?>
                    </tbody>
                </table>
				<?php echo $this->pagination->getListFooter(); ?>
                <input type="hidden" name="task" value=""/>
                <input type="hidden" name="boxchecked" value="0"/>
				<?php echo JHtml::_('form.token'); ?>
            </form>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
            <p>Powered by <a href="https://www.solidres.com" target="_blank">Solidres</a></p>
        </div>
    </div>
</div>
