<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$user   = JFactory::getUser();
$userId = $user->get('id');
$fields = $this->form->getFieldsets('payments');

if ($id = (int) $this->form->getValue('id', null, 0))
{
	$config   = new SRConfig(array('scope_id' => $id, 'data_namespace' => 'payments/payment_order'));
	$elements = @json_decode($config->get('payments/payment_order/ordering', '{}'), true);

	if (json_last_error() === JSON_ERROR_NONE && !empty($elements))
	{
		$reorderPayments = array();

		foreach ($elements as $element)
		{
			foreach ($fields as $name => $fieldSet)
			{
				if ($element == $name)
				{
					$reorderPayments[$name] = $fieldSet;
					break;
				}
			}
		}

		$fields = array_merge($reorderPayments, $fields);
	}
}

echo JHtml::_('bootstrap.startAccordion', 'paymentOptions', array('active' => 'collapse0'));
$i = 0;
foreach ($fields as $name => $fieldSet) :
	$class = isset($fieldSet->class) && !empty($fieldSet->class) ? $fieldSet->class : '';
	echo JHtml::_('bootstrap.addSlide', 'paymentOptions', '<i class="fa fa-sort"></i> ' . JText::_($fieldSet->label, true), 'collapse' . $i++, $class);

	if (isset($fieldSet->description) && trim($fieldSet->description)) :
		echo '<p class="tip">' . $this->escape(JText::_($fieldSet->description)) . '</p>';
	endif;
	?>

    <input name="payment_order[]" type="hidden"
           value="<?php echo htmlspecialchars($name, ENT_COMPAT, 'UTF-8'); ?>"/>

	<?php foreach ($this->form->getFieldset($name) as $field) : ?>
    <div class="control-group">
        <div class="control-label">
			<?php echo $field->label; ?>
        </div>
        <div class="controls">
			<?php echo $field->input; ?>
        </div>
    </div>
<?php endforeach;

	echo JHtml::_('bootstrap.endSlide');
endforeach;
echo JHtml::_('bootstrap.endAccordion');
