<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('script', 'jui/cms.js', false, true);

JFactory::getDocument()->addScriptDeclaration('
	Solidres.jQuery(document).ready(function($) {
		Solidres.options.load({
			targetId: "' . (int) $this->form->getValue('id') . '",
			uriBase: "' . JUri::base(true) . '/",
			target: "reservation_assets",
			token: "' . JSession::getFormToken() . '"
		});
		
		$("#paymentOptions").sortable();
	});

	Joomla.submitbutton = function(task)
	{
	    if (task != "reservationasset.cancel") {
	        if (Solidres.jQuery("#jform_payments_offline_accepted_cards").length) {
	            if (Solidres.jQuery("#jform_payments_offline_accepted_cards :selected").length == 0) {
                    alert("' . JText::_('SR_PAYMENT_PLUGIN_ACCEPTED_CARD_EMPTY_WARNING') . '");
                    return false;
	            }
	        }
		}
		
		if (task == "reservationasset.cancel" ||  document.formvalidator.isValid(document.getElementById("item-form")))
		{
			' . $this->form->getField('description')->save() . '
			Joomla.submitform(task, document.getElementById("item-form"), false);
		}
	}
');

$plugins = $this->form->getFieldsets('plugins');
?>

<div id="solidres">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
		<?php echo SolidresHelperSideNavigation::getSideNavigation($this->getName()) ?>
        <div id="sr_panel_right" class="sr_form_view <?php echo SR_UI_GRID_COL_10 ?>">
            <div class="sr-inner">
                <form enctype="multipart/form-data"
                      action="<?php JRoute::_('index.php?option=com_solidres&view=reservationassets'); ?>"
                      method="post"
                      name="adminForm" id="item-form" class="form-horizontal">
					<?php echo JHtml::_('bootstrap.startTabSet', 'sr-asset', array('active' => 'general')) ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'general', JText::_('SR_NEW_GENERAL_INFO', true)) ?>
					<?php echo $this->loadTemplate('general') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'publishing', JText::_('JGLOBAL_FIELDSET_PUBLISHING', true)) ?>
					<?php echo $this->loadTemplate('publishing') ?>
					<?php echo $this->loadTemplate('params') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'roomtype', JText::_('SR_ASSET_ROOM_TYPE', true)) ?>
					<?php echo $this->loadTemplate('roomtype') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'media', JText::_('SR_MEDIA', true)) ?>
					<?php echo $this->loadTemplate('media') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'extra', JText::_('SR_ASSET_EXTRA', true)) ?>
					<?php echo $this->loadTemplate('extra') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'customfields', JText::_('SR_CUSTOM_FIELDS', true)) ?>
					<?php echo $this->loadTemplate('customfields') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'metadata', JText::_('SR_METADATA', true)) ?>
					<?php echo $this->loadTemplate('metadata') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'payment', JText::_('SR_PAYMENTMETHODS', true)) ?>
					<?php echo $this->loadTemplate('payments') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'facility', JText::_('SR_FACILITY', true)) ?>
					<?php echo $this->loadTemplate('facility') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'theme', JText::_('SR_THEME', true)) ?>
					<?php echo $this->loadTemplate('theme') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php if (SRPlugin::isEnabled('tripconnect')) : ?>
						<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'amenities', JText::_('SR_AMENITIES', true)) ?>
						<?php echo $this->loadTemplate('amenities') ?>
						<?php echo JHtml::_('bootstrap.endTab') ?>
					<?php endif; ?>

					<?php if (SRPlugin::isEnabled('channelmanager')) : ?>
						<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'channelmanager', JText::_('SR_CHANNEL_MANAGER', true)) ?>
						<?php echo $this->loadTemplate('channelmanager') ?>
						<?php echo JHtml::_('bootstrap.endTab') ?>
					<?php endif; ?>

					<?php if (count($plugins)): ?>
						<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'plugins', JText::_('SR_PLUGINS', true)) ?>
                        <div class="tab-pane" id="plugins">
							<?php
							echo JHtml::_('bootstrap.startAccordion', 'plugin-collapse', array('active' => 'plugin-collapse-0'));
							$i = 0;
							foreach ($plugins as $name => $fieldSet)
							{
								echo JHtml::_('bootstrap.addSlide', 'plugin-collapse', JText::_($fieldSet->label), 'plugin-collapse-' . $i++);
								foreach ($this->form->getFieldset($name) as $field)
								{
									echo $field->renderField();
								}
								echo JHtml::_('bootstrap.endSlide');
							}
							echo JHtml::_('bootstrap.endAccordion'); ?>
                        </div>
						<?php echo JHtml::_('bootstrap.endTab') ?>
					<?php endif; ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'stream', JText::_('SR_STREAM', true)) ?>
					<?php if (SRPlugin::isEnabled('stream')): ?>
						<?php SolidresStreamHelper::displayByScope('reservationasset', $this->form->getValue('id')) ?>
					<?php else: ?>
                        <div class="alert alert-info">
                            This feature allows you listen to all Solidres's events and record them
                        </div>
                        <div class="alert alert-success">
                            <strong>Notice:</strong> plugin <strong>Stream</strong> is not installed or enabled.
                            <a target="_blank"
                               href="https://www.solidres.com/subscribe/levels">Become
                                a subscriber and download it now.</a>
                        </div>
					<?php endif; ?>
					<?php echo JHtml::_('bootstrap.endTab'); ?>

					<?php echo JHtml::_('bootstrap.addTab', 'sr-asset', 'embedForm', JText::_('SR_EMBED_FORM', true)) ?>
					<?php if (!SRPlugin::isEnabled('hub')): ?>
                        <div class="alert alert-info">
                            This feature will generate Check Availability form's embed code for this asset, this embed
                            code can be inserted in external websites and used as a remote Check Availability form,
                            guests use the remote Check Availability form will be redirected to this website to complete
                            reservation.
                        </div>
                        <div class="alert alert-success">
                            <strong>Notice:</strong> plugin <strong>HUB</strong> is not installed or enabled.
                            <a target="_blank"
                               href="https://www.solidres.com/subscribe/levels">Become
                                a subscriber and download it now.</a>
                        </div>
					<?php else: ?>
						<?php
						if ($this->form->getValue('id'))
						{
							SRLayoutHelper::addIncludePath(SRPlugin::getAdminPath('hub') . '/layouts');
							echo SRLayoutHelper::render('embed.form', array('form' => $this->form));
						}
						?>
					<?php endif; ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.endTabSet') ?>

                    <input type="hidden" name="task" value=""/>
					<?php echo JHtml::_('form.token') ?>
                </form>
            </div>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
            <p>Powered by <a href="https://www.solidres.com" target="_blank">Solidres</a></p>
        </div>
    </div>
</div>
