<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');

class SolidresViewPaymentHistory extends JViewLegacy
{
	protected $state;
	protected $items;
	protected $pagination;
	public $filterForm;
	public $activeFilters;

	public function display($tpl = null)
	{
		$this->state         = $this->get('State');
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		if ($errors = $this->get('Errors'))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', false, true);
		$this->addToolbar();
		parent::display($tpl);

	}

	protected function addToolbar()
	{
		JToolBarHelper::title(JText::_('SR_PAYMENT_HISTORY'));
		JToolbarHelper::back('JTOOLBAR_BACK', 'index.php?option=com_solidres');

		if (JFactory::getUser()->authorise('core.admin', 'com_solidres'))
		{
			JToolBarHelper::preferences('com_solidres');
		}
	}
}