<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$srMedia = SRFactory::get('solidres.media.media');

JFactory::getDocument()->addStyleDeclaration('
    .ui-widget button.btn {
      font-size: 13px;
    }    
');
?>

<form action="<?php JRoute::_('index.php?option=com_solidres'); ?>" method="post" name="adminForm"
      id="medialibraryform">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
            <button id="media-library-delete" class="toolbar btn" type="submit">
                <i class="icon-remove"></i>
				<?php echo JText::_('SR_MEDIA_DELETE_BTN'); ?>
            </button>
            <button id="media-library-insert" class="toolbar btn">
                <i class="icon-ok"></i>
				<?php echo JText::_('SR_MEDIA_INSERT_BTN'); ?>
            </button>
            <button id="media-select-all" class="toolbar btn" type="button">
                <i class="icon-checkbox"></i>
				<?php echo JText::_('SR_MEDIA_SELECT_ALL_BTN'); ?>
            </button>
            <button id="media-deselect-all" class="toolbar btn" type="button">
                <i class="icon-checkbox-unchecked"></i>
				<?php echo JText::_('SR_MEDIA_DESELECT_ALL_BTN'); ?>
            </button>
            <button id="media-upload" class="toolbar btn btn-info" type="button">
                <i class="icon-upload"></i>
				<?php echo JText::_('SR_SYSTEM_UPLOAD_FILE'); ?>
            </button>
            <button id="media-toggle" class="toolbar btn btn-default" type="button"
                    data-view-mode="<?php echo $this->layoutId == 'solidres.media.list' ? 'list' : 'grid'; ?>">
				<?php if ($this->layoutId == 'solidres.media.list'): ?>
                    <i class="icon-grid"></i>
				<?php else: ?>
                    <i class="icon-list"></i>
				<?php endif; ?>
            </button>
        </div>
        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
            <div class="input-append pull-right">
                <input id="mediasearch" type="text" name="q" value="">
                <button class="btn" type="submit"><?php echo JText::_('SR_SEARCH'); ?></button>
                <button class="btn" type="reset"><?php echo JText::_('SR_RESET'); ?></button>
            </div>
        </div>
    </div>

    <div id="media-messsage"></div>

    <div id="sr-upload-content">
		<?php require_once __DIR__ . '/form.php'; ?>
    </div>

    <div class="pagination">
		<?php echo $this->pagination->getPagesLinks(); ?>
    </div>

    <div id="medialibrary" class="clearfix">
		<?php echo SRLayoutHelper::render($this->layoutId, array('items' => $this->items)); ?>
    </div>

    <input type="hidden" name="task" value="media.delete"/>
    <input type="hidden" name="format" value="json"/>
	<?php echo JHtml::_('form.token'); ?>
</form>