<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_('behavior.core');

?>
<div style="padding: 15px; text-align: center; border: 1px dashed #ddd">
    <input type="file" name="files" id="uploader" accept="image/*" multiple/>
	<?php echo JText::sprintf('JGLOBAL_MAXIMUM_UPLOAD_SIZE_LIMIT', JHtml::_('number.bytes', JUtility::getMaxUploadSize())); ?>
</div>
<script>
    Solidres.jQuery(document).ready(function ($) {
        var uploader = $('#uploader');
        uploader.on('change', function () {
            if (this.files.length) {
                var formData = new FormData, i, n;
                formData.append('<?php echo JSession::getFormToken(); ?>', 1);

                for (i = 0, n = this.files.length; i < n; i++) {
                    formData.append('files[]', this.files[i]);
                }

                Joomla.loadingLayer('show');
                $.ajax({
                    url: '<?php echo JUri::base(true); ?>/index.php?option=com_solidres&task=media.upload&format=json',
                    type: 'post',
                    dataType: 'json',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        uploader.val('');
                        $('#media-lib-wrap').html($(response.data).html());
                        Joomla.loadingLayer('hide');
                        Joomla.renderMessages(response.messages);
                    }
                });
            }
        });

        if (window.parent && window.parent.jQuery) {
            window.parent.jQuery('#sr-media-modal').on('hide hidden.bs.modal', function () {
                $('#system-message-container').empty();
            });
        }
    });
</script>
