<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFactory::getDocument()->addScriptDeclaration('
    Solidres.jQuery(document).ready(function($) {
		$("#item-form").validate({onsubmit: false});
	});
	
	Joomla.submitbutton = function(task)
	{
		if (task == "extra.cancel" || jQuery("#item-form").valid())
		{
			Solidres.jQuery("#item-form").validate().resetForm();
			Joomla.submitform(task, document.getElementById("item-form"), false);
		} else {
			alert("' . $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')) . '");
		}
	}
');

?>

<div id="solidres">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
		<?php echo SolidresHelperSideNavigation::getSideNavigation($this->getName()); ?>
        <div id="sr_panel_right" class="sr_form_view <?php echo SR_UI_GRID_COL_10 ?>">
            <div class="sr-inner">
                <form action="<?php JRoute::_('index.php?option=com_solidres&view=extras') ?>" method="post"
                      name="adminForm" id="item-form" class="form-validate form-horizontal">
					<?php echo JHtml::_('bootstrap.startTabSet', 'ExtraTab', array('active' => 'general')) ?>

					<?php echo JHtml::_('bootstrap.addTab', 'ExtraTab', 'general', JText::_('SR_NEW_GENERAL_INFO', true)) ?>
					<?php echo $this->form->renderFieldset('general') ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.addTab', 'ExtraTab', 'params', JText::_('JGLOBAL_FIELDSET_PUBLISHING', true)) ?>
					<?php foreach ($this->form->getFieldsets('params') as $name => $fieldSet): ?>
						<?php echo $this->form->renderFieldset($name); ?>
					<?php endforeach; ?>
					<?php echo JHtml::_('bootstrap.endTab') ?>

					<?php echo JHtml::_('bootstrap.endTabSet') ?>
                    <input type="hidden" name="task" value=""/>
					<?php echo JHtml::_('form.token'); ?>
                </form>
            </div>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
            <p>Powered by <a href="https://www.solidres.com" target="_blank">Solidres</a></p>
        </div>
    </div>
</div>
	
