<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * Tax model.
 *
 * @package       Solidres
 * @subpackage    Tax
 * @since         0.1.0
 */
class SolidresModelTax extends JModelAdmin
{
	/**
	 * @var        string    The prefix to use with controller messages.
	 * @since    1.6
	 */
	protected $text_prefix = null;

	/**
	 * @var        string    The event to trigger after deleting the data.
	 * @since    1.6
	 */
	protected $event_after_delete = null;

	/**
	 * @var        string    The event to trigger after saving the data.
	 * @since    1.6
	 */
	protected $event_after_save = null;

	/**
	 * @var        string    The event to trigger after deleting the data.
	 * @since    1.6
	 */
	protected $event_before_delete = null;

	/**
	 * @var        string    The event to trigger after saving the data.
	 * @since    1.6
	 */
	protected $event_before_save = null;

	/**
	 * @var        string    The event to trigger after changing the published state of the data.
	 * @since    1.6
	 */
	protected $event_change_state = null;

	/**
	 * Constructor.
	 *
	 * @param    array An optional associative array of configuration settings.
	 *
	 * @see        JController
	 * @since      1.6
	 */
	public function __construct($config = array())
	{
		parent::__construct($config);

		$this->event_after_delete  = 'onTaxAfterDelete';
		$this->event_after_save    = 'onTaxAfterSave';
		$this->event_before_delete = 'onTaxBeforeDelete';
		$this->event_before_save   = 'onTaxBeforeSave';
		$this->event_change_state  = 'onTaxChangeState';
		$this->text_prefix         = strtoupper($this->option);
	}

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param    object    A record object.
	 *
	 * @return    boolean    True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since    1.6
	 */
	protected function canDelete($record)
	{
		$user = JFactory::getUser();

		return $user->authorise('core.delete', 'com_solidres');
	}

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param    object    A record object.
	 *
	 * @return    boolean    True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since    1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		return $user->authorise('core.edit.state', 'com_solidres');
	}

	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param    string    The table type to instantiate
	 * @param    string    A prefix for the table class name. Optional.
	 * @param    array    Configuration array for model. Optional.
	 *
	 * @return    JTable    A database object
	 * @since    1.6
	 */
	public function getTable($type = 'Tax', $prefix = 'SolidresTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	protected function prepareTable($table)
	{
		if (empty ($table->geo_state_id))
		{
			$table->geo_state_id = null;
		}
	}

	/**
	 * Method to get the record form.
	 *
	 * @param    array   $data     An optional array of data for the form to interogate.
	 * @param    boolean $loadData True if the form is to load its own data (default case), false if not.
	 *
	 * @return    JForm    A JForm object on success, false on failure
	 * @since    1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$form = $this->loadForm('com_solidres.tax', 'tax', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}

		// Determine correct permissions to check.
		if ($this->getState('tax.id'))
		{
			// Existing record. Can only edit in selected categories.
			$form->setFieldAttribute('catid', 'action', 'core.edit');
		}
		else
		{
			// New record. Can only create in selected categories.
			$form->setFieldAttribute('catid', 'action', 'core.create');
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return    mixed    The data for the form.
	 * @since    1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_solidres.edit.tax.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}

	public function getItemByExtra($pk)
	{
		$table = JTable::getInstance('Extra', 'SolidresTable');
		$table->load($pk);
		$data = null;
		$data = $this->getItem($table->tax_id);

		return $data;
	}
}